package kubernetesconfiguration

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AKSIdentityType enumerates the values for aks identity type.
type AKSIdentityType string

const (
	// SystemAssigned ...
	SystemAssigned AKSIdentityType = "SystemAssigned"
	// UserAssigned ...
	UserAssigned AKSIdentityType = "UserAssigned"
)

// PossibleAKSIdentityTypeValues returns an array of possible values for the AKSIdentityType const type.
func PossibleAKSIdentityTypeValues() []AKSIdentityType {
	return []AKSIdentityType{SystemAssigned, UserAssigned}
}

// ComplianceStateType enumerates the values for compliance state type.
type ComplianceStateType string

const (
	// Compliant ...
	Compliant ComplianceStateType = "Compliant"
	// Failed ...
	Failed ComplianceStateType = "Failed"
	// Installed ...
	Installed ComplianceStateType = "Installed"
	// Noncompliant ...
	Noncompliant ComplianceStateType = "Noncompliant"
	// Pending ...
	Pending ComplianceStateType = "Pending"
)

// PossibleComplianceStateTypeValues returns an array of possible values for the ComplianceStateType const type.
func PossibleComplianceStateTypeValues() []ComplianceStateType {
	return []ComplianceStateType{Compliant, Failed, Installed, Noncompliant, Pending}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// Application ...
	Application CreatedByType = "Application"
	// Key ...
	Key CreatedByType = "Key"
	// ManagedIdentity ...
	ManagedIdentity CreatedByType = "ManagedIdentity"
	// User ...
	User CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{Application, Key, ManagedIdentity, User}
}

// FluxComplianceState enumerates the values for flux compliance state.
type FluxComplianceState string

const (
	// FluxComplianceStateCompliant ...
	FluxComplianceStateCompliant FluxComplianceState = "Compliant"
	// FluxComplianceStateNonCompliant ...
	FluxComplianceStateNonCompliant FluxComplianceState = "Non-Compliant"
	// FluxComplianceStatePending ...
	FluxComplianceStatePending FluxComplianceState = "Pending"
	// FluxComplianceStateSuspended ...
	FluxComplianceStateSuspended FluxComplianceState = "Suspended"
	// FluxComplianceStateUnknown ...
	FluxComplianceStateUnknown FluxComplianceState = "Unknown"
)

// PossibleFluxComplianceStateValues returns an array of possible values for the FluxComplianceState const type.
func PossibleFluxComplianceStateValues() []FluxComplianceState {
	return []FluxComplianceState{FluxComplianceStateCompliant, FluxComplianceStateNonCompliant, FluxComplianceStatePending, FluxComplianceStateSuspended, FluxComplianceStateUnknown}
}

// KustomizationValidationType enumerates the values for kustomization validation type.
type KustomizationValidationType string

const (
	// Client ...
	Client KustomizationValidationType = "client"
	// None ...
	None KustomizationValidationType = "none"
	// Server ...
	Server KustomizationValidationType = "server"
)

// PossibleKustomizationValidationTypeValues returns an array of possible values for the KustomizationValidationType const type.
func PossibleKustomizationValidationTypeValues() []KustomizationValidationType {
	return []KustomizationValidationType{Client, None, Server}
}

// LevelType enumerates the values for level type.
type LevelType string

const (
	// Error ...
	Error LevelType = "Error"
	// Information ...
	Information LevelType = "Information"
	// Warning ...
	Warning LevelType = "Warning"
)

// PossibleLevelTypeValues returns an array of possible values for the LevelType const type.
func PossibleLevelTypeValues() []LevelType {
	return []LevelType{Error, Information, Warning}
}

// MessageLevelType enumerates the values for message level type.
type MessageLevelType string

const (
	// MessageLevelTypeError ...
	MessageLevelTypeError MessageLevelType = "Error"
	// MessageLevelTypeInformation ...
	MessageLevelTypeInformation MessageLevelType = "Information"
	// MessageLevelTypeWarning ...
	MessageLevelTypeWarning MessageLevelType = "Warning"
)

// PossibleMessageLevelTypeValues returns an array of possible values for the MessageLevelType const type.
func PossibleMessageLevelTypeValues() []MessageLevelType {
	return []MessageLevelType{MessageLevelTypeError, MessageLevelTypeInformation, MessageLevelTypeWarning}
}

// OperatorScopeType enumerates the values for operator scope type.
type OperatorScopeType string

const (
	// Cluster ...
	Cluster OperatorScopeType = "cluster"
	// Namespace ...
	Namespace OperatorScopeType = "namespace"
)

// PossibleOperatorScopeTypeValues returns an array of possible values for the OperatorScopeType const type.
func PossibleOperatorScopeTypeValues() []OperatorScopeType {
	return []OperatorScopeType{Cluster, Namespace}
}

// OperatorType enumerates the values for operator type.
type OperatorType string

const (
	// Flux ...
	Flux OperatorType = "Flux"
)

// PossibleOperatorTypeValues returns an array of possible values for the OperatorType const type.
func PossibleOperatorTypeValues() []OperatorType {
	return []OperatorType{Flux}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCanceled ...
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	// ProvisioningStateUpdating ...
	ProvisioningStateUpdating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCanceled, ProvisioningStateCreating, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateSucceeded, ProvisioningStateUpdating}
}

// ProvisioningStateType enumerates the values for provisioning state type.
type ProvisioningStateType string

const (
	// ProvisioningStateTypeAccepted ...
	ProvisioningStateTypeAccepted ProvisioningStateType = "Accepted"
	// ProvisioningStateTypeDeleting ...
	ProvisioningStateTypeDeleting ProvisioningStateType = "Deleting"
	// ProvisioningStateTypeFailed ...
	ProvisioningStateTypeFailed ProvisioningStateType = "Failed"
	// ProvisioningStateTypeRunning ...
	ProvisioningStateTypeRunning ProvisioningStateType = "Running"
	// ProvisioningStateTypeSucceeded ...
	ProvisioningStateTypeSucceeded ProvisioningStateType = "Succeeded"
)

// PossibleProvisioningStateTypeValues returns an array of possible values for the ProvisioningStateType const type.
func PossibleProvisioningStateTypeValues() []ProvisioningStateType {
	return []ProvisioningStateType{ProvisioningStateTypeAccepted, ProvisioningStateTypeDeleting, ProvisioningStateTypeFailed, ProvisioningStateTypeRunning, ProvisioningStateTypeSucceeded}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// ResourceIdentityTypeSystemAssigned ...
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{ResourceIdentityTypeSystemAssigned}
}

// ScopeType enumerates the values for scope type.
type ScopeType string

const (
	// ScopeTypeCluster ...
	ScopeTypeCluster ScopeType = "cluster"
	// ScopeTypeNamespace ...
	ScopeTypeNamespace ScopeType = "namespace"
)

// PossibleScopeTypeValues returns an array of possible values for the ScopeType const type.
func PossibleScopeTypeValues() []ScopeType {
	return []ScopeType{ScopeTypeCluster, ScopeTypeNamespace}
}

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// Basic ...
	Basic SkuTier = "Basic"
	// Free ...
	Free SkuTier = "Free"
	// Premium ...
	Premium SkuTier = "Premium"
	// Standard ...
	Standard SkuTier = "Standard"
)

// PossibleSkuTierValues returns an array of possible values for the SkuTier const type.
func PossibleSkuTierValues() []SkuTier {
	return []SkuTier{Basic, Free, Premium, Standard}
}

// SourceKindType enumerates the values for source kind type.
type SourceKindType string

const (
	// AzureBlob ...
	AzureBlob SourceKindType = "AzureBlob"
	// Bucket ...
	Bucket SourceKindType = "Bucket"
	// GitRepository ...
	GitRepository SourceKindType = "GitRepository"
)

// PossibleSourceKindTypeValues returns an array of possible values for the SourceKindType const type.
func PossibleSourceKindTypeValues() []SourceKindType {
	return []SourceKindType{AzureBlob, Bucket, GitRepository}
}
