<!--
Copyright (C) Daniel Stenberg, <daniel@haxx.se>, et al.

SPDX-License-Identifier: curl
-->

# Security Policy

Read our [Vulnerability Disclosure Policy](docs/VULN-DISCLOSURE-POLICY.md).

## Reporting a Vulnerability

If you have found or just suspect a security problem somewhere in curl or
libcurl, report it on [HackerOne](https://hackerone.com/curl).

We treat security issues with confidentiality until controlled and disclosed responsibly.

## OpenSSF Best Practices

curl has achieved Gold status on the Open Source Security Foundation (OpenSSF)
[Best Practices](https://bestpractices.dev/) (formerly Core Infrastructure
Initiative Best Practices), reflecting its adherence to rigorous
security and best practice standards. This achievement highlights curl's
comprehensive documentation, secure development processes, effective change
control mechanisms, and strong maintenance routines. Meeting these criteria
demonstrates curl's commitment to security and reliability, ensuring the
project's sustainability and trustworthiness. This underscores curl's role as
a leader in open-source software practices. More information can be found on
[curl's OpenSSF Best Practices project page](https://www.bestpractices.dev/projects/63).
