/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.view;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.IViewDescriptor;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetErrorAction;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetErrorActionDescriptor;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetErrorActionRegistry;
import org.jkiss.dbeaver.ui.dialogs.EditTextDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;

class ErrorDetailsPart {
    private static final Log log = Log.getLog(ErrorDetailsPart.class);
    private final Composite parent;
    private final IStatus reason;

    ErrorDetailsPart(Composite parent, IStatus reason, @NotNull IResultSetContainer resultSetContainer) {
        this.parent = parent;
        this.reason = reason;
        parent.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(5, 0, 5, 5).numColumns(2).create());
        Label imageLabel = new Label(parent, 0);
        imageLabel.setImage(this.getImage());
        imageLabel.setLayoutData((Object)new GridData(66));
        StyledText text = new StyledText(parent, 2634);
        text.setLayoutData((Object)new GridData(1808));
        text.setText(GeneralUtils.normalizeLineSeparators((String)reason.getMessage()));
        text.setFont(UIUtils.getMonospaceFont());
        text.addListener(11, e -> {
            Point size = text.getSize();
            if (size.y > 100) {
                ((GridData)styledText.getLayoutData()).heightHint = 100;
                parent.layout(true);
            }
        });
        Composite buttonParent = new Composite(parent, 0);
        buttonParent.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        buttonParent.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        buttonParent.setBackground(parent.getBackground());
        new Label(buttonParent, 0).setLayoutData((Object)new GridData(4, 1, true, false));
        for (ResultSetErrorActionDescriptor descriptor : ResultSetErrorActionRegistry.getInstance().getActions()) {
            IResultSetErrorAction action;
            try {
                action = descriptor.createInstance();
            }
            catch (DBException e2) {
                log.error((Object)("Can't create error action '" + descriptor.getLabel() + "'"), (Throwable)e2);
                continue;
            }
            if (!action.isVisible(resultSetContainer, this.reason)) continue;
            UIUtils.createDialogButton((Composite)buttonParent, (String)descriptor.getLabel(), (DBPImage)descriptor.getIcon(), (String)descriptor.getDescription(), (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> action.perform(resultSetContainer, this.reason)));
            ++((GridLayout)buttonParent.getLayout()).numColumns;
        }
        this.createShowLogButton(buttonParent);
        this.createDetailsButton(buttonParent);
    }

    private Image getImage() {
        return switch (this.reason.getSeverity()) {
            case 4 -> DBeaverIcons.getImage((DBPImage)DBIcon.STATUS_ERROR);
            case 2 -> DBeaverIcons.getImage((DBPImage)DBIcon.STATUS_WARNING);
            default -> DBeaverIcons.getImage((DBPImage)DBIcon.STATUS_INFO);
        };
    }

    private void showDetails() {
        EditTextDialog dialog = new EditTextDialog(this.parent.getShell(), "Error details", this.getDetails(this.reason), true);
        dialog.setMonospaceFont(true);
        dialog.setAutoSize(true);
        dialog.open();
    }

    private String getDetails(IStatus status) {
        if (status.getException() != null) {
            return GeneralUtils.normalizeLineSeparators((String)this.getStackTrace(status.getException()));
        }
        return "";
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter swriter = new StringWriter();
        Throwable throwable2 = null;
        Object var4_5 = null;
        try (PrintWriter pwriter = new PrintWriter(swriter);){
            throwable.printStackTrace(pwriter);
            pwriter.flush();
        }
        catch (Throwable throwable3) {
            if (throwable2 == null) {
                throwable2 = throwable3;
            } else if (throwable2 != throwable3) {
                throwable2.addSuppressed(throwable3);
            }
            throw throwable2;
        }
        return swriter.toString();
    }

    private void createShowLogButton(Composite parent) {
        IViewDescriptor descriptor = PlatformUI.getWorkbench().getViewRegistry().find("org.eclipse.pde.runtime.LogView");
        if (descriptor == null) {
            return;
        }
        Button button = UIUtils.createDialogButton((Composite)parent, (String)"Show log", null, (String)WorkbenchMessages.ErrorLogUtil_ShowErrorLogTooltip, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.pde.runtime.LogView");
            }
            catch (CoreException ce) {
                StatusManager.getManager().handle(ce, WorkbenchPlugin.PI_WORKBENCH);
            }
        }));
        Image image = descriptor.getImageDescriptor().createImage();
        button.setImage(image);
        button.addDisposeListener(e -> image.dispose());
    }

    private void createDetailsButton(@NotNull Composite parent) {
        if (this.reason.getException() == null) {
            return;
        }
        UIUtils.createDialogButton((Composite)parent, (String)IDialogConstants.SHOW_DETAILS_LABEL, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.showDetails()));
    }
}

