# Language Support in Zed

Zed supports hundreds of programming languages and text formats.
Some work out-of-the box and others rely on 3rd party extensions.

> The ones included out-of-the-box, natively built into Zed, are marked with \*.

## Languages with Documentation

- [Ansible](./languages/ansible.md)
- [AsciiDoc](./languages/asciidoc.md)
- [Astro](./languages/astro.md)
- [Bash](./languages/bash.md)
- [Biome](./languages/biome.md)
- [C](./languages/c.md) \*
- [C++](./languages/cpp.md) \*
- [C#](./languages/csharp.md)
- [Clojure](./languages/clojure.md)
- [CSS](./languages/css.md) \*
- [Dart](./languages/dart.md)
- [Deno](./languages/deno.md)
- [Diff](./languages/diff.md) \*
- [Docker](./languages/docker.md)
- [Elixir](./languages/elixir.md)
- [Elm](./languages/elm.md)
- [Emmet](./languages/emmet.md)
- [Erlang](./languages/erlang.md)
- [Fish](./languages/fish.md)
- [GDScript](./languages/gdscript.md)
- [Gleam](./languages/gleam.md)
- [GLSL](./languages/glsl.md)
- [Go](./languages/go.md) \*
- [Groovy](./languages/groovy.md)
- [Haskell](./languages/haskell.md)
- [Helm](./languages/helm.md)
- [HTML](./languages/html.md)
- [Java](./languages/java.md)
- [JavaScript](./languages/javascript.md) \*
- [Julia](./languages/julia.md)
- [JSON](./languages/json.md) \*
- [Jsonnet](./languages/jsonnet.md)
- [Kotlin](./languages/kotlin.md)
- [Lua](./languages/lua.md)
- [Luau](./languages/luau.md)
- [Makefile](./languages/makefile.md)
- [Markdown](./languages/markdown.md) \*
- [Nim](./languages/nim.md)
- [OCaml](./languages/ocaml.md)
- [PHP](./languages/php.md)
- [Prisma](./languages/prisma.md)
- [Proto](./languages/proto.md)
- [PureScript](./languages/purescript.md)
- [Python](./languages/python.md) \*
- [R](./languages/r.md)
- [Rego](./languages/rego.md)
- [ReStructuredText](./languages/rst.md)
- [Racket](./languages/racket.md)
- [Roc](./languages/roc.md)
- [Ruby](./languages/ruby.md)
- [Rust](./languages/rust.md) \* (Zed's written in Rust)
- [Scala](./languages/scala.md)
- [Scheme](./languages/scheme.md)
- [Shell Script](./languages/sh.md)
- [Svelte](./languages/svelte.md)
- [Swift](./languages/swift.md)
- [Tailwind CSS](./languages/tailwindcss.md) \*
- [Terraform](./languages/terraform.md)
- [TOML](./languages/toml.md)
- [TypeScript](./languages/typescript.md) \*
- [Uiua](./languages/uiua.md)
- [Vue](./languages/vue.md)
- [XML](./languages/xml.md)
- [YAML](./languages/yaml.md) \*
- [Yara](./languages/yarn.md)
- [Yarn](./languages/yarn.md)
- [Zig](./languages/zig.md)

## Additional Community Language Extensions

- [Ada](https://github.com/wisn/zed-ada-language)
- [Aiken](https://github.com/aiken-lang/zed-aiken)
- [Amber](https://github.com/amber-lang/zed-amber-extension)
- [Assembly](https://github.com/DevBlocky/zed-asm)
- [AWK](https://github.com/dangh/zed-awk)
- [Beancount](https://github.com/zed-extensions/beancount)
- [Bend](https://github.com/mrpedrobraga/zed-bend)
- [Blade](https://github.com/bajrangCoder/zed-laravel-blade)
- [Blueprint](https://github.com/tfuxu/zed-blueprint)
- [BQN](https://github.com/DavidZwitser/zed-bqn)
- [Brainfuck](https://github.com/JosephTLyons/zed-brainfuck)
- [Cadence](https://github.com/janezpodhostnik/cadence.zed)
- [Cairo](https://github.com/trbutler4/zed-cairo)
- [Cap'n Proto](https://github.com/cmackenzie1/zed-capnp)
- [Cedar](https://github.com/chrnorm/zed-cedar)
- [CFEngine policy language](https://github.com/olehermanse/zed-cfengine)
- [CSV](https://github.com/huacnlee/zed-csv)
- [Cucumber/Gherkin](https://github.com/thlcodes/zed-extension-cucumber)
- [CUE](https://github.com/jkasky/zed-cue)
- [Curry](https://github.com/fwcd/zed-curry)
- [D](https://github.com/staysail/zed-d)
- [Database Markup Language (DBML)](https://github.com/shuklaayush/zed-dbml)
- [Earthfile](https://github.com/glehmann/earthfile.zed)
- [EJS template](https://github.com/dangh/zed-ejs)
- [Elisp](https://github.com/JosephTLyons/zed-elisp)
- [Ember](https://github.com/jylamont/zed-ember)
- [Env](https://github.com/zarifpour/zed-env)
- [Exograph](https://github.com/exograph/zed-extension)
- [Fortran](https://github.com/Xavier-Maruff/zed-fortran)
- [F#](https://github.com/nathanjcollins/zed-fsharp)
- [Gemini gemtext](https://github.com/clseibold/gemini-zed)
- [Git Firefly](https://github.com/d1y/git_firefly)
- [GraphQL](https://github.com/11bit/zed-extension-graphql)
- [Groq](https://github.com/juice49/zed-groq)
- [INI](https://github.com/bajrangCoder/zed-ini)
- [Java](https://github.com/zed-extensions/java)
- [Justfiles](https://github.com/jackTabsCode/zed-just)
- [LaTeX](https://github.com/rzukic/zed-latex)
- [Ledger](https://github.com/mrkstwrt/zed-ledger)
- [Less](https://github.com/jimliang/zed-less)
- [LilyPond](https://github.com/nwhetsell/lilypond-zed-extension)
- [Liquid](https://github.com/TheBeyondGroup/zed-shopify-liquid)
- [Log](https://github.com/evrensen467/zed-log)
- [Lox](https://github.com/arian81/zed-lox)
- [Markdown Oxide](https://github.com/Feel-ix-343/markdown-oxide-zed)
- [Marksman](https://github.com/vitallium/zed-marksman)
- [Matlab](https://github.com/rzukic/zed-matlab)
- [Meson](https://github.com/hqnna/zed-meson)
- [Navi](https://github.com/navi-language/zed-navi)
- [NeoCMake](https://github.com/k0tran/zed_neocmake)
- [Nginx](https://github.com/d1y/nginx-zed)
- [Nim](https://github.com/foxoman/zed-nim)
- [Nix](https://github.com/zed-extensions/nix)
- [Noir](https://github.com/shuklaayush/zed-noir)
- [Nu](https://github.com/zed-extensions/nu)
- [Odin](https://github.com/rxptr/zed-odin)
- [Pact](https://github.com/kadena-community/pact-zed)
- [Pest](https://github.com/pest-parser/zed-pest)
- [PICA200 assembly](https://github.com/Squareheron942/zed-pica200)
- [Pkl](https://github.com/Moshyfawn/pkl-zed)
- [PlaydateSDK](https://github.com/notpeter/playdate-zed-extension)
- [QML](https://github.com/lkroll/zed-qml)
- [Rainbow CSV](https://github.com/weartist/zed-rainbow-csv)
- [Rego](https://github.com/StyraInc/zed-rego)
- [Rescript](https://github.com/humaans/rescript-zed)
- [Roclang](https://github.com/h2000/zed-roc)
- [Ron](https://github.com/onbjerg/zed-ron)
- [Metals](https://github.com/scalameta/metals-zed)
- [SCSS](https://github.com/bajrangCoder/zed-scss)
- [Slim](https://github.com/calmyournerves/zed-slim)
- [Slint](https://gitlab.com/flukejones/zed-slint)
- [Smithy](https://github.com/joshrutkowski/zed-smithy)
- [Solidity](https://github.com/zarifpour/zed-solidity)
- [SQL](https://github.com/evrensen467/zed-sql)
- [Strace](https://github.com/sigmaSd/zed-strace)
- [Swift](https://github.com/zed-extensions/swift)
- [Templ](https://github.com/makifdb/zed-templ)
- [Tmux](https://github.com/dangh/zed-tmux)
- [Tree-sitter Query](https://github.com/vitallium/zed-tree-sitter-query)
- [Twig](https://github.com/YussufSassi/zed-twig)
- [Typst](https://github.com/WeetHet/typst.zed)
- [Unison](https://github.com/zetashift/unison-zed)
- [UnoCSS](https://github.com/bajrangCoder/zed-unocss)
- [Vlang](https://github.com/lv37/zed-v)
- [Vala](https://github.com/FyraLabs/zed-vala)
- [Vale](https://github.com/koozz/zed-vale)
- [Verilog](https://github.com/someone13574/zed-verilog-extension)
- [VHS](https://github.com/eth0net/zed-vhs)
- [Wgsl](https://github.com/luan/zed-wgsl)
- [WIT](https://github.com/valentinegb/zed-wit)
