/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.Metadata;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.Assert;

public class MethodCounters
extends Metadata {
    private static CIntField interpreterInvocationCountField;
    private static CIntField interpreterThrowoutCountField;
    private static CIntField invocationCounter;
    private static CIntField backedgeCounter;

    public MethodCounters(Address addr) {
        super(addr);
    }

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("MethodCounters");
        interpreterInvocationCountField = new CIntField(type.getCIntegerField("_interpreter_invocation_count"), 0L);
        interpreterThrowoutCountField = new CIntField(type.getCIntegerField("_interpreter_throwout_count"), 0L);
        if (!VM.getVM().isCore()) {
            invocationCounter = new CIntField(type.getCIntegerField("_invocation_counter"), 0L);
            backedgeCounter = new CIntField(type.getCIntegerField("_backedge_counter"), 0L);
        }
    }

    public int interpreterInvocationCount() {
        return (int)interpreterInvocationCountField.getValue(this);
    }

    public int interpreterThrowoutCount() {
        return (int)interpreterThrowoutCountField.getValue(this);
    }

    public long getInvocationCounter() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(!VM.getVM().isCore(), "must not be used in core build");
        }
        return invocationCounter.getValue(this);
    }

    public long getBackedgeCounter() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(!VM.getVM().isCore(), "must not be used in core build");
        }
        return backedgeCounter.getValue(this);
    }

    @Override
    public void printValueOn(PrintStream tty) {
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                MethodCounters.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

