:: Generated by vinca http://github.com/RoboStack/vinca.
:: DO NOT EDIT!
setlocal EnableDelayedExpansion

:: Rattler-build will not set the SRC_DIR anymore so we set it through templating
set "SRC_DIR=@SRC_DIR@"

set "BUILD_DIR=@BUILD_DIR@"
set "BUILD_TYPE=@BUILD_TYPE@"

set "PYTHONPATH=%LIBRARY_PREFIX%\lib\site-packages;%SP_DIR%"

:: MSVC is preferred.
set CC=cl.exe
set CXX=cl.exe

:: Create build directory when not available
if not exist "%BUILD_DIR%" mkdir "%BUILD_DIR%"
pushd %BUILD_DIR%

set "CMAKE_GENERATOR=Ninja"
:: We use the Visual Studio generator as a workaround for
:: problems in Ninja when using long paths, see https://github.com/RoboStack/ros-humble/pull/229#issuecomment-2564856467
:: Once those are solved, we can switch back to use Ninja
:: set "CMAKE_GENERATOR=Visual Studio %VS_MAJOR% %VS_YEAR%"

:: PYTHON_INSTALL_DIR should be a relative path, see
:: https://github.com/ament/ament_cmake/blob/2.3.2/ament_cmake_python/README.md
:: So we compute the relative path of %SP_DIR% w.r.t. to LIBRARY_PREFIX,
:: but it is not trivial to do this in Command Prompt scripting, so let's do it via
:: python

:: This line is scary, but it basically assigns the output of the command inside (` and `)
:: to the variable specified after DO SET
:: The equivalent in bash is PYTHON_INSTALL_DIR=`python -c ...`
FOR /F "tokens=* USEBACKQ" %%i IN (`python -c "import os;print(os.path.relpath(os.environ['SP_DIR'],os.environ['LIBRARY_PREFIX']).replace('\\','/'))"`) DO SET PYTHON_INSTALL_DIR=%%i

cmake ^
    -G "%CMAKE_GENERATOR%" ^
    -DCMAKE_INSTALL_PREFIX=%LIBRARY_PREFIX% ^
    -DCMAKE_BUILD_TYPE=%BUILD_TYPE% ^
    -DCMAKE_INSTALL_SYSTEM_RUNTIME_LIBS_SKIP=True ^
    -DPYTHON_EXECUTABLE=%PYTHON% ^
    -DPython_EXECUTABLE=%PYTHON% ^
    -DPython3_EXECUTABLE=%PYTHON% ^
    -DSETUPTOOLS_DEB_LAYOUT=OFF ^
    -DBUILD_SHARED_LIBS=ON ^
    -DBUILD_TESTING=OFF ^
    -DCMAKE_OBJECT_PATH_MAX=255 ^
    --compile-no-warning-as-error ^
    -DPYTHON_INSTALL_DIR=%PYTHON_INSTALL_DIR% ^
    %SRC_DIR%
if errorlevel 1 exit 1

:: We explicitly pass %CPU_COUNT% to cmake --build as we are not using Ninja,
:: see the comment before setting the CMAKE_GENERATOR env variable
cmake --build . --config Release --parallel %CPU_COUNT% --target install
if errorlevel 1 exit 1
