/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.converters;

import jnr.ffi.mapper.ToNativeContext;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.provider.ParameterFlags;

@ToNativeConverter.NoContext
@ToNativeConverter.Cacheable
public class BoxedFloatArrayParameterConverter
implements ToNativeConverter<Float[], float[]> {
    private static final ToNativeConverter<Float[], float[]> IN = new BoxedFloatArrayParameterConverter(2);
    private static final ToNativeConverter<Float[], float[]> OUT = new Out(1);
    private static final ToNativeConverter<Float[], float[]> INOUT = new Out(3);
    private final int parameterFlags;

    public static ToNativeConverter<Float[], float[]> getInstance(ToNativeContext toNativeContext) {
        int parameterFlags = ParameterFlags.parse(toNativeContext.getAnnotations());
        return ParameterFlags.isOut(parameterFlags) ? (ParameterFlags.isIn(parameterFlags) ? INOUT : OUT) : IN;
    }

    BoxedFloatArrayParameterConverter(int parameterFlags) {
        this.parameterFlags = parameterFlags;
    }

    @Override
    public float[] toNative(Float[] array2, ToNativeContext context) {
        if (array2 == null) {
            return null;
        }
        float[] primitive = new float[array2.length];
        if (ParameterFlags.isIn(this.parameterFlags)) {
            for (int i2 = 0; i2 < array2.length; ++i2) {
                primitive[i2] = array2[i2] != null ? array2[i2].floatValue() : 0.0f;
            }
        }
        return primitive;
    }

    @Override
    public Class<float[]> nativeType() {
        return float[].class;
    }

    public static final class Out
    extends BoxedFloatArrayParameterConverter
    implements ToNativeConverter.PostInvocation<Float[], float[]> {
        Out(int parameterFlags) {
            super(parameterFlags);
        }

        @Override
        public void postInvoke(Float[] array2, float[] primitive, ToNativeContext context) {
            if (array2 != null && primitive != null) {
                for (int i2 = 0; i2 < array2.length; ++i2) {
                    array2[i2] = Float.valueOf(primitive[i2]);
                }
            }
        }
    }
}

