/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

import (
	resourcev1beta1 "k8s.io/api/resource/v1beta1"
)

// DeviceSubRequestApplyConfiguration represents a declarative configuration of the DeviceSubRequest type for use
// with apply.
//
// DeviceSubRequest describes a request for device provided in the
// claim.spec.devices.requests[].firstAvailable array. Each
// is typically a request for a single resource like a device, but can
// also ask for several identical devices.
//
// DeviceSubRequest is similar to Request, but doesn't expose the AdminAccess
// or FirstAvailable fields, as those can only be set on the top-level request.
// AdminAccess is not supported for requests with a prioritized list, and
// recursive FirstAvailable fields are not supported.
type DeviceSubRequestApplyConfiguration struct {
	// Name can be used to reference this subrequest in the list of constraints
	// or the list of configurations for the claim. References must use the
	// format <main request>/<subrequest>.
	//
	// Must be a DNS label.
	Name *string `json:"name,omitempty"`
	// DeviceClassName references a specific DeviceClass, which can define
	// additional configuration and selectors to be inherited by this
	// subrequest.
	//
	// A class is required. Which classes are available depends on the cluster.
	//
	// Administrators may use this to restrict which devices may get
	// requested by only installing classes with selectors for permitted
	// devices. If users are free to request anything without restrictions,
	// then administrators can create an empty DeviceClass for users
	// to reference.
	DeviceClassName *string `json:"deviceClassName,omitempty"`
	// Selectors define criteria which must be satisfied by a specific
	// device in order for that device to be considered for this
	// subrequest. All selectors must be satisfied for a device to be
	// considered.
	Selectors []DeviceSelectorApplyConfiguration `json:"selectors,omitempty"`
	// AllocationMode and its related fields define how devices are allocated
	// to satisfy this subrequest. Supported values are:
	//
	// - ExactCount: This request is for a specific number of devices.
	// This is the default. The exact number is provided in the
	// count field.
	//
	// - All: This subrequest is for all of the matching devices in a pool.
	// Allocation will fail if some devices are already allocated,
	// unless adminAccess is requested.
	//
	// If AllocationMode is not specified, the default mode is ExactCount. If
	// the mode is ExactCount and count is not specified, the default count is
	// one. Any other subrequests must specify this field.
	//
	// More modes may get added in the future. Clients must refuse to handle
	// requests with unknown modes.
	AllocationMode *resourcev1beta1.DeviceAllocationMode `json:"allocationMode,omitempty"`
	// Count is used only when the count mode is "ExactCount". Must be greater than zero.
	// If AllocationMode is ExactCount and this field is not specified, the default is one.
	Count *int64 `json:"count,omitempty"`
	// If specified, the request's tolerations.
	//
	// Tolerations for NoSchedule are required to allocate a
	// device which has a taint with that effect. The same applies
	// to NoExecute.
	//
	// In addition, should any of the allocated devices get tainted
	// with NoExecute after allocation and that effect is not tolerated,
	// then all pods consuming the ResourceClaim get deleted to evict
	// them. The scheduler will not let new pods reserve the claim while
	// it has these tainted devices. Once all pods are evicted, the
	// claim will get deallocated.
	//
	// The maximum number of tolerations is 16.
	//
	// This is an alpha field and requires enabling the DRADeviceTaints
	// feature gate.
	Tolerations []DeviceTolerationApplyConfiguration `json:"tolerations,omitempty"`
	// Capacity define resource requirements against each capacity.
	//
	// If this field is unset and the device supports multiple allocations,
	// the default value will be applied to each capacity according to requestPolicy.
	// For the capacity that has no requestPolicy, default is the full capacity value.
	//
	// Applies to each device allocation.
	// If Count > 1,
	// the request fails if there aren't enough devices that meet the requirements.
	// If AllocationMode is set to All,
	// the request fails if there are devices that otherwise match the request,
	// and have this capacity, with a value >= the requested amount, but which cannot be allocated to this request.
	Capacity *CapacityRequirementsApplyConfiguration `json:"capacity,omitempty"`
}

// DeviceSubRequestApplyConfiguration constructs a declarative configuration of the DeviceSubRequest type for use with
// apply.
func DeviceSubRequest() *DeviceSubRequestApplyConfiguration {
	return &DeviceSubRequestApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *DeviceSubRequestApplyConfiguration) WithName(value string) *DeviceSubRequestApplyConfiguration {
	b.Name = &value
	return b
}

// WithDeviceClassName sets the DeviceClassName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DeviceClassName field is set to the value of the last call.
func (b *DeviceSubRequestApplyConfiguration) WithDeviceClassName(value string) *DeviceSubRequestApplyConfiguration {
	b.DeviceClassName = &value
	return b
}

// WithSelectors adds the given value to the Selectors field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Selectors field.
func (b *DeviceSubRequestApplyConfiguration) WithSelectors(values ...*DeviceSelectorApplyConfiguration) *DeviceSubRequestApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithSelectors")
		}
		b.Selectors = append(b.Selectors, *values[i])
	}
	return b
}

// WithAllocationMode sets the AllocationMode field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AllocationMode field is set to the value of the last call.
func (b *DeviceSubRequestApplyConfiguration) WithAllocationMode(value resourcev1beta1.DeviceAllocationMode) *DeviceSubRequestApplyConfiguration {
	b.AllocationMode = &value
	return b
}

// WithCount sets the Count field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Count field is set to the value of the last call.
func (b *DeviceSubRequestApplyConfiguration) WithCount(value int64) *DeviceSubRequestApplyConfiguration {
	b.Count = &value
	return b
}

// WithTolerations adds the given value to the Tolerations field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Tolerations field.
func (b *DeviceSubRequestApplyConfiguration) WithTolerations(values ...*DeviceTolerationApplyConfiguration) *DeviceSubRequestApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithTolerations")
		}
		b.Tolerations = append(b.Tolerations, *values[i])
	}
	return b
}

// WithCapacity sets the Capacity field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Capacity field is set to the value of the last call.
func (b *DeviceSubRequestApplyConfiguration) WithCapacity(value *CapacityRequirementsApplyConfiguration) *DeviceSubRequestApplyConfiguration {
	b.Capacity = value
	return b
}
