// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by sidekick. DO NOT EDIT.

#[allow(unused_imports)]
use super::*;

#[doc(hidden)]
impl serde::ser::Serialize for super::Api {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.name.is_empty() {
            state.serialize_entry("name", &self.name)?;
        }
        if !self.methods.is_empty() {
            state.serialize_entry("methods", &self.methods)?;
        }
        if !self.options.is_empty() {
            state.serialize_entry("options", &self.options)?;
        }
        if !self.version.is_empty() {
            state.serialize_entry("version", &self.version)?;
        }
        if self.source_context.is_some() {
            state.serialize_entry("sourceContext", &self.source_context)?;
        }
        if !self.mixins.is_empty() {
            state.serialize_entry("mixins", &self.mixins)?;
        }
        if !wkt::internal::is_default(&self.syntax) {
            state.serialize_entry("syntax", &self.syntax)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::Method {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.name.is_empty() {
            state.serialize_entry("name", &self.name)?;
        }
        if !self.request_type_url.is_empty() {
            state.serialize_entry("requestTypeUrl", &self.request_type_url)?;
        }
        if !wkt::internal::is_default(&self.request_streaming) {
            state.serialize_entry("requestStreaming", &self.request_streaming)?;
        }
        if !self.response_type_url.is_empty() {
            state.serialize_entry("responseTypeUrl", &self.response_type_url)?;
        }
        if !wkt::internal::is_default(&self.response_streaming) {
            state.serialize_entry("responseStreaming", &self.response_streaming)?;
        }
        if !self.options.is_empty() {
            state.serialize_entry("options", &self.options)?;
        }
        if !wkt::internal::is_default(&self.syntax) {
            state.serialize_entry("syntax", &self.syntax)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::Mixin {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.name.is_empty() {
            state.serialize_entry("name", &self.name)?;
        }
        if !self.root.is_empty() {
            state.serialize_entry("root", &self.root)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::FileDescriptorSet {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.file.is_empty() {
            state.serialize_entry("file", &self.file)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::FileDescriptorProto {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.name.is_empty() {
            state.serialize_entry("name", &self.name)?;
        }
        if !self.package.is_empty() {
            state.serialize_entry("package", &self.package)?;
        }
        if !self.dependency.is_empty() {
            state.serialize_entry("dependency", &self.dependency)?;
        }
        if !self.public_dependency.is_empty() {
            struct __With<'a>(&'a std::vec::Vec<i32>);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<std::vec::Vec<wkt::internal::I32>>::serialize(
                        self.0, serializer,
                    )
                }
            }
            state.serialize_entry("publicDependency", &__With(&self.public_dependency))?;
        }
        if !self.weak_dependency.is_empty() {
            struct __With<'a>(&'a std::vec::Vec<i32>);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<std::vec::Vec<wkt::internal::I32>>::serialize(
                        self.0, serializer,
                    )
                }
            }
            state.serialize_entry("weakDependency", &__With(&self.weak_dependency))?;
        }
        if !self.message_type.is_empty() {
            state.serialize_entry("messageType", &self.message_type)?;
        }
        if !self.enum_type.is_empty() {
            state.serialize_entry("enumType", &self.enum_type)?;
        }
        if !self.service.is_empty() {
            state.serialize_entry("service", &self.service)?;
        }
        if !self.extension.is_empty() {
            state.serialize_entry("extension", &self.extension)?;
        }
        if self.options.is_some() {
            state.serialize_entry("options", &self.options)?;
        }
        if self.source_code_info.is_some() {
            state.serialize_entry("sourceCodeInfo", &self.source_code_info)?;
        }
        if !self.syntax.is_empty() {
            state.serialize_entry("syntax", &self.syntax)?;
        }
        if !wkt::internal::is_default(&self.edition) {
            state.serialize_entry("edition", &self.edition)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::DescriptorProto {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.name.is_empty() {
            state.serialize_entry("name", &self.name)?;
        }
        if !self.field.is_empty() {
            state.serialize_entry("field", &self.field)?;
        }
        if !self.extension.is_empty() {
            state.serialize_entry("extension", &self.extension)?;
        }
        if !self.nested_type.is_empty() {
            state.serialize_entry("nestedType", &self.nested_type)?;
        }
        if !self.enum_type.is_empty() {
            state.serialize_entry("enumType", &self.enum_type)?;
        }
        if !self.extension_range.is_empty() {
            state.serialize_entry("extensionRange", &self.extension_range)?;
        }
        if !self.oneof_decl.is_empty() {
            state.serialize_entry("oneofDecl", &self.oneof_decl)?;
        }
        if self.options.is_some() {
            state.serialize_entry("options", &self.options)?;
        }
        if !self.reserved_range.is_empty() {
            state.serialize_entry("reservedRange", &self.reserved_range)?;
        }
        if !self.reserved_name.is_empty() {
            state.serialize_entry("reservedName", &self.reserved_name)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::descriptor_proto::ExtensionRange {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !wkt::internal::is_default(&self.start) {
            struct __With<'a>(&'a i32);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<wkt::internal::I32>::serialize(self.0, serializer)
                }
            }
            state.serialize_entry("start", &__With(&self.start))?;
        }
        if !wkt::internal::is_default(&self.end) {
            struct __With<'a>(&'a i32);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<wkt::internal::I32>::serialize(self.0, serializer)
                }
            }
            state.serialize_entry("end", &__With(&self.end))?;
        }
        if self.options.is_some() {
            state.serialize_entry("options", &self.options)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::descriptor_proto::ReservedRange {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !wkt::internal::is_default(&self.start) {
            struct __With<'a>(&'a i32);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<wkt::internal::I32>::serialize(self.0, serializer)
                }
            }
            state.serialize_entry("start", &__With(&self.start))?;
        }
        if !wkt::internal::is_default(&self.end) {
            struct __With<'a>(&'a i32);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<wkt::internal::I32>::serialize(self.0, serializer)
                }
            }
            state.serialize_entry("end", &__With(&self.end))?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::ExtensionRangeOptions {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.uninterpreted_option.is_empty() {
            state.serialize_entry("uninterpretedOption", &self.uninterpreted_option)?;
        }
        if !self.declaration.is_empty() {
            state.serialize_entry("declaration", &self.declaration)?;
        }
        if self.features.is_some() {
            state.serialize_entry("features", &self.features)?;
        }
        if !wkt::internal::is_default(&self.verification) {
            state.serialize_entry("verification", &self.verification)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::extension_range_options::Declaration {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !wkt::internal::is_default(&self.number) {
            struct __With<'a>(&'a i32);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<wkt::internal::I32>::serialize(self.0, serializer)
                }
            }
            state.serialize_entry("number", &__With(&self.number))?;
        }
        if !self.full_name.is_empty() {
            state.serialize_entry("fullName", &self.full_name)?;
        }
        if !self.r#type.is_empty() {
            state.serialize_entry("type", &self.r#type)?;
        }
        if !wkt::internal::is_default(&self.reserved) {
            state.serialize_entry("reserved", &self.reserved)?;
        }
        if !wkt::internal::is_default(&self.repeated) {
            state.serialize_entry("repeated", &self.repeated)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::FieldDescriptorProto {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.name.is_empty() {
            state.serialize_entry("name", &self.name)?;
        }
        if !wkt::internal::is_default(&self.number) {
            struct __With<'a>(&'a i32);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<wkt::internal::I32>::serialize(self.0, serializer)
                }
            }
            state.serialize_entry("number", &__With(&self.number))?;
        }
        if !wkt::internal::is_default(&self.label) {
            state.serialize_entry("label", &self.label)?;
        }
        if !wkt::internal::is_default(&self.r#type) {
            state.serialize_entry("type", &self.r#type)?;
        }
        if !self.type_name.is_empty() {
            state.serialize_entry("typeName", &self.type_name)?;
        }
        if !self.extendee.is_empty() {
            state.serialize_entry("extendee", &self.extendee)?;
        }
        if !self.default_value.is_empty() {
            state.serialize_entry("defaultValue", &self.default_value)?;
        }
        if !wkt::internal::is_default(&self.oneof_index) {
            struct __With<'a>(&'a i32);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<wkt::internal::I32>::serialize(self.0, serializer)
                }
            }
            state.serialize_entry("oneofIndex", &__With(&self.oneof_index))?;
        }
        if !self.json_name.is_empty() {
            state.serialize_entry("jsonName", &self.json_name)?;
        }
        if self.options.is_some() {
            state.serialize_entry("options", &self.options)?;
        }
        if !wkt::internal::is_default(&self.proto3_optional) {
            state.serialize_entry("proto3Optional", &self.proto3_optional)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::OneofDescriptorProto {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.name.is_empty() {
            state.serialize_entry("name", &self.name)?;
        }
        if self.options.is_some() {
            state.serialize_entry("options", &self.options)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::EnumDescriptorProto {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.name.is_empty() {
            state.serialize_entry("name", &self.name)?;
        }
        if !self.value.is_empty() {
            state.serialize_entry("value", &self.value)?;
        }
        if self.options.is_some() {
            state.serialize_entry("options", &self.options)?;
        }
        if !self.reserved_range.is_empty() {
            state.serialize_entry("reservedRange", &self.reserved_range)?;
        }
        if !self.reserved_name.is_empty() {
            state.serialize_entry("reservedName", &self.reserved_name)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::enum_descriptor_proto::EnumReservedRange {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !wkt::internal::is_default(&self.start) {
            struct __With<'a>(&'a i32);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<wkt::internal::I32>::serialize(self.0, serializer)
                }
            }
            state.serialize_entry("start", &__With(&self.start))?;
        }
        if !wkt::internal::is_default(&self.end) {
            struct __With<'a>(&'a i32);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<wkt::internal::I32>::serialize(self.0, serializer)
                }
            }
            state.serialize_entry("end", &__With(&self.end))?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::EnumValueDescriptorProto {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.name.is_empty() {
            state.serialize_entry("name", &self.name)?;
        }
        if !wkt::internal::is_default(&self.number) {
            struct __With<'a>(&'a i32);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<wkt::internal::I32>::serialize(self.0, serializer)
                }
            }
            state.serialize_entry("number", &__With(&self.number))?;
        }
        if self.options.is_some() {
            state.serialize_entry("options", &self.options)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::ServiceDescriptorProto {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.name.is_empty() {
            state.serialize_entry("name", &self.name)?;
        }
        if !self.method.is_empty() {
            state.serialize_entry("method", &self.method)?;
        }
        if self.options.is_some() {
            state.serialize_entry("options", &self.options)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::MethodDescriptorProto {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.name.is_empty() {
            state.serialize_entry("name", &self.name)?;
        }
        if !self.input_type.is_empty() {
            state.serialize_entry("inputType", &self.input_type)?;
        }
        if !self.output_type.is_empty() {
            state.serialize_entry("outputType", &self.output_type)?;
        }
        if self.options.is_some() {
            state.serialize_entry("options", &self.options)?;
        }
        if !wkt::internal::is_default(&self.client_streaming) {
            state.serialize_entry("clientStreaming", &self.client_streaming)?;
        }
        if !wkt::internal::is_default(&self.server_streaming) {
            state.serialize_entry("serverStreaming", &self.server_streaming)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::FileOptions {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.java_package.is_empty() {
            state.serialize_entry("javaPackage", &self.java_package)?;
        }
        if !self.java_outer_classname.is_empty() {
            state.serialize_entry("javaOuterClassname", &self.java_outer_classname)?;
        }
        if !wkt::internal::is_default(&self.java_multiple_files) {
            state.serialize_entry("javaMultipleFiles", &self.java_multiple_files)?;
        }
        if !wkt::internal::is_default(&self.java_generate_equals_and_hash) {
            state.serialize_entry(
                "javaGenerateEqualsAndHash",
                &self.java_generate_equals_and_hash,
            )?;
        }
        if !wkt::internal::is_default(&self.java_string_check_utf8) {
            state.serialize_entry("javaStringCheckUtf8", &self.java_string_check_utf8)?;
        }
        if !wkt::internal::is_default(&self.optimize_for) {
            state.serialize_entry("optimizeFor", &self.optimize_for)?;
        }
        if !self.go_package.is_empty() {
            state.serialize_entry("goPackage", &self.go_package)?;
        }
        if !wkt::internal::is_default(&self.cc_generic_services) {
            state.serialize_entry("ccGenericServices", &self.cc_generic_services)?;
        }
        if !wkt::internal::is_default(&self.java_generic_services) {
            state.serialize_entry("javaGenericServices", &self.java_generic_services)?;
        }
        if !wkt::internal::is_default(&self.py_generic_services) {
            state.serialize_entry("pyGenericServices", &self.py_generic_services)?;
        }
        if !wkt::internal::is_default(&self.deprecated) {
            state.serialize_entry("deprecated", &self.deprecated)?;
        }
        if !wkt::internal::is_default(&self.cc_enable_arenas) {
            state.serialize_entry("ccEnableArenas", &self.cc_enable_arenas)?;
        }
        if !self.objc_class_prefix.is_empty() {
            state.serialize_entry("objcClassPrefix", &self.objc_class_prefix)?;
        }
        if !self.csharp_namespace.is_empty() {
            state.serialize_entry("csharpNamespace", &self.csharp_namespace)?;
        }
        if !self.swift_prefix.is_empty() {
            state.serialize_entry("swiftPrefix", &self.swift_prefix)?;
        }
        if !self.php_class_prefix.is_empty() {
            state.serialize_entry("phpClassPrefix", &self.php_class_prefix)?;
        }
        if !self.php_namespace.is_empty() {
            state.serialize_entry("phpNamespace", &self.php_namespace)?;
        }
        if !self.php_metadata_namespace.is_empty() {
            state.serialize_entry("phpMetadataNamespace", &self.php_metadata_namespace)?;
        }
        if !self.ruby_package.is_empty() {
            state.serialize_entry("rubyPackage", &self.ruby_package)?;
        }
        if self.features.is_some() {
            state.serialize_entry("features", &self.features)?;
        }
        if !self.uninterpreted_option.is_empty() {
            state.serialize_entry("uninterpretedOption", &self.uninterpreted_option)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::MessageOptions {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !wkt::internal::is_default(&self.message_set_wire_format) {
            state.serialize_entry("messageSetWireFormat", &self.message_set_wire_format)?;
        }
        if !wkt::internal::is_default(&self.no_standard_descriptor_accessor) {
            state.serialize_entry(
                "noStandardDescriptorAccessor",
                &self.no_standard_descriptor_accessor,
            )?;
        }
        if !wkt::internal::is_default(&self.deprecated) {
            state.serialize_entry("deprecated", &self.deprecated)?;
        }
        if !wkt::internal::is_default(&self.map_entry) {
            state.serialize_entry("mapEntry", &self.map_entry)?;
        }
        if !wkt::internal::is_default(&self.deprecated_legacy_json_field_conflicts) {
            state.serialize_entry(
                "deprecatedLegacyJsonFieldConflicts",
                &self.deprecated_legacy_json_field_conflicts,
            )?;
        }
        if self.features.is_some() {
            state.serialize_entry("features", &self.features)?;
        }
        if !self.uninterpreted_option.is_empty() {
            state.serialize_entry("uninterpretedOption", &self.uninterpreted_option)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::FieldOptions {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !wkt::internal::is_default(&self.ctype) {
            state.serialize_entry("ctype", &self.ctype)?;
        }
        if !wkt::internal::is_default(&self.packed) {
            state.serialize_entry("packed", &self.packed)?;
        }
        if !wkt::internal::is_default(&self.jstype) {
            state.serialize_entry("jstype", &self.jstype)?;
        }
        if !wkt::internal::is_default(&self.lazy) {
            state.serialize_entry("lazy", &self.lazy)?;
        }
        if !wkt::internal::is_default(&self.unverified_lazy) {
            state.serialize_entry("unverifiedLazy", &self.unverified_lazy)?;
        }
        if !wkt::internal::is_default(&self.deprecated) {
            state.serialize_entry("deprecated", &self.deprecated)?;
        }
        if !wkt::internal::is_default(&self.weak) {
            state.serialize_entry("weak", &self.weak)?;
        }
        if !wkt::internal::is_default(&self.debug_redact) {
            state.serialize_entry("debugRedact", &self.debug_redact)?;
        }
        if !wkt::internal::is_default(&self.retention) {
            state.serialize_entry("retention", &self.retention)?;
        }
        if !self.targets.is_empty() {
            state.serialize_entry("targets", &self.targets)?;
        }
        if !self.edition_defaults.is_empty() {
            state.serialize_entry("editionDefaults", &self.edition_defaults)?;
        }
        if self.features.is_some() {
            state.serialize_entry("features", &self.features)?;
        }
        if self.feature_support.is_some() {
            state.serialize_entry("featureSupport", &self.feature_support)?;
        }
        if !self.uninterpreted_option.is_empty() {
            state.serialize_entry("uninterpretedOption", &self.uninterpreted_option)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::field_options::EditionDefault {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !wkt::internal::is_default(&self.edition) {
            state.serialize_entry("edition", &self.edition)?;
        }
        if !self.value.is_empty() {
            state.serialize_entry("value", &self.value)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::field_options::FeatureSupport {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !wkt::internal::is_default(&self.edition_introduced) {
            state.serialize_entry("editionIntroduced", &self.edition_introduced)?;
        }
        if !wkt::internal::is_default(&self.edition_deprecated) {
            state.serialize_entry("editionDeprecated", &self.edition_deprecated)?;
        }
        if !self.deprecation_warning.is_empty() {
            state.serialize_entry("deprecationWarning", &self.deprecation_warning)?;
        }
        if !wkt::internal::is_default(&self.edition_removed) {
            state.serialize_entry("editionRemoved", &self.edition_removed)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::OneofOptions {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if self.features.is_some() {
            state.serialize_entry("features", &self.features)?;
        }
        if !self.uninterpreted_option.is_empty() {
            state.serialize_entry("uninterpretedOption", &self.uninterpreted_option)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::EnumOptions {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !wkt::internal::is_default(&self.allow_alias) {
            state.serialize_entry("allowAlias", &self.allow_alias)?;
        }
        if !wkt::internal::is_default(&self.deprecated) {
            state.serialize_entry("deprecated", &self.deprecated)?;
        }
        if !wkt::internal::is_default(&self.deprecated_legacy_json_field_conflicts) {
            state.serialize_entry(
                "deprecatedLegacyJsonFieldConflicts",
                &self.deprecated_legacy_json_field_conflicts,
            )?;
        }
        if self.features.is_some() {
            state.serialize_entry("features", &self.features)?;
        }
        if !self.uninterpreted_option.is_empty() {
            state.serialize_entry("uninterpretedOption", &self.uninterpreted_option)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::EnumValueOptions {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !wkt::internal::is_default(&self.deprecated) {
            state.serialize_entry("deprecated", &self.deprecated)?;
        }
        if self.features.is_some() {
            state.serialize_entry("features", &self.features)?;
        }
        if !wkt::internal::is_default(&self.debug_redact) {
            state.serialize_entry("debugRedact", &self.debug_redact)?;
        }
        if self.feature_support.is_some() {
            state.serialize_entry("featureSupport", &self.feature_support)?;
        }
        if !self.uninterpreted_option.is_empty() {
            state.serialize_entry("uninterpretedOption", &self.uninterpreted_option)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::ServiceOptions {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if self.features.is_some() {
            state.serialize_entry("features", &self.features)?;
        }
        if !wkt::internal::is_default(&self.deprecated) {
            state.serialize_entry("deprecated", &self.deprecated)?;
        }
        if !self.uninterpreted_option.is_empty() {
            state.serialize_entry("uninterpretedOption", &self.uninterpreted_option)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::MethodOptions {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !wkt::internal::is_default(&self.deprecated) {
            state.serialize_entry("deprecated", &self.deprecated)?;
        }
        if !wkt::internal::is_default(&self.idempotency_level) {
            state.serialize_entry("idempotencyLevel", &self.idempotency_level)?;
        }
        if self.features.is_some() {
            state.serialize_entry("features", &self.features)?;
        }
        if !self.uninterpreted_option.is_empty() {
            state.serialize_entry("uninterpretedOption", &self.uninterpreted_option)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::UninterpretedOption {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.name.is_empty() {
            state.serialize_entry("name", &self.name)?;
        }
        if !self.identifier_value.is_empty() {
            state.serialize_entry("identifierValue", &self.identifier_value)?;
        }
        if !wkt::internal::is_default(&self.positive_int_value) {
            struct __With<'a>(&'a u64);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<wkt::internal::U64>::serialize(self.0, serializer)
                }
            }
            state.serialize_entry("positiveIntValue", &__With(&self.positive_int_value))?;
        }
        if !wkt::internal::is_default(&self.negative_int_value) {
            struct __With<'a>(&'a i64);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<wkt::internal::I64>::serialize(self.0, serializer)
                }
            }
            state.serialize_entry("negativeIntValue", &__With(&self.negative_int_value))?;
        }
        if !wkt::internal::is_default(&self.double_value) {
            struct __With<'a>(&'a f64);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<wkt::internal::F64>::serialize(self.0, serializer)
                }
            }
            state.serialize_entry("doubleValue", &__With(&self.double_value))?;
        }
        if !self.string_value.is_empty() {
            struct __With<'a>(&'a ::bytes::Bytes);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<serde_with::base64::Base64>::serialize(self.0, serializer)
                }
            }
            state.serialize_entry("stringValue", &__With(&self.string_value))?;
        }
        if !self.aggregate_value.is_empty() {
            state.serialize_entry("aggregateValue", &self.aggregate_value)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::uninterpreted_option::NamePart {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.name_part.is_empty() {
            state.serialize_entry("namePart", &self.name_part)?;
        }
        if !wkt::internal::is_default(&self.is_extension) {
            state.serialize_entry("isExtension", &self.is_extension)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::FeatureSet {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !wkt::internal::is_default(&self.field_presence) {
            state.serialize_entry("fieldPresence", &self.field_presence)?;
        }
        if !wkt::internal::is_default(&self.enum_type) {
            state.serialize_entry("enumType", &self.enum_type)?;
        }
        if !wkt::internal::is_default(&self.repeated_field_encoding) {
            state.serialize_entry("repeatedFieldEncoding", &self.repeated_field_encoding)?;
        }
        if !wkt::internal::is_default(&self.utf8_validation) {
            state.serialize_entry("utf8Validation", &self.utf8_validation)?;
        }
        if !wkt::internal::is_default(&self.message_encoding) {
            state.serialize_entry("messageEncoding", &self.message_encoding)?;
        }
        if !wkt::internal::is_default(&self.json_format) {
            state.serialize_entry("jsonFormat", &self.json_format)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::FeatureSetDefaults {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.defaults.is_empty() {
            state.serialize_entry("defaults", &self.defaults)?;
        }
        if !wkt::internal::is_default(&self.minimum_edition) {
            state.serialize_entry("minimumEdition", &self.minimum_edition)?;
        }
        if !wkt::internal::is_default(&self.maximum_edition) {
            state.serialize_entry("maximumEdition", &self.maximum_edition)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::feature_set_defaults::FeatureSetEditionDefault {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !wkt::internal::is_default(&self.edition) {
            state.serialize_entry("edition", &self.edition)?;
        }
        if self.overridable_features.is_some() {
            state.serialize_entry("overridableFeatures", &self.overridable_features)?;
        }
        if self.fixed_features.is_some() {
            state.serialize_entry("fixedFeatures", &self.fixed_features)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::SourceCodeInfo {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.location.is_empty() {
            state.serialize_entry("location", &self.location)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::source_code_info::Location {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.path.is_empty() {
            struct __With<'a>(&'a std::vec::Vec<i32>);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<std::vec::Vec<wkt::internal::I32>>::serialize(
                        self.0, serializer,
                    )
                }
            }
            state.serialize_entry("path", &__With(&self.path))?;
        }
        if !self.span.is_empty() {
            struct __With<'a>(&'a std::vec::Vec<i32>);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<std::vec::Vec<wkt::internal::I32>>::serialize(
                        self.0, serializer,
                    )
                }
            }
            state.serialize_entry("span", &__With(&self.span))?;
        }
        if !self.leading_comments.is_empty() {
            state.serialize_entry("leadingComments", &self.leading_comments)?;
        }
        if !self.trailing_comments.is_empty() {
            state.serialize_entry("trailingComments", &self.trailing_comments)?;
        }
        if !self.leading_detached_comments.is_empty() {
            state.serialize_entry("leadingDetachedComments", &self.leading_detached_comments)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::GeneratedCodeInfo {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.annotation.is_empty() {
            state.serialize_entry("annotation", &self.annotation)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::generated_code_info::Annotation {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.path.is_empty() {
            struct __With<'a>(&'a std::vec::Vec<i32>);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<std::vec::Vec<wkt::internal::I32>>::serialize(
                        self.0, serializer,
                    )
                }
            }
            state.serialize_entry("path", &__With(&self.path))?;
        }
        if !self.source_file.is_empty() {
            state.serialize_entry("sourceFile", &self.source_file)?;
        }
        if !wkt::internal::is_default(&self.begin) {
            struct __With<'a>(&'a i32);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<wkt::internal::I32>::serialize(self.0, serializer)
                }
            }
            state.serialize_entry("begin", &__With(&self.begin))?;
        }
        if !wkt::internal::is_default(&self.end) {
            struct __With<'a>(&'a i32);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<wkt::internal::I32>::serialize(self.0, serializer)
                }
            }
            state.serialize_entry("end", &__With(&self.end))?;
        }
        if !wkt::internal::is_default(&self.semantic) {
            state.serialize_entry("semantic", &self.semantic)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::SourceContext {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.file_name.is_empty() {
            state.serialize_entry("fileName", &self.file_name)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::Type {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.name.is_empty() {
            state.serialize_entry("name", &self.name)?;
        }
        if !self.fields.is_empty() {
            state.serialize_entry("fields", &self.fields)?;
        }
        if !self.oneofs.is_empty() {
            state.serialize_entry("oneofs", &self.oneofs)?;
        }
        if !self.options.is_empty() {
            state.serialize_entry("options", &self.options)?;
        }
        if self.source_context.is_some() {
            state.serialize_entry("sourceContext", &self.source_context)?;
        }
        if !wkt::internal::is_default(&self.syntax) {
            state.serialize_entry("syntax", &self.syntax)?;
        }
        if !self.edition.is_empty() {
            state.serialize_entry("edition", &self.edition)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::Field {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !wkt::internal::is_default(&self.kind) {
            state.serialize_entry("kind", &self.kind)?;
        }
        if !wkt::internal::is_default(&self.cardinality) {
            state.serialize_entry("cardinality", &self.cardinality)?;
        }
        if !wkt::internal::is_default(&self.number) {
            struct __With<'a>(&'a i32);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<wkt::internal::I32>::serialize(self.0, serializer)
                }
            }
            state.serialize_entry("number", &__With(&self.number))?;
        }
        if !self.name.is_empty() {
            state.serialize_entry("name", &self.name)?;
        }
        if !self.type_url.is_empty() {
            state.serialize_entry("typeUrl", &self.type_url)?;
        }
        if !wkt::internal::is_default(&self.oneof_index) {
            struct __With<'a>(&'a i32);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<wkt::internal::I32>::serialize(self.0, serializer)
                }
            }
            state.serialize_entry("oneofIndex", &__With(&self.oneof_index))?;
        }
        if !wkt::internal::is_default(&self.packed) {
            state.serialize_entry("packed", &self.packed)?;
        }
        if !self.options.is_empty() {
            state.serialize_entry("options", &self.options)?;
        }
        if !self.json_name.is_empty() {
            state.serialize_entry("jsonName", &self.json_name)?;
        }
        if !self.default_value.is_empty() {
            state.serialize_entry("defaultValue", &self.default_value)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::Enum {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.name.is_empty() {
            state.serialize_entry("name", &self.name)?;
        }
        if !self.enumvalue.is_empty() {
            state.serialize_entry("enumvalue", &self.enumvalue)?;
        }
        if !self.options.is_empty() {
            state.serialize_entry("options", &self.options)?;
        }
        if self.source_context.is_some() {
            state.serialize_entry("sourceContext", &self.source_context)?;
        }
        if !wkt::internal::is_default(&self.syntax) {
            state.serialize_entry("syntax", &self.syntax)?;
        }
        if !self.edition.is_empty() {
            state.serialize_entry("edition", &self.edition)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::EnumValue {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.name.is_empty() {
            state.serialize_entry("name", &self.name)?;
        }
        if !wkt::internal::is_default(&self.number) {
            struct __With<'a>(&'a i32);
            impl<'a> serde::ser::Serialize for __With<'a> {
                fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
                where
                    S: serde::ser::Serializer,
                {
                    serde_with::As::<wkt::internal::I32>::serialize(self.0, serializer)
                }
            }
            state.serialize_entry("number", &__With(&self.number))?;
        }
        if !self.options.is_empty() {
            state.serialize_entry("options", &self.options)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}

#[doc(hidden)]
impl serde::ser::Serialize for super::Option {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::ser::Serializer,
    {
        use serde::ser::SerializeMap;
        #[allow(unused_imports)]
        use std::option::Option::Some;
        let mut state = serializer.serialize_map(std::option::Option::None)?;
        if !self.name.is_empty() {
            state.serialize_entry("name", &self.name)?;
        }
        if self.value.is_some() {
            state.serialize_entry("value", &self.value)?;
        }
        if !self._unknown_fields.is_empty() {
            for (key, value) in self._unknown_fields.iter() {
                state.serialize_entry(key, &value)?;
            }
        }
        state.end()
    }
}
