/*
    SPDX-FileCopyrightText: 2010, 2011 Alex Richardson <alex.richardson@gmx.de>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#ifndef KASTEN_SCRIPTHANDLER_HPP
#define KASTEN_SCRIPTHANDLER_HPP

// lib
#include "scripthandlerinfo.hpp"
// Std
#include <memory>

class DataInformation;
class ArrayDataInformation;
class TaggedUnionDataInformation;
class ScriptLogger;
class TopLevelDataInformation;
class QScriptValue;
class QString;

class ScriptHandler
{
public:
    ScriptHandler(std::unique_ptr<QScriptEngine>&& engine, TopLevelDataInformation* topLevel);

    ScriptHandler(const ScriptHandler&) = delete;
    ScriptHandler(ScriptHandler&&) = delete;

    ~ScriptHandler();

public:
    ScriptHandler& operator=(const ScriptHandler&) = delete;
    ScriptHandler& operator=(ScriptHandler&&) = delete;

public:
    void validateData(DataInformation* data);
    /** The pointer may be changed while updating, CHECK AS SOON AS FUNCTION RETURNS! */
    void updateDataInformation(DataInformation* data);
    /** @returns @c true if the length is set by a script function, otherwise @false */
    [[nodiscard]]
    bool updateLength(ArrayDataInformation* array);
    [[nodiscard]]
    QString customToString(const DataInformation* data, const QScriptValue& func);

    [[nodiscard]]
    QScriptEngine* engine() const;
    [[nodiscard]]
    ScriptHandlerInfo* handlerInfo();

    [[nodiscard]]
    QScriptValue callFunction(QScriptValue func, DataInformation* data, ScriptHandlerInfo::Mode mode);

private:
    const std::unique_ptr<QScriptEngine> mEngine;
    TopLevelDataInformation* const mTopLevel;
    ScriptHandlerInfo mHandlerInfo;
};

#endif /* KASTEN_SCRIPTHANDLER_HPP */
