/*
    SPDX-FileCopyrightText: 2012 Alex Richardson <alex.richardson@gmx.de>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#ifndef KASTEN_SCRIPTLOGGERVIEW_HPP
#define KASTEN_SCRIPTLOGGERVIEW_HPP

// lib
#include <topleveldatainformation.hpp>
// Qt
#include <QList>
#include <QWidget>

class QTableView;
class KComboBox;

class ScriptLoggerView : public QWidget
{
    Q_OBJECT

public:
    explicit ScriptLoggerView(const QList<std::shared_ptr<TopLevelDataInformation>>& topDataInfoList, QWidget* parent = nullptr);
    ~ScriptLoggerView() override;

private Q_SLOTS:
    void updateModel(int index);

private:
    KComboBox* mSelector;
    QTableView* mView;

    // std::shared_ptrs so they remain valid until this widget is deleted
    // even if the backing data has changed
    const QList<std::shared_ptr<TopLevelDataInformation>> mList;
};

#endif /* KASTEN_SCRIPTLOGGERVIEW_HPP */
