/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser.tokens.predicates;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.parser.TokenEntry;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.AlternativeTokenPredicateNode;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.CaptureTokenPredicateNode;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.OptionalTokenPredicateNode;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.SQLTokenEntry;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.SequenceTokenPredicateNode;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.TokenPredicateNode;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.TokenPredicateNodeVisitor;
import org.jkiss.dbeaver.utils.ListNode;

class TokenPredicateExpander
implements TokenPredicateNodeVisitor<ListNode<SQLTokenEntry>, ListNode<ListNode<SQLTokenEntry>>> {
    private static final TokenPredicateExpander INSTANCE = new TokenPredicateExpander();

    @NotNull
    public static List<List<TokenEntry>> expand(@Nullable TokenPredicateNode node) {
        return node == null ? Collections.emptyList() : StreamSupport.stream(node.apply(INSTANCE, null).spliterator(), false).filter(p -> p != null).map(path -> {
            List list = StreamSupport.stream(path.spliterator(), false).collect(Collectors.toList());
            Collections.reverse(list);
            return list;
        }).collect(Collectors.toList());
    }

    private TokenPredicateExpander() {
    }

    @Override
    @NotNull
    public ListNode<ListNode<SQLTokenEntry>> visitSequence(@NotNull SequenceTokenPredicateNode sequence, @NotNull ListNode<SQLTokenEntry> head) {
        ListNode results = ListNode.of(head);
        for (TokenPredicateNode child : sequence.childs) {
            ListNode step = null;
            for (ListNode prefix : results) {
                for (ListNode childPath : child.apply(this, prefix)) {
                    step = ListNode.push(step, (Object)childPath);
                }
            }
            results = step;
        }
        return results;
    }

    @Override
    @NotNull
    public ListNode<ListNode<SQLTokenEntry>> visitAlternative(@NotNull AlternativeTokenPredicateNode alternative, @NotNull ListNode<SQLTokenEntry> head) {
        ListNode results = null;
        for (TokenPredicateNode child : alternative.childs) {
            for (ListNode childPath : child.apply(this, head)) {
                results = ListNode.push(results, (Object)childPath);
            }
        }
        return results;
    }

    @Override
    @NotNull
    public ListNode<ListNode<SQLTokenEntry>> visitOptional(@NotNull OptionalTokenPredicateNode optional, @NotNull ListNode<SQLTokenEntry> head) {
        return ListNode.push(optional.child.apply(this, head), head);
    }

    @Override
    @NotNull
    public ListNode<ListNode<SQLTokenEntry>> visitTokenEntry(@NotNull SQLTokenEntry token, @NotNull ListNode<SQLTokenEntry> head) {
        return ListNode.of((Object)ListNode.push(head, (Object)token));
    }

    @Override
    @NotNull
    public ListNode<ListNode<SQLTokenEntry>> visitCapture(@NotNull CaptureTokenPredicateNode captureToken, @NotNull ListNode<SQLTokenEntry> head) {
        return ListNode.of((Object)ListNode.push(head, (Object)captureToken));
    }
}

