/*
 * MOTIS API
 *
 * This is the MOTIS routing API.
 *
 * The version of the OpenAPI document: v1
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct LevelEncodedPolyline {
    /// level where this segment starts, based on OpenStreetMap data
    #[serde(rename = "fromLevel")]
    pub from_level: f64,
    /// level where this segment starts, based on OpenStreetMap data
    #[serde(rename = "toLevel")]
    pub to_level: f64,
    /// OpenStreetMap way index
    #[serde(rename = "osmWay", skip_serializing_if = "Option::is_none")]
    pub osm_way: Option<i32>,
    #[serde(rename = "polyline")]
    pub polyline: Box<models::EncodedPolyline>,
}

impl LevelEncodedPolyline {
    pub fn new(from_level: f64, to_level: f64, polyline: models::EncodedPolyline) -> LevelEncodedPolyline {
        LevelEncodedPolyline {
            from_level,
            to_level,
            osm_way: None,
            polyline: Box::new(polyline),
        }
    }
}

