/*
 * Copyright (c) The mldsa-native project authors
 * SPDX-License-Identifier: Apache-2.0 OR ISC OR MIT
 */
#ifndef MLD_PARAMS_H
#define MLD_PARAMS_H

#define MLDSA_SEEDBYTES 32
#define MLDSA_CRHBYTES 64
#define MLDSA_TRBYTES 64
#define MLDSA_RNDBYTES 32
#define MLDSA_N 256
#define MLDSA_Q 8380417
#define MLDSA_Q_HALF ((MLDSA_Q + 1) / 2)
#define MLDSA_D 13

#if MLD_CONFIG_PARAMETER_SET == 44

#define MLDSA_K 4
#define MLDSA_L 4
#define MLDSA_ETA 2
#define MLDSA_TAU 39
#define MLDSA_BETA 78
#define MLDSA_GAMMA1 (1 << 17)
#define MLDSA_GAMMA2 ((MLDSA_Q - 1) / 88)
#define MLDSA_OMEGA 80
#define MLDSA_CTILDEBYTES 32
#define MLDSA_POLYZ_PACKEDBYTES 576
#define MLDSA_POLYW1_PACKEDBYTES 192
#define MLDSA_POLYETA_PACKEDBYTES 96

#elif MLD_CONFIG_PARAMETER_SET == 65

#define MLDSA_K 6
#define MLDSA_L 5
#define MLDSA_ETA 4
#define MLDSA_TAU 49
#define MLDSA_BETA 196
#define MLDSA_GAMMA1 (1 << 19)
#define MLDSA_GAMMA2 ((MLDSA_Q - 1) / 32)
#define MLDSA_OMEGA 55
#define MLDSA_CTILDEBYTES 48
#define MLDSA_POLYZ_PACKEDBYTES 640
#define MLDSA_POLYW1_PACKEDBYTES 128
#define MLDSA_POLYETA_PACKEDBYTES 128

#elif MLD_CONFIG_PARAMETER_SET == 87

#define MLDSA_K 8
#define MLDSA_L 7
#define MLDSA_ETA 2
#define MLDSA_TAU 60
#define MLDSA_BETA 120
#define MLDSA_GAMMA1 (1 << 19)
#define MLDSA_GAMMA2 ((MLDSA_Q - 1) / 32)
#define MLDSA_OMEGA 75
#define MLDSA_CTILDEBYTES 64
#define MLDSA_POLYZ_PACKEDBYTES 640
#define MLDSA_POLYW1_PACKEDBYTES 128
#define MLDSA_POLYETA_PACKEDBYTES 96

#endif /* MLD_CONFIG_PARAMETER_SET == 87 */

#define MLDSA_POLYT1_PACKEDBYTES 320
#define MLDSA_POLYT0_PACKEDBYTES 416
#define MLDSA_POLYVECH_PACKEDBYTES (MLDSA_OMEGA + MLDSA_K)

#define MLDSA_CRYPTO_PUBLICKEYBYTES \
  (MLDSA_SEEDBYTES + MLDSA_K * MLDSA_POLYT1_PACKEDBYTES)
#define MLDSA_CRYPTO_SECRETKEYBYTES                                            \
  (2 * MLDSA_SEEDBYTES + MLDSA_TRBYTES + MLDSA_L * MLDSA_POLYETA_PACKEDBYTES + \
   MLDSA_K * MLDSA_POLYETA_PACKEDBYTES + MLDSA_K * MLDSA_POLYT0_PACKEDBYTES)
#define MLDSA_CRYPTO_BYTES                                 \
  (MLDSA_CTILDEBYTES + MLDSA_L * MLDSA_POLYZ_PACKEDBYTES + \
   MLDSA_POLYVECH_PACKEDBYTES)

#endif /* !MLD_PARAMS_H */
