//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// Fetch the
    /// `CKShareMetadata`for a share URL.
    ///
    ///
    /// Since you can't know what container this share is in before you fetch its metadata, you may run this operation in any container you have access to
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckfetchsharemetadataoperation?language=objc)
    #[unsafe(super(CKOperation, NSOperation, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "CKOperation")]
    pub struct CKFetchShareMetadataOperation;
);

#[cfg(feature = "CKOperation")]
extern_conformance!(
    unsafe impl NSObjectProtocol for CKFetchShareMetadataOperation {}
);

#[cfg(feature = "CKOperation")]
impl CKFetchShareMetadataOperation {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(initWithShareURLs:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithShareURLs(
            this: Allocated<Self>,
            share_ur_ls: &NSArray<NSURL>,
        ) -> Retained<Self>;

        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(shareURLs))]
        #[unsafe(method_family = none)]
        pub unsafe fn shareURLs(&self) -> Option<Retained<NSArray<NSURL>>>;

        /// Setter for [`shareURLs`][Self::shareURLs].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setShareURLs:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setShareURLs(&self, share_ur_ls: Option<&NSArray<NSURL>>);

        /// If set to YES, the resulting
        /// `CKShareMetadata`will have a
        /// `rootRecord`object filled out.
        ///
        ///
        /// Defaults to
        /// `NO.`The resulting
        /// `CKShareMetadata`will have a
        /// `rootRecordID`property regardless of the value of this property.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(shouldFetchRootRecord))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldFetchRootRecord(&self) -> bool;

        /// Setter for [`shouldFetchRootRecord`][Self::shouldFetchRootRecord].
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setShouldFetchRootRecord:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setShouldFetchRootRecord(&self, should_fetch_root_record: bool);

        #[cfg(feature = "CKRecord")]
        /// Declares which user-defined keys should be fetched and added to the resulting
        /// `rootRecord.`
        ///
        /// Only consulted if
        /// `shouldFetchRootRecord`is
        /// `YES.`If nil, declares the entire root record should be downloaded. If set to an empty array, declares that no user fields should be downloaded.
        /// Defaults to
        /// `nil.`
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(rootRecordDesiredKeys))]
        #[unsafe(method_family = none)]
        pub unsafe fn rootRecordDesiredKeys(&self) -> Option<Retained<NSArray<CKRecordFieldKey>>>;

        #[cfg(feature = "CKRecord")]
        /// Setter for [`rootRecordDesiredKeys`][Self::rootRecordDesiredKeys].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setRootRecordDesiredKeys:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRootRecordDesiredKeys(
            &self,
            root_record_desired_keys: Option<&NSArray<CKRecordFieldKey>>,
        );

        #[cfg(all(feature = "CKShareMetadata", feature = "block2"))]
        /// Called once for each share URL that the server processed
        ///
        ///
        /// Each
        /// `CKOperation`instance has a private serial queue. This queue is used for all callback block invocations.
        /// This block may share mutable state with other blocks assigned to this operation, but any such mutable state
        /// should not be concurrently used outside of blocks assigned to this operation.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// - The returned block's argument 1 must be a valid pointer.
        /// - The returned block's argument 2 must be a valid pointer or null.
        /// - The returned block's argument 3 must be a valid pointer or null.
        /// - This might not be thread-safe.
        #[unsafe(method(perShareMetadataBlock))]
        #[unsafe(method_family = none)]
        pub unsafe fn perShareMetadataBlock(
            &self,
        ) -> *mut block2::DynBlock<dyn Fn(NonNull<NSURL>, *mut CKShareMetadata, *mut NSError)>;

        #[cfg(all(feature = "CKShareMetadata", feature = "block2"))]
        /// Setter for [`perShareMetadataBlock`][Self::perShareMetadataBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setPerShareMetadataBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPerShareMetadataBlock(
            &self,
            per_share_metadata_block: Option<
                &block2::DynBlock<dyn Fn(NonNull<NSURL>, *mut CKShareMetadata, *mut NSError)>,
            >,
        );

        #[cfg(feature = "block2")]
        /// This block is called when the operation completes.
        ///
        ///
        /// The
        ///
        /// ```text
        ///  -[NSOperation completionBlock]
        /// ```
        ///
        /// will also be called if both are set.
        /// If the error is
        /// `CKErrorPartialFailure,`the error's userInfo dictionary contains a dictionary of shareURLs to errors keyed off of
        /// `CKPartialErrorsByItemIDKey.`These errors are repeats of those sent back in previous
        /// `perShareMetadataBlock`invocations
        /// Each
        /// `CKOperation`instance has a private serial queue. This queue is used for all callback block invocations.
        /// This block may share mutable state with other blocks assigned to this operation, but any such mutable state
        /// should not be concurrently used outside of blocks assigned to this operation.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// - The returned block's argument must be a valid pointer or null.
        /// - This might not be thread-safe.
        #[unsafe(method(fetchShareMetadataCompletionBlock))]
        #[unsafe(method_family = none)]
        pub unsafe fn fetchShareMetadataCompletionBlock(
            &self,
        ) -> *mut block2::DynBlock<dyn Fn(*mut NSError)>;

        #[cfg(feature = "block2")]
        /// Setter for [`fetchShareMetadataCompletionBlock`][Self::fetchShareMetadataCompletionBlock].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(setFetchShareMetadataCompletionBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFetchShareMetadataCompletionBlock(
            &self,
            fetch_share_metadata_completion_block: Option<&block2::DynBlock<dyn Fn(*mut NSError)>>,
        );
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "CKOperation")]
impl CKFetchShareMetadataOperation {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
