/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.configuration;

import de.focus_shift.jollyday.core.configuration.ConfigurationProvider;
import de.focus_shift.jollyday.core.util.ClassLoadingUtil;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProviderClassesConfigurationProvider
implements ConfigurationProvider {
    static final String CONFIG_PROVIDERS_PROPERTY = "de.focus_shift.jollyday.config.providers";
    private static final Logger LOG = LoggerFactory.getLogger(ProviderClassesConfigurationProvider.class);

    ProviderClassesConfigurationProvider() {
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        String providerClassNames = System.getProperty(CONFIG_PROVIDERS_PROPERTY);
        if (providerClassNames != null) {
            Arrays.stream(providerClassNames.split(",")).filter(Predicate.not(String::isEmpty)).map(String::trim).forEach(providerClassName -> {
                try {
                    Class<?> providerClass = Class.forName(providerClassName, true, ClassLoadingUtil.getClassloader());
                    ConfigurationProvider configurationProvider = (ConfigurationProvider)providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    properties.putAll((Map<?, ?>)configurationProvider.getProperties());
                }
                catch (Exception e) {
                    LOG.warn("Cannot load configuration from provider class '{}'. {} ({}).", new Object[]{providerClassName, e.getClass().getSimpleName(), e.getMessage()});
                }
            });
        }
        return properties;
    }
}

