/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.RootDSE;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetUserResourceLimitsRequestControl
extends Control {
    @NotNull
    public static final String GET_USER_RESOURCE_LIMITS_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.25";
    @NotNull
    public static final String EXCLUDE_GROUPS_FEATURE_OID = "1.3.6.1.4.1.30221.2.12.6";
    private static final byte TYPE_EXCLUDE_GROUPS = -128;
    @NotNull
    private static final String JSON_FIELD_EXCLUDE_GROUPS = "exclude-groups";
    private static final long serialVersionUID = -4349321415426346390L;
    private final boolean excludeGroups;

    public GetUserResourceLimitsRequestControl() {
        this(false);
    }

    public GetUserResourceLimitsRequestControl(boolean isCritical) {
        this(false, false);
    }

    public GetUserResourceLimitsRequestControl(boolean isCritical, boolean excludeGroups) {
        super(GET_USER_RESOURCE_LIMITS_REQUEST_OID, isCritical, GetUserResourceLimitsRequestControl.encodeValue(excludeGroups));
        this.excludeGroups = excludeGroups;
    }

    @Nullable
    private static ASN1OctetString encodeValue(boolean excludeGroups) {
        if (excludeGroups) {
            return new ASN1OctetString(new ASN1Sequence(new ASN1Boolean(-128, true)).encode());
        }
        return null;
    }

    public GetUserResourceLimitsRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        ASN1OctetString value = control.getValue();
        if (value == null) {
            this.excludeGroups = false;
            return;
        }
        try {
            boolean excludeGroupsMutable = false;
            ASN1Sequence valueSequence = ASN1Sequence.decodeAsSequence(value.getValue());
            for (ASN1Element e : valueSequence.elements()) {
                switch (e.getType()) {
                    case -128: {
                        excludeGroupsMutable = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                    }
                }
            }
            this.excludeGroups = excludeGroupsMutable;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_USER_RESOURCE_LIMITS_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public boolean excludeGroups() {
        return this.excludeGroups;
    }

    public static boolean serverAdvertisesExcludeGroupsFeature(@NotNull RootDSE rootDSE) {
        return rootDSE.supportsFeature(EXCLUDE_GROUPS_FEATURE_OID);
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_GET_USER_RESOURCE_LIMITS_REQUEST.get();
    }

    @Override
    @NotNull
    public JSONObject toJSONControl() {
        return new JSONObject(new JSONField("oid", GET_USER_RESOURCE_LIMITS_REQUEST_OID), new JSONField("control-name", ControlMessages.INFO_CONTROL_NAME_GET_USER_RESOURCE_LIMITS_REQUEST.get()), new JSONField("criticality", this.isCritical()), new JSONField("value-json", new JSONObject(new JSONField(JSON_FIELD_EXCLUDE_GROUPS, this.excludeGroups))));
    }

    @NotNull
    public static GetUserResourceLimitsRequestControl decodeJSONControl(@NotNull JSONObject controlObject, boolean strict) throws LDAPException {
        List<String> unrecognizedFields;
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, true);
        ASN1OctetString rawValue = jsonControl.getRawValue();
        if (rawValue != null) {
            return new GetUserResourceLimitsRequestControl(new Control(jsonControl.getOID(), jsonControl.getCriticality(), rawValue));
        }
        JSONObject valueObject = jsonControl.getValueObject();
        Boolean excludeGroups = valueObject.getFieldAsBoolean(JSON_FIELD_EXCLUDE_GROUPS);
        if (excludeGroups == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_USER_RESOURCE_LIMITS_REQUEST_JSON_MISSING_EXCLUDE_GROUPS.get(controlObject.toSingleLineString(), JSON_FIELD_EXCLUDE_GROUPS));
        }
        if (strict && !(unrecognizedFields = JSONControlDecodeHelper.getControlObjectUnexpectedFields(valueObject, JSON_FIELD_EXCLUDE_GROUPS)).isEmpty()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_USER_RESOURCE_LIMITS_REQUEST_JSON_UNRECOGNIZED_FIELD.get(controlObject.toSingleLineString(), unrecognizedFields.get(0)));
        }
        return new GetUserResourceLimitsRequestControl(jsonControl.getCriticality(), (boolean)excludeGroups);
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("GetUserResourceLimitsRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(", excludeGroups=");
        buffer.append(this.excludeGroups);
        buffer.append(')');
    }
}

