/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.util.Base64;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.cert.CertException;
import com.unboundid.util.ssl.cert.CertMessages;
import com.unboundid.util.ssl.cert.PKCS8EncryptionHandler;
import com.unboundid.util.ssl.cert.PKCS8PrivateKey;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class PKCS8PEMFileReader
implements Closeable {
    @NotNull
    public static final String BEGIN_ENCRYPTED_PRIVATE_KEY_HEADER = "-----BEGIN ENCRYPTED PRIVATE KEY-----";
    @NotNull
    public static final String BEGIN_PRIVATE_KEY_HEADER = "-----BEGIN PRIVATE KEY-----";
    @NotNull
    public static final String BEGIN_RSA_PRIVATE_KEY_HEADER = "-----BEGIN RSA PRIVATE KEY-----";
    @NotNull
    public static final String END_ENCRYPTED_PRIVATE_KEY_FOOTER = "-----END ENCRYPTED PRIVATE KEY-----";
    @NotNull
    public static final String END_PRIVATE_KEY_FOOTER = "-----END PRIVATE KEY-----";
    @NotNull
    public static final String END_RSA_PRIVATE_KEY_FOOTER = "-----END RSA PRIVATE KEY-----";
    @NotNull
    private final BufferedReader reader;

    public PKCS8PEMFileReader(@NotNull String pemFilePath) throws IOException {
        this(new File(pemFilePath));
    }

    public PKCS8PEMFileReader(@NotNull File pemFile) throws IOException {
        this(new FileInputStream(pemFile));
    }

    public PKCS8PEMFileReader(@NotNull InputStream inputStream) {
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
    }

    @Nullable
    public PKCS8PrivateKey readPrivateKey() throws IOException, CertException {
        return this.readPrivateKey(null);
    }

    @Nullable
    public PKCS8PrivateKey readPrivateKey(@Nullable char[] encryptionPassword) throws IOException, CertException {
        boolean isEncrypted = false;
        String beginLine = null;
        StringBuilder base64Buffer = new StringBuilder();
        while (true) {
            String line;
            if ((line = this.reader.readLine()) == null) {
                if (beginLine != null) {
                    throw new CertException(CertMessages.ERR_PKCS8_PEM_READER_EOF_WITHOUT_END.get(END_PRIVATE_KEY_FOOTER, beginLine));
                }
                return null;
            }
            String trimmedLine = line.trim();
            if (trimmedLine.isEmpty() || trimmedLine.startsWith("#")) continue;
            String upperLine = StaticUtils.toUpperCase(trimmedLine);
            if (BEGIN_ENCRYPTED_PRIVATE_KEY_HEADER.equals(upperLine) || BEGIN_PRIVATE_KEY_HEADER.equals(upperLine) || BEGIN_RSA_PRIVATE_KEY_HEADER.equals(upperLine)) {
                if (beginLine != null) {
                    throw new CertException(CertMessages.ERR_PKCS8_PEM_READER_REPEATED_BEGIN.get(upperLine));
                }
                beginLine = upperLine;
                if (!BEGIN_ENCRYPTED_PRIVATE_KEY_HEADER.equals(upperLine)) continue;
                isEncrypted = true;
                if (encryptionPassword != null) continue;
                throw new CertException(CertMessages.ERR_PKCS8_PEM_READER_NO_PW_FOR_ENCRYPTED_KEY.get());
            }
            if (END_ENCRYPTED_PRIVATE_KEY_FOOTER.equals(upperLine) || END_PRIVATE_KEY_FOOTER.equals(upperLine) || END_RSA_PRIVATE_KEY_FOOTER.equals(upperLine)) {
                byte[] pkcs8Bytes;
                if (beginLine == null) {
                    throw new CertException(CertMessages.ERR_PKCS8_PEM_READER_END_WITHOUT_BEGIN.get(upperLine, beginLine));
                }
                if (base64Buffer.length() == 0) {
                    throw new CertException(CertMessages.ERR_PKCS8_PEM_READER_END_WITHOUT_DATA.get(upperLine, beginLine));
                }
                if (isEncrypted) {
                    byte[] encryptedKeyBytes;
                    try {
                        encryptedKeyBytes = Base64.decode(base64Buffer.toString());
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new CertException(CertMessages.ERR_PKCS8_PEM_READER_CANNOT_BASE64_DECODE.get(), e);
                    }
                    return PKCS8EncryptionHandler.decryptPrivateKey(encryptedKeyBytes, encryptionPassword);
                }
                try {
                    pkcs8Bytes = Base64.decode(base64Buffer.toString());
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new CertException(CertMessages.ERR_PKCS8_PEM_READER_CANNOT_BASE64_DECODE.get(), e);
                }
                return new PKCS8PrivateKey(pkcs8Bytes);
            }
            if (beginLine == null) {
                throw new CertException(CertMessages.ERR_PKCS8_PEM_READER_DATA_WITHOUT_BEGIN.get(BEGIN_PRIVATE_KEY_HEADER));
            }
            base64Buffer.append(trimmedLine);
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

