/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.spreadsheet;

import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridCell;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridPos;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridContentProvider;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridLabelProvider;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.Spreadsheet;
import org.jkiss.dbeaver.ui.editors.data.internal.DataEditorsMessages;

public class SpreadsheetAccessibleAdapter
extends AccessibleControlAdapter
implements AccessibleListener {
    private static final Map<String, String> lobMimeTypeNames = Map.of("text/html", "html", "text/xml", "xml", "text/css", "css", "text/json", "json", "application/json", "json", "application/octet-stream", "blob", "multipart/*", "multipart", "multipart/related", "multipart");
    private static final boolean READ_VALUE = false;
    private static GridCell lastCell;
    private final Spreadsheet spreadsheet;
    private final GridPos lastPosition;
    private IGridLabelProvider labelProvider;
    private IGridContentProvider contentProvider;
    private GridPos position;
    private GridCell cell;
    private Object value;
    private int rowsCount;
    private int colsCount;
    private int cellsCount;
    private String valueStr;
    private String valueType = "";

    private SpreadsheetAccessibleAdapter(@NotNull Spreadsheet spreadsheet) {
        this.spreadsheet = spreadsheet;
        this.lastPosition = new GridPos(-1, -1);
        this.labelProvider = spreadsheet.getLabelProvider();
        this.contentProvider = spreadsheet.getContentProvider();
    }

    public static void install(@NotNull Spreadsheet spreadsheet) {
        Accessible accessible = spreadsheet.getAccessible();
        SpreadsheetAccessibleAdapter adapter = new SpreadsheetAccessibleAdapter(spreadsheet);
        accessible.addAccessibleListener((AccessibleListener)adapter);
        accessible.addAccessibleControlListener((AccessibleControlListener)adapter);
        spreadsheet.addCursorChangeListener(event -> {
            GridCell cell = spreadsheet.getFocusCell();
            if (cell != null && cell != lastCell) {
                adapter.setNewCell(cell);
                Object[] objectArray = new Object[2];
                objectArray[1] = cell.getRow().getElement();
                accessible.sendEvent(32780, (Object)objectArray);
            }
        });
    }

    public void getValue(AccessibleControlEvent e) {
    }

    public void getName(AccessibleEvent e) {
        if (this.cellsCount == 1) {
            if (this.cell == null) {
                return;
            }
            this.spreadsheet.setAccessibilityEnabled(true);
            this.valueStr = "";
            this.valueType = "";
            this.readValueStringAndType(this.contentProvider, this.cell, this.value);
            e.result = this.lastPosition.col != this.position.col && this.lastPosition.row == this.position.row ? NLS.bind((String)DataEditorsMessages.spreadsheet_accessibility_grid_value_col, (Object[])new Object[]{this.valueStr, this.labelProvider.getText(this.cell.getColumn())}) : (this.lastPosition.row != this.position.row && this.lastPosition.col == this.position.col ? NLS.bind((String)DataEditorsMessages.spreadsheet_accessibility_grid_value_row, (Object[])new Object[]{this.valueStr, this.labelProvider.getText(this.cell.getRow())}) : (!this.lastPosition.equals(this.position) ? NLS.bind((String)DataEditorsMessages.spreadsheet_accessibility_grid_value_row_col, (Object[])new Object[]{this.valueStr, this.labelProvider.getText(this.cell.getRow()), this.labelProvider.getText(this.cell.getColumn()), this.valueType}) : this.valueStr));
        } else {
            e.result = this.rowsCount == 1 ? NLS.bind((String)DataEditorsMessages.spreadsheet_accessibility_columns_selected, (Object)this.colsCount) : (this.colsCount == 1 ? NLS.bind((String)DataEditorsMessages.spreadsheet_accessibility_rows_selected, (Object)this.rowsCount) : DataEditorsMessages.spreadsheet_accessibility_freeform_range_selected);
        }
    }

    private void setNewCell(GridCell cell) {
        if (this.position != null) {
            this.lastPosition.col = this.position.col;
            this.lastPosition.row = this.position.row;
        }
        lastCell = cell;
        this.cell = cell;
        this.position = new GridPos(this.spreadsheet.getCursorPosition());
        this.value = this.contentProvider.getCellValue(cell.getColumn(), cell.getRow(), false);
        this.rowsCount = this.spreadsheet.getRowSelectionSize();
        this.colsCount = this.spreadsheet.getColumnSelectionSize();
        this.cellsCount = this.spreadsheet.getCellSelectionSize();
    }

    private void readValueStringAndType(@NotNull IGridContentProvider contentProvider, @NotNull GridCell cell, Object value) {
        String valueLink;
        String collectionType;
        String contentType = value instanceof DBDContent ? ((DBDContent)value).getContentType() : null;
        String string = collectionType = value instanceof DBDCollection ? ((DBDCollection)value).getComponentType().getName() : null;
        if (contentType != null && lobMimeTypeNames.get(contentType) != null) {
            this.valueStr = NLS.bind((String)DataEditorsMessages.spreadsheet_accessibility_object_of_type, (Object)lobMimeTypeNames.get(contentType));
        } else if (collectionType != null) {
            this.valueStr = NLS.bind((String)DataEditorsMessages.spreadsheet_accessibility_collection_of_type, (Object)collectionType);
        } else if (value instanceof Boolean) {
            this.valueType = DataEditorsMessages.spreadsheet_accessibility_boolean;
            this.valueStr = value.toString();
        } else {
            if (value instanceof String) {
                this.valueType = DataEditorsMessages.spreadsheet_accessibility_string;
            } else if (value instanceof Number) {
                this.valueType = DataEditorsMessages.spreadsheet_accessibility_numeric;
            }
            this.valueStr = contentProvider.getCellValue(cell.getColumn(), cell.getRow(), true).toString();
        }
        if (this.valueStr.isEmpty()) {
            this.valueStr = DataEditorsMessages.spreadsheet_accessibility_empty_string;
        }
        if (contentProvider.isElementReadOnly(cell.getColumn())) {
            this.valueType = NLS.bind((String)DataEditorsMessages.spreadsheet_accessibility_readonly, (Object)this.valueType);
        }
        if (!(valueLink = contentProvider.getCellLinkText(cell.col, cell.row)).isEmpty()) {
            this.valueType = NLS.bind((String)DataEditorsMessages.spreadsheet_accessibility_foreign_key, (Object)this.valueType, (Object)valueLink);
        }
    }

    public void getHelp(AccessibleEvent e) {
    }

    public void getKeyboardShortcut(AccessibleEvent e) {
    }

    public void getDescription(AccessibleEvent e) {
        e.result = DataEditorsMessages.spreadsheet_accessibility_description;
    }
}

