# Rust bindings for the C++ standard library

This directory contains the `cc_std` Rust crate - the crate generated by
`rs_bindings_from_cc` and providing bindings for the C++ standard library. To
depend on it, add the following to your `rust_library` rule:

```
cc_deps = ["//support/public:cc_std"]
```

This crate provides, for example:

-   The `cc_std::std::raw_string_view` type alias (corresponding to
    [`std::string_view`](https://en.cppreference.com/w/cpp/header/string_view)
    in C++)
-   The `cc_std::tm` struct (corresponding to
    [`tm`](https://en.cppreference.com/w/c/chrono/tm) in C++)

In addition to automatically generated bindings, the crate also provides
manually authored trait implementations that supplement the automated bindings.
For example:

-   `impl From<&'static str> for raw_string_view`

## Versioning

The source code for `cc_std` is a combination of the automatically generated
bindings for the C++ standard library, and auxiliary Rust code which is
live-at-head, and lives in the a parallel `cc_std_impl` directory.

`cc_std` can be snapshotted and released as part of a release process.
Backwards-incompatible changes which must go out with a release can be
implemented as feature flags, but the actual source code is always read at head.
