/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.caching;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Cache<V> {
    private final Map<String, V> cachingMap = new ConcurrentHashMap<String, V>();

    public V get(ValueHandler<V> valueHandler) {
        return (V)this.cachingMap.computeIfAbsent(valueHandler.getKey(), key -> valueHandler.createValue());
    }

    public void clear() {
        this.cachingMap.clear();
    }

    public static interface ValueHandler<V> {
        public String getKey();

        public V createValue();
    }
}

