// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 5
// REQUIRES: amdgpu-registered-target
// RUN: %clang_cc1 -triple amdgcn-amd-amdhsa -x hip -emit-llvm -fcuda-is-device \
// RUN:   -o - %s | FileCheck --check-prefix=AMDGCN --enable-var-scope %s
// RUN: %clang_cc1 -triple spirv64-amd-amdhsa -x hip -emit-llvm -fcuda-is-device \
// RUN:   -o - %s | FileCheck --check-prefix=AMDGCNSPIRV --enable-var-scope %s

#define __device__ __attribute__((device))

extern "C" __device__ int printf(const char *format, ...);

// AMDGCN-LABEL: define dso_local noundef i32 @_Z4foo1v(
// AMDGCN-SAME: ) #[[ATTR0:[0-9]+]] {
// AMDGCN-NEXT:  [[ENTRY:.*]]:
// AMDGCN-NEXT:    [[S:%.*]] = alloca ptr, align 8, addrspace(5)
// AMDGCN-NEXT:    [[S_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[S]] to ptr
// AMDGCN-NEXT:    store ptr addrspacecast (ptr addrspace(4) @.str to ptr), ptr [[S_ASCAST]], align 8
// AMDGCN-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[S_ASCAST]], align 8
// AMDGCN-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[S_ASCAST]], align 8
// AMDGCN-NEXT:    [[TMP2:%.*]] = call i64 @__ockl_printf_begin(i64 0)
// AMDGCN-NEXT:    [[TMP3:%.*]] = icmp eq ptr addrspacecast (ptr addrspace(4) @.str.1 to ptr), null
// AMDGCN-NEXT:    br i1 [[TMP3]], label %[[STRLEN_JOIN:.*]], label %[[STRLEN_WHILE:.*]]
// AMDGCN:       [[STRLEN_WHILE]]:
// AMDGCN-NEXT:    [[TMP4:%.*]] = phi ptr [ addrspacecast (ptr addrspace(4) @.str.1 to ptr), %[[ENTRY]] ], [ [[TMP5:%.*]], %[[STRLEN_WHILE]] ]
// AMDGCN-NEXT:    [[TMP5]] = getelementptr i8, ptr [[TMP4]], i64 1
// AMDGCN-NEXT:    [[TMP6:%.*]] = load i8, ptr [[TMP4]], align 1
// AMDGCN-NEXT:    [[TMP7:%.*]] = icmp eq i8 [[TMP6]], 0
// AMDGCN-NEXT:    br i1 [[TMP7]], label %[[STRLEN_WHILE_DONE:.*]], label %[[STRLEN_WHILE]]
// AMDGCN:       [[STRLEN_WHILE_DONE]]:
// AMDGCN-NEXT:    [[TMP8:%.*]] = ptrtoint ptr [[TMP4]] to i64
// AMDGCN-NEXT:    [[TMP9:%.*]] = sub i64 [[TMP8]], ptrtoint (ptr addrspacecast (ptr addrspace(4) @.str.1 to ptr) to i64)
// AMDGCN-NEXT:    [[TMP10:%.*]] = add i64 [[TMP9]], 1
// AMDGCN-NEXT:    br label %[[STRLEN_JOIN]]
// AMDGCN:       [[STRLEN_JOIN]]:
// AMDGCN-NEXT:    [[TMP11:%.*]] = phi i64 [ [[TMP10]], %[[STRLEN_WHILE_DONE]] ], [ 0, %[[ENTRY]] ]
// AMDGCN-NEXT:    [[TMP12:%.*]] = call i64 @__ockl_printf_append_string_n(i64 [[TMP2]], ptr addrspacecast (ptr addrspace(4) @.str.1 to ptr), i64 [[TMP11]], i32 0)
// AMDGCN-NEXT:    [[TMP13:%.*]] = call i64 @__ockl_printf_append_args(i64 [[TMP12]], i32 1, i64 8, i64 0, i64 0, i64 0, i64 0, i64 0, i64 0, i32 0)
// AMDGCN-NEXT:    [[TMP14:%.*]] = call i64 @__ockl_printf_append_args(i64 [[TMP13]], i32 1, i64 4614256650576692846, i64 0, i64 0, i64 0, i64 0, i64 0, i64 0, i32 0)
// AMDGCN-NEXT:    [[TMP15:%.*]] = call i64 @__ockl_printf_append_args(i64 [[TMP14]], i32 1, i64 8, i64 0, i64 0, i64 0, i64 0, i64 0, i64 0, i32 0)
// AMDGCN-NEXT:    [[TMP16:%.*]] = call i64 @__ockl_printf_append_args(i64 [[TMP15]], i32 1, i64 4, i64 0, i64 0, i64 0, i64 0, i64 0, i64 0, i32 0)
// AMDGCN-NEXT:    [[TMP17:%.*]] = icmp eq ptr [[TMP0]], null
// AMDGCN-NEXT:    br i1 [[TMP17]], label %[[STRLEN_JOIN1:.*]], label %[[STRLEN_WHILE2:.*]]
// AMDGCN:       [[STRLEN_WHILE2]]:
// AMDGCN-NEXT:    [[TMP18:%.*]] = phi ptr [ [[TMP0]], %[[STRLEN_JOIN]] ], [ [[TMP19:%.*]], %[[STRLEN_WHILE2]] ]
// AMDGCN-NEXT:    [[TMP19]] = getelementptr i8, ptr [[TMP18]], i64 1
// AMDGCN-NEXT:    [[TMP20:%.*]] = load i8, ptr [[TMP18]], align 1
// AMDGCN-NEXT:    [[TMP21:%.*]] = icmp eq i8 [[TMP20]], 0
// AMDGCN-NEXT:    br i1 [[TMP21]], label %[[STRLEN_WHILE_DONE3:.*]], label %[[STRLEN_WHILE2]]
// AMDGCN:       [[STRLEN_WHILE_DONE3]]:
// AMDGCN-NEXT:    [[TMP22:%.*]] = ptrtoint ptr [[TMP0]] to i64
// AMDGCN-NEXT:    [[TMP23:%.*]] = ptrtoint ptr [[TMP18]] to i64
// AMDGCN-NEXT:    [[TMP24:%.*]] = sub i64 [[TMP23]], [[TMP22]]
// AMDGCN-NEXT:    [[TMP25:%.*]] = add i64 [[TMP24]], 1
// AMDGCN-NEXT:    br label %[[STRLEN_JOIN1]]
// AMDGCN:       [[STRLEN_JOIN1]]:
// AMDGCN-NEXT:    [[TMP26:%.*]] = phi i64 [ [[TMP25]], %[[STRLEN_WHILE_DONE3]] ], [ 0, %[[STRLEN_JOIN]] ]
// AMDGCN-NEXT:    [[TMP27:%.*]] = call i64 @__ockl_printf_append_string_n(i64 [[TMP16]], ptr [[TMP0]], i64 [[TMP26]], i32 0)
// AMDGCN-NEXT:    [[TMP28:%.*]] = ptrtoint ptr [[TMP1]] to i64
// AMDGCN-NEXT:    [[TMP29:%.*]] = call i64 @__ockl_printf_append_args(i64 [[TMP27]], i32 1, i64 [[TMP28]], i64 0, i64 0, i64 0, i64 0, i64 0, i64 0, i32 1)
// AMDGCN-NEXT:    [[TMP30:%.*]] = trunc i64 [[TMP29]] to i32
// AMDGCN-NEXT:    ret i32 [[TMP30]]
//
// AMDGCNSPIRV-LABEL: define spir_func noundef i32 @_Z4foo1v(
// AMDGCNSPIRV-SAME: ) addrspace(4) #[[ATTR0:[0-9]+]] {
// AMDGCNSPIRV-NEXT:  [[ENTRY:.*]]:
// AMDGCNSPIRV-NEXT:    [[S:%.*]] = alloca ptr addrspace(4), align 8
// AMDGCNSPIRV-NEXT:    [[S_ASCAST:%.*]] = addrspacecast ptr [[S]] to ptr addrspace(4)
// AMDGCNSPIRV-NEXT:    store ptr addrspace(4) addrspacecast (ptr addrspace(1) @.str to ptr addrspace(4)), ptr addrspace(4) [[S_ASCAST]], align 8
// AMDGCNSPIRV-NEXT:    [[TMP0:%.*]] = load ptr addrspace(4), ptr addrspace(4) [[S_ASCAST]], align 8
// AMDGCNSPIRV-NEXT:    [[TMP1:%.*]] = load ptr addrspace(4), ptr addrspace(4) [[S_ASCAST]], align 8
// AMDGCNSPIRV-NEXT:    [[TMP2:%.*]] = call addrspace(4) i64 @__ockl_printf_begin(i64 0)
// AMDGCNSPIRV-NEXT:    [[TMP3:%.*]] = icmp eq ptr addrspace(4) addrspacecast (ptr addrspace(1) @.str.1 to ptr addrspace(4)), null
// AMDGCNSPIRV-NEXT:    br i1 [[TMP3]], label %[[STRLEN_JOIN:.*]], label %[[STRLEN_WHILE:.*]]
// AMDGCNSPIRV:       [[STRLEN_WHILE]]:
// AMDGCNSPIRV-NEXT:    [[TMP4:%.*]] = phi ptr addrspace(4) [ addrspacecast (ptr addrspace(1) @.str.1 to ptr addrspace(4)), %[[ENTRY]] ], [ [[TMP5:%.*]], %[[STRLEN_WHILE]] ]
// AMDGCNSPIRV-NEXT:    [[TMP5]] = getelementptr i8, ptr addrspace(4) [[TMP4]], i64 1
// AMDGCNSPIRV-NEXT:    [[TMP6:%.*]] = load i8, ptr addrspace(4) [[TMP4]], align 1
// AMDGCNSPIRV-NEXT:    [[TMP7:%.*]] = icmp eq i8 [[TMP6]], 0
// AMDGCNSPIRV-NEXT:    br i1 [[TMP7]], label %[[STRLEN_WHILE_DONE:.*]], label %[[STRLEN_WHILE]]
// AMDGCNSPIRV:       [[STRLEN_WHILE_DONE]]:
// AMDGCNSPIRV-NEXT:    [[TMP8:%.*]] = ptrtoint ptr addrspace(4) [[TMP4]] to i64
// AMDGCNSPIRV-NEXT:    [[TMP9:%.*]] = sub i64 [[TMP8]], ptrtoint (ptr addrspace(4) addrspacecast (ptr addrspace(1) @.str.1 to ptr addrspace(4)) to i64)
// AMDGCNSPIRV-NEXT:    [[TMP10:%.*]] = add i64 [[TMP9]], 1
// AMDGCNSPIRV-NEXT:    br label %[[STRLEN_JOIN]]
// AMDGCNSPIRV:       [[STRLEN_JOIN]]:
// AMDGCNSPIRV-NEXT:    [[TMP11:%.*]] = phi i64 [ [[TMP10]], %[[STRLEN_WHILE_DONE]] ], [ 0, %[[ENTRY]] ]
// AMDGCNSPIRV-NEXT:    [[TMP12:%.*]] = call addrspace(4) i64 @__ockl_printf_append_string_n(i64 [[TMP2]], ptr addrspace(4) addrspacecast (ptr addrspace(1) @.str.1 to ptr addrspace(4)), i64 [[TMP11]], i32 0)
// AMDGCNSPIRV-NEXT:    [[TMP13:%.*]] = call addrspace(4) i64 @__ockl_printf_append_args(i64 [[TMP12]], i32 1, i64 8, i64 0, i64 0, i64 0, i64 0, i64 0, i64 0, i32 0)
// AMDGCNSPIRV-NEXT:    [[TMP14:%.*]] = call addrspace(4) i64 @__ockl_printf_append_args(i64 [[TMP13]], i32 1, i64 4614256650576692846, i64 0, i64 0, i64 0, i64 0, i64 0, i64 0, i32 0)
// AMDGCNSPIRV-NEXT:    [[TMP15:%.*]] = call addrspace(4) i64 @__ockl_printf_append_args(i64 [[TMP14]], i32 1, i64 8, i64 0, i64 0, i64 0, i64 0, i64 0, i64 0, i32 0)
// AMDGCNSPIRV-NEXT:    [[TMP16:%.*]] = call addrspace(4) i64 @__ockl_printf_append_args(i64 [[TMP15]], i32 1, i64 4, i64 0, i64 0, i64 0, i64 0, i64 0, i64 0, i32 0)
// AMDGCNSPIRV-NEXT:    [[TMP17:%.*]] = icmp eq ptr addrspace(4) [[TMP0]], null
// AMDGCNSPIRV-NEXT:    br i1 [[TMP17]], label %[[STRLEN_JOIN1:.*]], label %[[STRLEN_WHILE2:.*]]
// AMDGCNSPIRV:       [[STRLEN_WHILE2]]:
// AMDGCNSPIRV-NEXT:    [[TMP18:%.*]] = phi ptr addrspace(4) [ [[TMP0]], %[[STRLEN_JOIN]] ], [ [[TMP19:%.*]], %[[STRLEN_WHILE2]] ]
// AMDGCNSPIRV-NEXT:    [[TMP19]] = getelementptr i8, ptr addrspace(4) [[TMP18]], i64 1
// AMDGCNSPIRV-NEXT:    [[TMP20:%.*]] = load i8, ptr addrspace(4) [[TMP18]], align 1
// AMDGCNSPIRV-NEXT:    [[TMP21:%.*]] = icmp eq i8 [[TMP20]], 0
// AMDGCNSPIRV-NEXT:    br i1 [[TMP21]], label %[[STRLEN_WHILE_DONE3:.*]], label %[[STRLEN_WHILE2]]
// AMDGCNSPIRV:       [[STRLEN_WHILE_DONE3]]:
// AMDGCNSPIRV-NEXT:    [[TMP22:%.*]] = ptrtoint ptr addrspace(4) [[TMP0]] to i64
// AMDGCNSPIRV-NEXT:    [[TMP23:%.*]] = ptrtoint ptr addrspace(4) [[TMP18]] to i64
// AMDGCNSPIRV-NEXT:    [[TMP24:%.*]] = sub i64 [[TMP23]], [[TMP22]]
// AMDGCNSPIRV-NEXT:    [[TMP25:%.*]] = add i64 [[TMP24]], 1
// AMDGCNSPIRV-NEXT:    br label %[[STRLEN_JOIN1]]
// AMDGCNSPIRV:       [[STRLEN_JOIN1]]:
// AMDGCNSPIRV-NEXT:    [[TMP26:%.*]] = phi i64 [ [[TMP25]], %[[STRLEN_WHILE_DONE3]] ], [ 0, %[[STRLEN_JOIN]] ]
// AMDGCNSPIRV-NEXT:    [[TMP27:%.*]] = call addrspace(4) i64 @__ockl_printf_append_string_n(i64 [[TMP16]], ptr addrspace(4) [[TMP0]], i64 [[TMP26]], i32 0)
// AMDGCNSPIRV-NEXT:    [[TMP28:%.*]] = ptrtoint ptr addrspace(4) [[TMP1]] to i64
// AMDGCNSPIRV-NEXT:    [[TMP29:%.*]] = call addrspace(4) i64 @__ockl_printf_append_args(i64 [[TMP27]], i32 1, i64 [[TMP28]], i64 0, i64 0, i64 0, i64 0, i64 0, i64 0, i32 1)
// AMDGCNSPIRV-NEXT:    [[TMP30:%.*]] = trunc i64 [[TMP29]] to i32
// AMDGCNSPIRV-NEXT:    ret i32 [[TMP30]]
//
__device__ int foo1() {
  const char *s = "hello world";
  return printf("%.*f %*.*s %p\n", 8, 3.14159, 8, 4, s, s);
}

__device__ char *dstr;

// AMDGCN-LABEL: define dso_local noundef i32 @_Z4foo2v(
// AMDGCN-SAME: ) #[[ATTR0:[0-9]+]] {
// AMDGCN-NEXT:  [[ENTRY:.*]]:
// AMDGCN-NEXT:    [[TMP0:%.*]] = load ptr, ptr addrspacecast (ptr addrspace(1) @dstr to ptr), align 8
// AMDGCN-NEXT:    [[TMP1:%.*]] = load ptr, ptr addrspacecast (ptr addrspace(1) @dstr to ptr), align 8
// AMDGCN-NEXT:    [[TMP2:%.*]] = call i64 @__ockl_printf_begin(i64 0)
// AMDGCN-NEXT:    [[TMP3:%.*]] = icmp eq ptr addrspacecast (ptr addrspace(4) @.str.2 to ptr), null
// AMDGCN-NEXT:    br i1 [[TMP3]], label %[[STRLEN_JOIN:.*]], label %[[STRLEN_WHILE:.*]]
// AMDGCN:       [[STRLEN_WHILE]]:
// AMDGCN-NEXT:    [[TMP4:%.*]] = phi ptr [ addrspacecast (ptr addrspace(4) @.str.2 to ptr), %[[ENTRY]] ], [ [[TMP5:%.*]], %[[STRLEN_WHILE]] ]
// AMDGCN-NEXT:    [[TMP5]] = getelementptr i8, ptr [[TMP4]], i64 1
// AMDGCN-NEXT:    [[TMP6:%.*]] = load i8, ptr [[TMP4]], align 1
// AMDGCN-NEXT:    [[TMP7:%.*]] = icmp eq i8 [[TMP6]], 0
// AMDGCN-NEXT:    br i1 [[TMP7]], label %[[STRLEN_WHILE_DONE:.*]], label %[[STRLEN_WHILE]]
// AMDGCN:       [[STRLEN_WHILE_DONE]]:
// AMDGCN-NEXT:    [[TMP8:%.*]] = ptrtoint ptr [[TMP4]] to i64
// AMDGCN-NEXT:    [[TMP9:%.*]] = sub i64 [[TMP8]], ptrtoint (ptr addrspacecast (ptr addrspace(4) @.str.2 to ptr) to i64)
// AMDGCN-NEXT:    [[TMP10:%.*]] = add i64 [[TMP9]], 1
// AMDGCN-NEXT:    br label %[[STRLEN_JOIN]]
// AMDGCN:       [[STRLEN_JOIN]]:
// AMDGCN-NEXT:    [[TMP11:%.*]] = phi i64 [ [[TMP10]], %[[STRLEN_WHILE_DONE]] ], [ 0, %[[ENTRY]] ]
// AMDGCN-NEXT:    [[TMP12:%.*]] = call i64 @__ockl_printf_append_string_n(i64 [[TMP2]], ptr addrspacecast (ptr addrspace(4) @.str.2 to ptr), i64 [[TMP11]], i32 0)
// AMDGCN-NEXT:    [[TMP13:%.*]] = icmp eq ptr [[TMP0]], null
// AMDGCN-NEXT:    br i1 [[TMP13]], label %[[STRLEN_JOIN1:.*]], label %[[STRLEN_WHILE2:.*]]
// AMDGCN:       [[STRLEN_WHILE2]]:
// AMDGCN-NEXT:    [[TMP14:%.*]] = phi ptr [ [[TMP0]], %[[STRLEN_JOIN]] ], [ [[TMP15:%.*]], %[[STRLEN_WHILE2]] ]
// AMDGCN-NEXT:    [[TMP15]] = getelementptr i8, ptr [[TMP14]], i64 1
// AMDGCN-NEXT:    [[TMP16:%.*]] = load i8, ptr [[TMP14]], align 1
// AMDGCN-NEXT:    [[TMP17:%.*]] = icmp eq i8 [[TMP16]], 0
// AMDGCN-NEXT:    br i1 [[TMP17]], label %[[STRLEN_WHILE_DONE3:.*]], label %[[STRLEN_WHILE2]]
// AMDGCN:       [[STRLEN_WHILE_DONE3]]:
// AMDGCN-NEXT:    [[TMP18:%.*]] = ptrtoint ptr [[TMP0]] to i64
// AMDGCN-NEXT:    [[TMP19:%.*]] = ptrtoint ptr [[TMP14]] to i64
// AMDGCN-NEXT:    [[TMP20:%.*]] = sub i64 [[TMP19]], [[TMP18]]
// AMDGCN-NEXT:    [[TMP21:%.*]] = add i64 [[TMP20]], 1
// AMDGCN-NEXT:    br label %[[STRLEN_JOIN1]]
// AMDGCN:       [[STRLEN_JOIN1]]:
// AMDGCN-NEXT:    [[TMP22:%.*]] = phi i64 [ [[TMP21]], %[[STRLEN_WHILE_DONE3]] ], [ 0, %[[STRLEN_JOIN]] ]
// AMDGCN-NEXT:    [[TMP23:%.*]] = call i64 @__ockl_printf_append_string_n(i64 [[TMP12]], ptr [[TMP0]], i64 [[TMP22]], i32 0)
// AMDGCN-NEXT:    [[TMP24:%.*]] = ptrtoint ptr [[TMP1]] to i64
// AMDGCN-NEXT:    [[TMP25:%.*]] = call i64 @__ockl_printf_append_args(i64 [[TMP23]], i32 1, i64 [[TMP24]], i64 0, i64 0, i64 0, i64 0, i64 0, i64 0, i32 1)
// AMDGCN-NEXT:    [[TMP26:%.*]] = trunc i64 [[TMP25]] to i32
// AMDGCN-NEXT:    ret i32 [[TMP26]]
//
// AMDGCNSPIRV-LABEL: define spir_func noundef i32 @_Z4foo2v(
// AMDGCNSPIRV-SAME: ) addrspace(4) #[[ATTR0:[0-9]+]] {
// AMDGCNSPIRV-NEXT:  [[ENTRY:.*]]:
// AMDGCNSPIRV-NEXT:    [[TMP0:%.*]] = load ptr addrspace(4), ptr addrspace(4) addrspacecast (ptr addrspace(1) @dstr to ptr addrspace(4)), align 8
// AMDGCNSPIRV-NEXT:    [[TMP1:%.*]] = load ptr addrspace(4), ptr addrspace(4) addrspacecast (ptr addrspace(1) @dstr to ptr addrspace(4)), align 8
// AMDGCNSPIRV-NEXT:    [[TMP2:%.*]] = call addrspace(4) i64 @__ockl_printf_begin(i64 0)
// AMDGCNSPIRV-NEXT:    [[TMP3:%.*]] = icmp eq ptr addrspace(4) addrspacecast (ptr addrspace(1) @.str.2 to ptr addrspace(4)), null
// AMDGCNSPIRV-NEXT:    br i1 [[TMP3]], label %[[STRLEN_JOIN:.*]], label %[[STRLEN_WHILE:.*]]
// AMDGCNSPIRV:       [[STRLEN_WHILE]]:
// AMDGCNSPIRV-NEXT:    [[TMP4:%.*]] = phi ptr addrspace(4) [ addrspacecast (ptr addrspace(1) @.str.2 to ptr addrspace(4)), %[[ENTRY]] ], [ [[TMP5:%.*]], %[[STRLEN_WHILE]] ]
// AMDGCNSPIRV-NEXT:    [[TMP5]] = getelementptr i8, ptr addrspace(4) [[TMP4]], i64 1
// AMDGCNSPIRV-NEXT:    [[TMP6:%.*]] = load i8, ptr addrspace(4) [[TMP4]], align 1
// AMDGCNSPIRV-NEXT:    [[TMP7:%.*]] = icmp eq i8 [[TMP6]], 0
// AMDGCNSPIRV-NEXT:    br i1 [[TMP7]], label %[[STRLEN_WHILE_DONE:.*]], label %[[STRLEN_WHILE]]
// AMDGCNSPIRV:       [[STRLEN_WHILE_DONE]]:
// AMDGCNSPIRV-NEXT:    [[TMP8:%.*]] = ptrtoint ptr addrspace(4) [[TMP4]] to i64
// AMDGCNSPIRV-NEXT:    [[TMP9:%.*]] = sub i64 [[TMP8]], ptrtoint (ptr addrspace(4) addrspacecast (ptr addrspace(1) @.str.2 to ptr addrspace(4)) to i64)
// AMDGCNSPIRV-NEXT:    [[TMP10:%.*]] = add i64 [[TMP9]], 1
// AMDGCNSPIRV-NEXT:    br label %[[STRLEN_JOIN]]
// AMDGCNSPIRV:       [[STRLEN_JOIN]]:
// AMDGCNSPIRV-NEXT:    [[TMP11:%.*]] = phi i64 [ [[TMP10]], %[[STRLEN_WHILE_DONE]] ], [ 0, %[[ENTRY]] ]
// AMDGCNSPIRV-NEXT:    [[TMP12:%.*]] = call addrspace(4) i64 @__ockl_printf_append_string_n(i64 [[TMP2]], ptr addrspace(4) addrspacecast (ptr addrspace(1) @.str.2 to ptr addrspace(4)), i64 [[TMP11]], i32 0)
// AMDGCNSPIRV-NEXT:    [[TMP13:%.*]] = icmp eq ptr addrspace(4) [[TMP0]], null
// AMDGCNSPIRV-NEXT:    br i1 [[TMP13]], label %[[STRLEN_JOIN1:.*]], label %[[STRLEN_WHILE2:.*]]
// AMDGCNSPIRV:       [[STRLEN_WHILE2]]:
// AMDGCNSPIRV-NEXT:    [[TMP14:%.*]] = phi ptr addrspace(4) [ [[TMP0]], %[[STRLEN_JOIN]] ], [ [[TMP15:%.*]], %[[STRLEN_WHILE2]] ]
// AMDGCNSPIRV-NEXT:    [[TMP15]] = getelementptr i8, ptr addrspace(4) [[TMP14]], i64 1
// AMDGCNSPIRV-NEXT:    [[TMP16:%.*]] = load i8, ptr addrspace(4) [[TMP14]], align 1
// AMDGCNSPIRV-NEXT:    [[TMP17:%.*]] = icmp eq i8 [[TMP16]], 0
// AMDGCNSPIRV-NEXT:    br i1 [[TMP17]], label %[[STRLEN_WHILE_DONE3:.*]], label %[[STRLEN_WHILE2]]
// AMDGCNSPIRV:       [[STRLEN_WHILE_DONE3]]:
// AMDGCNSPIRV-NEXT:    [[TMP18:%.*]] = ptrtoint ptr addrspace(4) [[TMP0]] to i64
// AMDGCNSPIRV-NEXT:    [[TMP19:%.*]] = ptrtoint ptr addrspace(4) [[TMP14]] to i64
// AMDGCNSPIRV-NEXT:    [[TMP20:%.*]] = sub i64 [[TMP19]], [[TMP18]]
// AMDGCNSPIRV-NEXT:    [[TMP21:%.*]] = add i64 [[TMP20]], 1
// AMDGCNSPIRV-NEXT:    br label %[[STRLEN_JOIN1]]
// AMDGCNSPIRV:       [[STRLEN_JOIN1]]:
// AMDGCNSPIRV-NEXT:    [[TMP22:%.*]] = phi i64 [ [[TMP21]], %[[STRLEN_WHILE_DONE3]] ], [ 0, %[[STRLEN_JOIN]] ]
// AMDGCNSPIRV-NEXT:    [[TMP23:%.*]] = call addrspace(4) i64 @__ockl_printf_append_string_n(i64 [[TMP12]], ptr addrspace(4) [[TMP0]], i64 [[TMP22]], i32 0)
// AMDGCNSPIRV-NEXT:    [[TMP24:%.*]] = ptrtoint ptr addrspace(4) [[TMP1]] to i64
// AMDGCNSPIRV-NEXT:    [[TMP25:%.*]] = call addrspace(4) i64 @__ockl_printf_append_args(i64 [[TMP23]], i32 1, i64 [[TMP24]], i64 0, i64 0, i64 0, i64 0, i64 0, i64 0, i32 1)
// AMDGCNSPIRV-NEXT:    [[TMP26:%.*]] = trunc i64 [[TMP25]] to i32
// AMDGCNSPIRV-NEXT:    ret i32 [[TMP26]]
//
__device__ int foo2() {
  return printf("%s %p\n", dstr, dstr);
}
