/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ku extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "erebî";
        final String metaValue_hy = "ermenî";
        final String metaValue_ban = "balînî";
        final String metaValue_bn = "bengalî";
        final String metaValue_bug = "bugî";
        final String metaValue_ccp = "çakmayî";
        final String metaValue_chr = "çerokî";
        final String metaValue_cop = "qiptî";
        final String metaValue_ka = "gurcî";
        final String metaValue_el = "yûnanî";
        final String metaValue_he = "îbranî";
        final String metaValue_jv = "javayî";
        final String metaValue_ja = "japonî";
        final String metaValue_km = "khmerî";
        final String metaValue_kn = "kannadayî";
        final String metaValue_ko = "koreyî";
        final String metaValue_la = "latînî";
        final String metaValue_mak = "makasarî";
        final String metaValue_men = "mende";
        final String metaValue_mn = "moxolî";
        final String metaValue_osa = "osageyî";
        final String metaValue_su = "sundanî";
        final String metaValue_syr = "siryanî";
        final String metaValue_ta = "tamîlî";
        final String metaValue_th = "tayî";
        final String metaValue_bo = "tîbetî";
        final String metaValue_vai = "vaî";
        final Object[][] data = new Object[][] {
            { "001", "dinya" },
            { "002", "Afrîka" },
            { "003", "Amerîkaya Bakur" },
            { "005", "Amerîkaya Başûr" },
            { "009", "Okyanûsya" },
            { "011", "Rojavayê Afrîkayê" },
            { "013", "Amerîkaya Navîn" },
            { "014", "Rojhilatê Afrîkayê" },
            { "015", "Bakurê Afrîkayê" },
            { "017", "Afrîkaya Navîn" },
            { "018", "Başûrê Afrîkayê" },
            { "019", "Amerîka" },
            { "021", "Bakurê Amerîkayê" },
            { "029", "Karayîb" },
            { "030", "Rojhilatê Asyayê" },
            { "034", "Başûrê Asyayê" },
            { "035", "Başûrrojhilatê Asyayê" },
            { "039", "Başûrê Ewropayê" },
            { "053", "Awistralasya" },
            { "054", "Melanezya" },
            { "057", "Herêma Mîkronezyayê" },
            { "061", "Polînezya" },
            { "142", "Asya" },
            { "143", "Asyaya Navîn" },
            { "145", "Rojavayê Asyayê" },
            { "150", "Ewropa" },
            { "151", "Rojhilatê Ewropayê" },
            { "154", "Bakurê Ewropayê" },
            { "155", "Rojavayê Ewropayê" },
            { "202", "Afrîkaya Jêra Sahrayê" },
            { "419", "Amerîkaya Latîn" },
            { "AC", "Girava Ascensionê" },
            { "AD", "Andorra" },
            { "AE", "Mîrgehên Erebî yên Yekbûyî" },
            { "AF", "Efxanistan" },
            { "AG", "Antîgua û Berbûda" },
            { "AI", "Anguîla" },
            { "AL", "Albanya" },
            { "AM", "Ermenistan" },
            { "AO", "Angola" },
            { "AQ", "Antarktîka" },
            { "AR", "Arjantîn" },
            { "AS", "Samoaya Amerîkanî" },
            { "AT", "Awistirya" },
            { "AU", "Awistralya" },
            { "AW", "Arûba" },
            { "AX", "Giravên Alandê" },
            { "AZ", "Azerbeycan" },
            { "BA", "Bosna û Hersek" },
            { "BB", "Barbados" },
            { "BD", "Bengladeş" },
            { "BE", "Belçîka" },
            { "BF", "Burkîna Faso" },
            { "BG", "Bulgaristan" },
            { "BH", "Behreyn" },
            { "BI", "Bûrûndî" },
            { "BJ", "Bênîn" },
            { "BL", "Saint Barthelemy" },
            { "BM", "Bermûda" },
            { "BN", "Brûney" },
            { "BO", "Bolîvya" },
            { "BQ", "Holendaya Karayîbê" },
            { "BR", "Brezîlya" },
            { "BS", "Bahama" },
            { "BT", "Bûtan" },
            { "BV", "Girava Bouvetê" },
            { "BW", "Botswana" },
            { "BY", "Belarûs" },
            { "BZ", "Belîze" },
            { "CA", "Kanada" },
            { "CC", "Giravên Kokosê (Keeling)" },
            { "CD", "Kongo - Kînşasa" },
            { "CF", "Cimhûrîyeta Afrîkaya Navîn" },
            { "CG", "Kongo - Brazzaville" },
            { "CH", "Swîsre" },
            { "CI", "Côte d’Ivoire" },
            { "CK", "Giravên Cookê" },
            { "CL", "Şîlî" },
            { "CM", "Kamerûn" },
            { "CN", "Çîn" },
            { "CO", "Kolombîya" },
            { "CP", "Girava Clippertonê" },
            { "CQ", "Sark" },
            { "CR", "Kosta Rîka" },
            { "CU", "Kuba" },
            { "CV", "Kap Verde" },
            { "CW", "Curaçao" },
            { "CX", "Girava Christmasê" },
            { "CY", "Qibris" },
            { "CZ", "Çekya" },
            { "DE", "Almanya" },
            { "DG", "Diego Garcia" },
            { "DJ", "Cîbûtî" },
            { "DK", "Danîmarka" },
            { "DM", "Domînîka" },
            { "DO", "Cimhûrîyeta Domînîkê" },
            { "DZ", "Cezayîr" },
            { "EA", "Ceuta û Melîla" },
            { "EC", "Ekwador" },
            { "EE", "Estonya" },
            { "EG", "Misir" },
            { "EH", "Sahraya Rojava" },
            { "ER", "Erître" },
            { "ES", "Spanya" },
            { "ET", "Etîyopya" },
            { "EU", "Yekîtîya Ewropayê" },
            { "EZ", "Herêma Ewroyê" },
            { "FI", "Fînlenda" },
            { "FJ", "Fîjî" },
            { "FK", "Giravên Falklandê" },
            { "FM", "Mîkronezya" },
            { "FO", "Giravên Faroeyê" },
            { "FR", "Fransa" },
            { "GA", "Gabon" },
            { "GB", "Qiralîyeta Yekbûyî" },
            { "GD", "Grenada" },
            { "GE", "Gurcistan" },
            { "GF", "Guyanaya Fransî" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "GI", "Cebelîtariq" },
            { "GL", "Grînlanda" },
            { "GM", "Gambîya" },
            { "GN", "Gîne" },
            { "GP", "Guadeloupe" },
            { "GQ", "Gîneya Ekwadorê" },
            { "GR", "Yûnanistan" },
            { "GS", "Giravên Georgîyaya Başûr û Sandwicha Başûr" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Gîne-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hong Konga HîT ya Çînê" },
            { "HM", "Giravên Heard û MacDonaldê" },
            { "HN", "Hondûras" },
            { "HR", "Xirwatistan" },
            { "HT", "Haîtî" },
            { "HU", "Macaristan" },
            { "IC", "Giravên Kanaryayê" },
            { "ID", "Endonezya" },
            { "IE", "Îrlanda" },
            { "IL", "Îsraîl" },
            { "IM", "Girava Manê" },
            { "IN", "Hindistan" },
            { "IO", "Herêma Okyanûsa Hindî ya Brîtanyayê" },
            { "IQ", "Îraq" },
            { "IR", "Îran" },
            { "IS", "Îslanda" },
            { "IT", "Îtalya" },
            { "JE", "Jersey" },
            { "JM", "Jamaîka" },
            { "JO", "Urdun" },
            { "JP", "Japonya" },
            { "KE", "Kenya" },
            { "KG", "Qirgizistan" },
            { "KH", "Kamboçya" },
            { "KI", "Kirîbatî" },
            { "KM", "Komor" },
            { "KN", "Saint Kitts û Nevîs" },
            { "KP", "Koreya Bakur" },
            { "KR", "Koreya Başûr" },
            { "KW", "Kuweyt" },
            { "KY", "Giravên Kaymanê" },
            { "KZ", "Qazaxistan" },
            { "LA", "Laos" },
            { "LB", "Libnan" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Srî Lanka" },
            { "LR", "Lîberya" },
            { "LS", "Lesoto" },
            { "LT", "Lîtvanya" },
            { "LU", "Luksembûrg" },
            { "LV", "Letonya" },
            { "LY", "Lîbya" },
            { "MA", "Fas" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "ME", "Qeredax" },
            { "MF", "Saint Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Giravên Marşalê" },
            { "MK", "Makedonyaya Bakur" },
            { "ML", "Malî" },
            { "MM", "Myanmar (Bûrma)" },
            { "MN", "Moxolistan" },
            { "MO", "Makaoya Hît ya Çînê" },
            { "MP", "Giravên Bakurê Marianan" },
            { "MQ", "Martînîk" },
            { "MR", "Morîtanya" },
            { "MS", "Montserat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldîv" },
            { "MW", "Malawî" },
            { "MX", "Meksîka" },
            { "MY", "Malezya" },
            { "MZ", "Mozambîk" },
            { "NA", "Namîbya" },
            { "NC", "Kaledonyaya Nû" },
            { "NE", "Nîjer" },
            { "NF", "Girava Norfolkê" },
            { "NG", "Nîjerya" },
            { "NI", "Nîkaragua" },
            { "NL", "Holanda" },
            { "NO", "Norwec" },
            { "NP", "Nepal" },
            { "NR", "Naûrû" },
            { "NU", "Niûe" },
            { "NZ", "Zelandaya Nû" },
            { "OM", "Uman" },
            { "PA", "Panama" },
            { "PE", "Perû" },
            { "PF", "Polînezyaya Fransizî" },
            { "PG", "Papua Gîneya Nû" },
            { "PH", "Fîlîpîn" },
            { "PK", "Pakistan" },
            { "PL", "Polonya" },
            { "PM", "Saint-Pierre û Miquelon" },
            { "PN", "Giravên Pitcairnê" },
            { "PR", "Porto Rîko" },
            { "PS", "Herêmên Filistînî" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paragûay" },
            { "QA", "Qeter" },
            { "QO", "Okyanûsyaya Dûr" },
            { "RE", "Réunion" },
            { "RO", "Romanya" },
            { "RS", "Sirbistan" },
            { "RU", "Rûsya" },
            { "RW", "Rwanda" },
            { "SA", "Erebistana Siûdî" },
            { "SB", "Giravên Solomonê" },
            { "SC", "Seyşel" },
            { "SD", "Sûdan" },
            { "SE", "Swêd" },
            { "SG", "Sîngapûr" },
            { "SH", "Saint Helena" },
            { "SI", "Slovenya" },
            { "SJ", "Svalbard û Jan Mayen" },
            { "SK", "Slovakya" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marîno" },
            { "SN", "Senegal" },
            { "SO", "Somalya" },
            { "SR", "Surînam" },
            { "SS", "Sûdana Başûr" },
            { "ST", "Sao Tome û Prînsîpe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Marteen" },
            { "SY", "Sûrîye" },
            { "SZ", "Eswatînî" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Giravên Turks û Kaîkosê" },
            { "TD", "Çad" },
            { "TF", "Herêmên Başûr ên Fransayê" },
            { "TG", "Togo" },
            { "TH", "Tayland" },
            { "TJ", "Tacikistan" },
            { "TK", "Tokelau" },
            { "TL", "Tîmor-Leste" },
            { "TM", "Tirkmenistan" },
            { "TN", "Tûnis" },
            { "TO", "Tonga" },
            { "TR", "Türkiye" },
            { "TT", "Trînîdad û Tobago" },
            { "TV", "Tûvalû" },
            { "TW", "Taywan" },
            { "TZ", "Tanzanya" },
            { "UA", "Ûkrayna" },
            { "UG", "Ûganda" },
            { "UM", "Giravên Biçûk ên Derveyî DAYê" },
            { "UN", "Miletên Yekbûyî" },
            { "US", "Dewletên Amerîkayê yên Yekbûyî" },
            { "UY", "Ûrûguay" },
            { "UZ", "Ozbekistan" },
            { "VA", "Vatîkan" },
            { "VC", "Saint Vincent û Giravên Grenadînê" },
            { "VE", "Venezuela" },
            { "VG", "Giravên Vîrjînê yên Brîtanyayê" },
            { "VI", "Giravên Vîrjînê yên Amerîkayê" },
            { "VN", "Vîetnam" },
            { "VU", "Vanûatû" },
            { "WF", "Wallis û Futuna" },
            { "WS", "Samoa" },
            { "XA", "Aksanên Psodoyê" },
            { "XB", "Psodo Bidî" },
            { "XK", "Kosova" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "Afrîkaya Başûr" },
            { "ZM", "Zambîya" },
            { "ZW", "Zîmbabwe" },
            { "ZZ", "Herêma Nenas" },
            { "aa", "afarî" },
            { "ab", "abxazî" },
            { "af", "afrîkansî" },
            { "ak", "akanî" },
            { "am", "amharî" },
            { "an", "aragonî" },
            { "ar", metaValue_ar },
            { "as", "asamî" },
            { "av", "avarî" },
            { "ay", "aymarayî" },
            { "az", "azerbaycanî" },
            { "ba", "başkîrî" },
            { "be", "belarûsî" },
            { "bg", "bulgarî" },
            { "bi", "bîslamayî" },
            { "bm", "bambarayî" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "bretonî" },
            { "bs", "bosnî" },
            { "ca", "katalanî" },
            { "ce", "çeçenî" },
            { "ch", "çamoroyî" },
            { "co", "korsîkayî" },
            { "cs", "çekî" },
            { "cu", "slavîya kenîseyî" },
            { "cv", "çuvaşî" },
            { "cy", "weylsî" },
            { "da", "danîmarkî" },
            { "de", "almanî" },
            { "dv", "divehî" },
            { "dz", "conxayî" },
            { "ee", "eweyî" },
            { "el", metaValue_el },
            { "en", "îngilîzî" },
            { "eo", "esperantoyî" },
            { "es", "spanî" },
            { "et", "estonî" },
            { "eu", "baskî" },
            { "fa", "farisî" },
            { "ff", "fulahî" },
            { "fi", "fînî" },
            { "fj", "fîjî" },
            { "fo", "ferî" },
            { "fr", "fransizî" },
            { "fy", "frîsîya rojavayî" },
            { "ga", "îrlendî" },
            { "gd", "gaelîka skotî" },
            { "gl", "galîsî" },
            { "gn", "guwaranî" },
            { "gu", "gujaratî" },
            { "gv", "manksî" },
            { "ha", "hawsayî" },
            { "he", metaValue_he },
            { "hi", "hindî" },
            { "hr", "xirwatî" },
            { "ht", "haîtî" },
            { "hu", "macarî" },
            { "hy", metaValue_hy },
            { "hz", "hereroyî" },
            { "ia", "înterlîngua" },
            { "id", "endonezyayî" },
            { "ie", "înterlîngue" },
            { "ig", "îgboyî" },
            { "ii", "yîyîya siçuwayî" },
            { "io", "îdoyî" },
            { "is", "îzlendî" },
            { "it", "îtalî" },
            { "iu", "înuîtî" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "ki", "kîkûyûyî" },
            { "kj", "kwanyamayî" },
            { "kk", "qazaxî" },
            { "kl", "kalalîsûtî" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanurîyî" },
            { "ks", "keşmîrî" },
            { "ku", "kurmancî" },
            { "kv", "komî" },
            { "kw", "kornî" },
            { "ky", "qirgizî" },
            { "la", metaValue_la },
            { "lb", "luksembûrgî" },
            { "lg", "lugandayî" },
            { "li", "lîmbûrgî" },
            { "ln", "lingalayî" },
            { "lo", "lao" },
            { "lt", "lîtwanî" },
            { "lu", "luba-katangayî" },
            { "lv", "latvîyayî" },
            { "mg", "malagasî" },
            { "mh", "marşalî" },
            { "mi", "maorî" },
            { "mk", "makedonî" },
            { "ml", "malayalamî" },
            { "mn", metaValue_mn },
            { "mr", "maratî" },
            { "ms", "malezî" },
            { "mt", "maltayî" },
            { "my", "burmayî" },
            { "na", "nawrûyî" },
            { "nb", "norwecî (bokmål)" },
            { "nd", "ndebelîya bakurî" },
            { "ne", "nepalî" },
            { "ng", "ndongayî" },
            { "nl", "holendî" },
            { "nn", "norwecî (nynorsk)" },
            { "no", "norwecî" },
            { "nr", "ndebelîya başûrî" },
            { "nv", "navajoyî" },
            { "ny", "çîçewayî" },
            { "oc", "oksîtanî" },
            { "om", "oromoyî" },
            { "or", "oriyayî" },
            { "os", "osetî" },
            { "pa", "puncabî" },
            { "pi", "palî" },
            { "pl", "polonî" },
            { "ps", "peştûyî" },
            { "pt", "portugalî" },
            { "qu", "keçwayî" },
            { "rm", "romancî" },
            { "rn", "rundî" },
            { "ro", "romanî" },
            { "ru", "rûsî" },
            { "rw", "kînyariwandayî" },
            { "sa", "sanskrîtî" },
            { "sc", "sardînî" },
            { "sd", "sindhî" },
            { "se", "samîya bakur" },
            { "sg", "sangoyî" },
            { "si", "kîngalî" },
            { "sk", "slovakî" },
            { "sl", "slovenî" },
            { "sm", "samoayî" },
            { "sn", "şonayî" },
            { "so", "somalî" },
            { "sq", "arnawidî" },
            { "sr", "sirbî" },
            { "ss", "swazî" },
            { "st", "sotoyîya başûr" },
            { "su", metaValue_su },
            { "sv", "swêdî" },
            { "sw", "swahîlî" },
            { "ta", metaValue_ta },
            { "te", "telûgûyî" },
            { "tg", "tacikî" },
            { "th", metaValue_th },
            { "ti", "tigrînî" },
            { "tk", "tirkmenî" },
            { "tn", "tswanayî" },
            { "to", "tongî" },
            { "tr", "tirkî" },
            { "ts", "tsongayî" },
            { "tt", "teterî" },
            { "ty", "tahîtî" },
            { "ug", "uyxurî" },
            { "uk", "ukraynî" },
            { "ur", "urdûyî" },
            { "uz", "ozbekî" },
            { "ve", "venda" },
            { "vi", "vîetnamî" },
            { "vo", "volapûkî" },
            { "wa", "walonî" },
            { "wo", "wolofî" },
            { "xh", "xosayî" },
            { "yi", "yidîşî" },
            { "yo", "yorubayî" },
            { "za", "zhuangî" },
            { "zh", "çînî" },
            { "zu", "zuluyî" },
            { "ace", "açehî" },
            { "ada", "adangmeyî" },
            { "ady", "adîgeyî" },
            { "agq", "aghemî" },
            { "ain", "aynuyî" },
            { "ale", "alêwîtî" },
            { "alt", "altayîya başûrî" },
            { "ann", "obolo" },
            { "anp", "angîkayî" },
            { "apc", "erebîya bakurê Şamê" },
            { "arn", "mapuçî" },
            { "arp", "arapahoyî" },
            { "ars", "erebîya necdî" },
            { "asa", "asûyî" },
            { "ast", "astûrî" },
            { "atj", "atîkamekî" },
            { "awa", "awadhî" },
            { "bal", "belûcî" },
            { "ban", metaValue_ban },
            { "bas", "basayî" },
            { "bem", "bembayî" },
            { "bew", "betawî" },
            { "bez", "benayî" },
            { "bgc", "haryanvîyî" },
            { "bgn", "belûcîya rojavayî" },
            { "bho", "bojpûrî" },
            { "bin", "bînîyî" },
            { "bla", "blakfotî" },
            { "blo", "bloyî" },
            { "blt", "tay dam" },
            { "bqi", "bextiyarî" },
            { "brx", "bodoyî" },
            { "bss", "akooseyî" },
            { "bua", "buriat" },
            { "bug", metaValue_bug },
            { "byn", "blînî" },
            { "cad", "kadoyî" },
            { "cay", "kayugayî" },
            { "cch", "atsamî" },
            { "ccp", metaValue_ccp },
            { "ceb", "sebwanoyî" },
            { "cgg", "kîgayî" },
            { "chk", "çûkî" },
            { "chm", "marî" },
            { "cho", "çoktavî" },
            { "chp", "çîpevyayî" },
            { "chr", metaValue_chr },
            { "chy", "çeyenî" },
            { "cic", "çîkasawî" },
            { "ckb", "kurdî (soranî)" },
            { "clc", "çilkotînî" },
            { "cop", metaValue_cop },
            { "crg", "mîçîfî" },
            { "crj", "krîya rojhilat ya başûrî" },
            { "crk", "krîya bejayî" },
            { "crl", "krîya rojhilat ya bakurî" },
            { "crm", "krîya mûsî" },
            { "crr", "zimanê karolina algonquianî" },
            { "csw", "krîya swampî" },
            { "dak", "dakotayî" },
            { "dar", "dargînî" },
            { "dav", "tayîtayî" },
            { "dgr", "dogrîbî" },
            { "dje", "zarma" },
            { "doi", "dogrîyî" },
            { "dsb", "sorbîya jêrîn" },
            { "dua", "diwalayî" },
            { "dyo", "jola-fonyi" },
            { "dzg", "dazagayî" },
            { "ebu", "embuyî" },
            { "efi", "efîkî" },
            { "eka", "ekajukî" },
            { "ewo", "ewondoyî" },
            { "fil", "fîlîpînî" },
            { "fon", "fonî" },
            { "frc", "fransizîya kajûnê" },
            { "frr", "frîsîya bakur" },
            { "fur", "frîyolî" },
            { "gaa", "gayî" },
            { "gez", "geez" },
            { "gil", "kîrîbatî" },
            { "gor", "gorontaloyî" },
            { "gsw", "elmanîşî" },
            { "guz", "gusîî" },
            { "gwi", "gwichʼin" },
            { "hai", "haydayî" },
            { "haw", "hawayî" },
            { "hax", "haîdaya başûrî" },
            { "hil", "hîlîgaynonî" },
            { "hmn", "hmongî" },
            { "hnj", "hmongîya njuayî" },
            { "hsb", "sorbîya jorîn" },
            { "hup", "hupayî" },
            { "hur", "halkomelemî" },
            { "iba", "iban" },
            { "ibb", "îbîbîoyî" },
            { "ikt", "inuvialuktun" },
            { "ilo", "îlokanoyî" },
            { "inh", "îngûşî" },
            { "jbo", "lojbanî" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "kaa", "kara-kalpakî" },
            { "kab", "kabîlî" },
            { "kac", "kaçînî" },
            { "kaj", "jju" },
            { "kam", "kambayî" },
            { "kbd", "kabardî" },
            { "kcg", "tyap" },
            { "kde", "makondeyî" },
            { "kea", "kapverdî" },
            { "kek", "qeqçîyî" },
            { "ken", "kenyangî" },
            { "kfo", "koro" },
            { "kgp", "kayingangî" },
            { "kha", "khasi" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalencînî" },
            { "kmb", "kîmbunduyî" },
            { "kok", "konkanî" },
            { "kpe", "kpelleyî" },
            { "krc", "karaçay-balkarî" },
            { "krl", "karelî" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafyayî" },
            { "ksh", "rîpwarî" },
            { "kum", "kumikî" },
            { "kwk", "kwak’walayî" },
            { "kxv", "kuvî" },
            { "lad", "ladînoyî" },
            { "lag", "langî" },
            { "lez", "lezgînî" },
            { "lij", "lîgûrî" },
            { "lil", "lillooet" },
            { "lkt", "lakotayî" },
            { "lld", "ladînî" },
            { "lmo", "lombardî" },
            { "lou", "kreyolîya louisianayê" },
            { "loz", "lozî" },
            { "lrc", "lurîya bakur" },
            { "lsm", "saamia" },
            { "ltg", "latgalî" },
            { "lua", "luba-kasayî" },
            { "lun", "lunda" },
            { "luo", "luoyî" },
            { "lus", "mizoyî" },
            { "luy", "luhyayî" },
            { "lzz", "lazî" },
            { "mad", "madurayî" },
            { "mag", "magahî" },
            { "mai", "maithili" },
            { "mak", metaValue_mak },
            { "mas", "masayî" },
            { "mdf", "mokşayî" },
            { "men", metaValue_men },
            { "mer", "meruyî" },
            { "mfe", "morisyenî" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta’" },
            { "mhn", "moçenoyî" },
            { "mic", "mîkmakî" },
            { "min", "mînangkabawî" },
            { "mni", "manipuri" },
            { "moe", "înûyîya rojhilatî" },
            { "moh", "mohawkî" },
            { "mos", "moreyî" },
            { "mua", "mundangî" },
            { "mul", "pirzimanî" },
            { "mus", "krîkî" },
            { "mwl", "mîrandî" },
            { "mww", "hmongîya dawî" },
            { "myv", "erzayî" },
            { "mzn", "mazenderanî" },
            { "nan", "çînîya mîn nanî" },
            { "nap", "napolîtanî" },
            { "naq", "namayî" },
            { "nds", "nedersaksî" },
            { "new", "newarî" },
            { "nia", "nîasî" },
            { "niu", "nîwî" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogayî" },
            { "nqo", "n’Ko" },
            { "nso", "sotoyîya bakur" },
            { "nus", "nuer" },
            { "nyn", "nyankole" },
            { "ojb", "ojibweyîya bakurî" },
            { "ojc", "ojibwayîya navîn" },
            { "ojs", "oji-cree" },
            { "ojw", "ojîbweyîya rojavayî" },
            { "oka", "okanagan" },
            { "osa", metaValue_osa },
            { "pag", "pangasînanî" },
            { "pam", "kapampanganî" },
            { "pap", "papyamentoyî" },
            { "pau", "palawî" },
            { "pcm", "pîdgînîya nîjeryayî" },
            { "pis", "pijînî" },
            { "pms", "piedmontîsî" },
            { "pqm", "malecite-passamaquoddy" },
            { "prg", "prûsyayî" },
            { "quc", "k’iche’" },
            { "raj", "rajasthanî" },
            { "rap", "rapanuyî" },
            { "rar", "rarotongî" },
            { "rhg", "rohingyayî" },
            { "rif", "tarifit" },
            { "rof", "rombo" },
            { "rup", "aromanî" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "yakutî" },
            { "saq", "samburuyî" },
            { "sat", "santalî" },
            { "sba", "ngambay" },
            { "sbp", "sanguyî" },
            { "scn", "sicîlî" },
            { "sco", "skotî" },
            { "sdh", "kurdî (xwarîn)" },
            { "seh", "sena" },
            { "ses", "sennîya koyraboro" },
            { "sgs", "samogîtî" },
            { "shi", "taşelhîtî" },
            { "shn", "şanî" },
            { "sid", "sîdamo" },
            { "skr", "seraîkî" },
            { "slh", "lushootseeda başûrî" },
            { "sma", "samîya başûr" },
            { "smj", "samîya lule" },
            { "smn", "samîya înarî" },
            { "sms", "samîya skoltî" },
            { "snk", "soninke" },
            { "srn", "sirananî" },
            { "ssy", "sahoyî" },
            { "str", "saanîçî" },
            { "suk", "sukuma" },
            { "suz", "sunwarî" },
            { "swb", "komorî" },
            { "syr", metaValue_syr },
            { "szl", "silesî" },
            { "tce", "totuçena başûrî" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "tet", "tetûmî" },
            { "tgx", "tagîşî" },
            { "tht", "tahltan" },
            { "tig", "tigre" },
            { "tlh", "klîngonî" },
            { "tli", "tlingit" },
            { "tok", "toki pona" },
            { "tpi", "tokpisinî" },
            { "trv", "tarokoyî" },
            { "trw", "torwalî" },
            { "ttm", "tutoçenîya bakur" },
            { "tum", "tumbukayî" },
            { "tvl", "tuvalûyî" },
            { "twq", "tasawaq" },
            { "tyv", "tuvanî" },
            { "tzm", "temazîxtî" },
            { "udm", "udmurtî" },
            { "umb", "umbunduyî" },
            { "und", "zimanê nenas" },
            { "vai", metaValue_vai },
            { "vec", "venîsî" },
            { "vmw", "makhuwayî" },
            { "vun", "vunjo" },
            { "wae", "walserî" },
            { "wal", "wolaytta" },
            { "war", "warayî" },
            { "wbp", "warlpiri" },
            { "wuu", "çînîya wuyî" },
            { "xal", "kalmîkî" },
            { "xnr", "kangrî" },
            { "xog", "sogayî" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yrl", "nhêngatûyî" },
            { "yue", "kantonî" },
            { "zgh", "amazîxîya fasî" },
            { "zun", "zunîyî" },
            { "zxx", "bê naveroka zimanî" },
            { "zza", "zazakî" },
            { "Adlm", "adlamî" },
            { "Aghb", "albanîya qefqasî" },
            { "Ahom", "ahomî" },
            { "Arab", metaValue_ar },
            { "Aran", "nestalîq" },
            { "Armi", "aramîya împeratorî" },
            { "Armn", metaValue_hy },
            { "Avst", "avestayî" },
            { "Bali", metaValue_ban },
            { "Bamu", "bamumî" },
            { "Bass", "bassa vah" },
            { "Batk", "batakî" },
            { "Beng", metaValue_bn },
            { "Berf", "beria erfe" },
            { "Bhks", "bhaîksukî" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmî" },
            { "Brai", "braille" },
            { "Bugi", metaValue_bug },
            { "Buhd", "buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "heceyên aborjînî yên kanadî yên yekgirtî" },
            { "Cari", "carian" },
            { "Cham", "çamî" },
            { "Cher", metaValue_chr },
            { "Chrs", "xwarezmî" },
            { "Copt", metaValue_cop },
            { "Cpmn", "qibris-mînoanî" },
            { "Cprt", "qibrisî" },
            { "Cyrl", "kirîlî" },
            { "Cyrs", "slavonîka krîlî ya dêrê ya kevn" },
            { "Deva", "devanagarî" },
            { "Diak", "dives akuruyî" },
            { "Dogr", "dograyî" },
            { "Dsrt", "deseret" },
            { "Dupl", "duployé stenografî" },
            { "Egyp", "hîyeroglîfên misirî" },
            { "Elba", "elbasan" },
            { "Elym", "elymaic" },
            { "Ethi", "etîyopîk" },
            { "Gara", "garayî" },
            { "Geor", metaValue_ka },
            { "Glag", "glagolîtîk" },
            { "Gong", "gunjala gondî" },
            { "Gonm", "masaram gondî" },
            { "Goth", "gotîk" },
            { "Gran", "grantha" },
            { "Grek", metaValue_el },
            { "Gujr", "gujeratî" },
            { "Gukh", "gurung khema" },
            { "Guru", "gurmuxî" },
            { "Hanb", "hanîya bi bopomofoyê" },
            { "Hang", "hangulî" },
            { "Hani", "hanî" },
            { "Hano", "hanunoo" },
            { "Hans", "sadekirî" },
            { "Hant", "edetî" },
            { "Hatr", "hatranî" },
            { "Hebr", metaValue_he },
            { "Hira", "hîraganayî" },
            { "Hluw", "hîyeroglîfên anadolî" },
            { "Hmng", "pahawh hmongî" },
            { "Hmnp", "nyiakeng puachue hmongî" },
            { "Hrkt", "nivîsên heceyî yên japonî" },
            { "Hung", "macarîya kevn" },
            { "Ital", "îtalîya kevn" },
            { "Jamo", "jamoyî" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "kayah liyî" },
            { "Kana", "katakanayî" },
            { "Kawi", "kawî" },
            { "Khar", "kharoshthi" },
            { "Khmr", metaValue_km },
            { "Khoj", "khojkî" },
            { "Kits", "nivîsa biçûk ya xîtanî" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Krai", "kirat rai" },
            { "Kthi", "haithi" },
            { "Lana", "lannayî" },
            { "Laoo", "laoyî" },
            { "Latf", "latînîya frakturî" },
            { "Latg", "latînîya gaelîk" },
            { "Latn", metaValue_la },
            { "Lepc", "lepçayî" },
            { "Limb", "lîmbuyî" },
            { "Lina", "lînear a" },
            { "Linb", "lînear b" },
            { "Lisu", "fraser" },
            { "Lyci", "lîkyayî" },
            { "Lydi", "lîdyayî" },
            { "Mahj", "mahajanî" },
            { "Maka", metaValue_mak },
            { "Mand", "mandaean" },
            { "Mani", "manîheyî" },
            { "Marc", "marchen" },
            { "Medf", "medefaidrin" },
            { "Mend", metaValue_men },
            { "Merc", "destnivîsa meroytîk" },
            { "Mero", "meroytîk" },
            { "Mlym", "malayamî" },
            { "Modi", "modî" },
            { "Mong", metaValue_mn },
            { "Mroo", "mro" },
            { "Mtei", "meitei mayekî" },
            { "Mult", "multanî" },
            { "Mymr", "myanmarî" },
            { "Nagm", "nag mundarî" },
            { "Nand", "nandînagarî" },
            { "Narb", "erebîya bakurî ya kevn" },
            { "Nbat", "nebatî" },
            { "Newa", "newayî" },
            { "Nkoo", "n’koyî" },
            { "Nshu", "nüshu" },
            { "Ogam", "ogham" },
            { "Olck", "ol chiki" },
            { "Onao", "ol onal" },
            { "Orkh", "orxun" },
            { "Orya", "odiayî" },
            { "Osge", metaValue_osa },
            { "Osma", "osmanya" },
            { "Ougr", "oygurîya kevn" },
            { "Palm", "palmîrayî" },
            { "Pauc", "pau cin hau" },
            { "Perm", "permîka kevn" },
            { "Phag", "phags-pa" },
            { "Phli", "pehlewîya nivîskî" },
            { "Phlp", "pehlewîya psalter" },
            { "Phnx", "fenîkeyî" },
            { "Plrd", "pollard fonetîk" },
            { "Prti", "partîya nivîskî" },
            { "Qaag", "zawgyi" },
            { "Rjng", "rejang" },
            { "Rohg", "hanîfî" },
            { "Runr", "runîk" },
            { "Samr", "samarîtî" },
            { "Sarb", "erebîya başûrî ya kevn" },
            { "Saur", "sauraştrayî" },
            { "Sgnw", "zimanê îşaretê" },
            { "Shaw", "shavian" },
            { "Shrd", "sharada" },
            { "Sidd", "siddham" },
            { "Sidt", "sidetic" },
            { "Sind", "khudawadi" },
            { "Sinh", "sînhalayî" },
            { "Sogd", "sogdî" },
            { "Sogo", "sogdîya kevn" },
            { "Sora", "sora sompengî" },
            { "Soyo", "soyomboyî" },
            { "Sund", metaValue_su },
            { "Sunu", "sunuwarî" },
            { "Sylo", "syloti nagri" },
            { "Syrc", metaValue_syr },
            { "Syre", "siryanîya estrangelo" },
            { "Syrj", "siryanîya rojavayî" },
            { "Syrn", "siryanîya rojhilatî" },
            { "Tagb", "tagbanwa" },
            { "Takr", "takrî" },
            { "Tale", "taî leyî" },
            { "Talu", "new tai lue" },
            { "Taml", metaValue_ta },
            { "Tang", "tangut" },
            { "Tavt", "tai viet" },
            { "Tayo", "tai yo" },
            { "Telu", "teluguyî" },
            { "Tfng", "tifinagh" },
            { "Tglg", "tagalogî" },
            { "Thaa", "thaanayî" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "tirhuta" },
            { "Tnsa", "tangsayî" },
            { "Todr", "todhrî" },
            { "Tols", "tolong sikî" },
            { "Toto", "totoyî" },
            { "Tutg", "tulu-tîgalarî" },
            { "Ugar", "ugarîtîk" },
            { "Vaii", metaValue_vai },
            { "Vith", "vithkuqi" },
            { "Wara", "varang kshiti" },
            { "Wcho", "wançoyî" },
            { "Xpeo", "farisîya kevn" },
            { "Xsux", "nivîsên bizmarî yên sumero-akadî" },
            { "Yezi", "êzidî" },
            { "Yiii", "yî" },
            { "Zanb", "meydana zanabazar" },
            { "Zinh", "irsî" },
            { "Zmth", "nîşandana matematîkî" },
            { "Zsye", "emojî" },
            { "Zsym", "sembol" },
            { "Zxxx", "nenivîskî" },
            { "Zyyy", "hevpar" },
            { "Zzzz", "alfabeya nenas" },
            { "de_CH", "almanîya bilind a swîsreyî" },
            { "en_GB", "îngilîzî (brîtanî)" },
            { "en_US", "îngilîzî (amerîkî)" },
            { "es_ES", "spanî (Ewropa)" },
            { "fa_AF", "darî" },
            { "nl_BE", "flamî" },
            { "pt_PT", "portugalî (Ewropa)" },
            { "sw_CD", "swahîlîya kongoyî" },
            { "ar_001", "erebîya modern a standard" },
            { "key.ca", "Teqwîm" },
            { "key.co", "Rêzkirin" },
            { "key.cu", "diwîz" },
            { "zh_Hans", "çînîya sadekirî" },
            { "zh_Hant", "çînîya edetî" },
            { "%%1959ACAD", "Akademîk" },
            { "type.ca.roc", "Teqwîma Cimhûrîyeta Çînê" },
            { "type.nu.arab", "Reqemên hindo-erebî" },
            { "type.nu.latn", "Reqemên Rojavayî" },
            { "type.ca.dangi", "Teqwîma Dangî" },
            { "type.nu.roman", "Reqemên Romayî" },
            { "type.ca.coptic", "Teqwîma Qiptî" },
            { "type.ca.hebrew", "Teqwîma Îbranî" },
            { "type.ca.indian", "Teqwîma Milî ya Hindî" },
            { "type.ca.chinese", "Teqwîma Çînî" },
            { "type.ca.islamic", "Teqwîma Hicrî" },
            { "type.ca.iso8601", "Teqwîma ISO-8601ê" },
            { "type.ca.persian", "Teqwîma Îranî" },
            { "type.ca.buddhist", "Teqwîma Budîst" },
            { "type.ca.ethiopic", "Teqwîma Etîyopîk" },
            { "type.ca.japanese", "Teqwîma Japonî" },
            { "type.co.standard", "Awayê Rêzkirina Standard" },
            { "type.ca.gregorian", "Teqwîma Mîladî" },
            { "type.ca.islamic-rgsa", "Teqwîma Hicrî (Siudî)" },
            { "type.ca.islamic-tbla", "Teqwîma Hicrî (15ê tîrmeha 622yan)" },
            { "type.ca.islamic-civil", "Teqwîma Hicrî (16ê tîrmeha 622yan)" },
            { "type.ca.islamic-umalqura", "Teqwîma Hicrî (Um el-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Teqwîma Amete Alem ya Etîyopîk" },
        };
        return data;
    }
}
