/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_om extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Sa’aatii Giriinwiich Gidduugaleessaa",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Sa’aatii Istaandaardii Apia",
               "",
               "Sa’aatii Guyyaa Apia",
               "",
               "Sa’aatii Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Sa’aatii Istaandaardii Odoloota Kuuk",
               "",
               "Sa’aatii Bona Walakkaa Odoloota Kuuk",
               "",
               "Sa’aatii Odoloota Kuuk",
               "",
            };
        final String[] Cuba = new String[] {
               "Sa’aatii Istaandaardii Kuubaa",
               "CST",
               "Sa’aatii Guyyaa Kuubaa",
               "CDT",
               "Sa’aatii Kuubaa",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Sa’aatii Istaandaardii Fiijii",
               "",
               "Sa’aatii Bonaa Fiijii",
               "",
               "Sa’aatii Fiijii",
               "",
            };
        final String[] Gulf = new String[] {
               "Sa’aatii Istaandaardii Gaalfii",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Sa’aatii Istaandaardii Hoovd",
               "",
               "Sa’aatii Bonaa Hoovd",
               "",
               "Sa’aatii Hoovd",
               "",
            };
        final String[] Iran = new String[] {
               "Sa’aatii Istaandaardii Iraan",
               "",
               "Sa’aatii Guyyaa Iraan",
               "",
               "Sa’aatii Iraan",
               "",
            };
        final String[] Niue = new String[] {
               "Sa’aatii Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Sa’aatii Istaandaardii Omsk",
               "",
               "Sa’aatii Bonaa Omsk",
               "",
               "Sa’aatii Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Sa’aatii Istaandaardii Peeruu",
               "",
               "Sa’aatii Bonaa Peeruu",
               "",
               "Sa’aatii Peeruu",
               "",
            };
        final String[] Truk = new String[] {
               "Sa’aatii Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Sa’aatii Odola Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Sa’aatii Istaandaardii Chiilii",
               "",
               "Sa’aatii Bonaa Chiilii",
               "",
               "Sa’aatii Chiilii",
               "",
            };
        final String[] China = new String[] {
               "Sa’aatii Istaandaardii Chaayinaa",
               "CST",
               "Sa’aatii Guyyaa Chaayinaa",
               "CDT",
               "Sa’aatii Chaayinaa",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Sa’aatii Odoloota Kokos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Sa’aatii Daaviis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Sa’aatii Istaandaardii Hindii",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Sa’aatii Istaandaardii Jaappaan",
               "JST",
               "Sa’aatii Guyyaa Jaappaan",
               "JDT",
               "Sa’aatii Jaappaan",
               "JT",
            };
        final String[] Korea = new String[] {
               "Sa’aatii Istaandaardii Kooriyaa",
               "KST",
               "Sa’aatii Guyyaa Kooriyaa",
               "KST",
               "Sa’aatii Kooriyaa",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Sa’aatii Naawuruu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Sa’aatii Neeppaal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Sa’aatii Palawu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Sa’aatii Istaandaardii Saamowaa",
               "SST",
               "Sa’aatii Guyyaa Saamowaa",
               "SST",
               "Sa’aatii Saamowaa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Sa’aatii Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Sa’aatii Istaandaardii Tonga",
               "",
               "Sa’aatii Bonaa Tonga",
               "",
               "Sa’aatii Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Sa’aatii Yuukoon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Sa’aatii Istaandaardii Alaaskaa",
               "AKST",
               "Sa’aatii Guyyaa Alaaskaa",
               "AKDT",
               "Sa’aatii Alaaskaa",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Sa’aatii Istaandaardii Amazoon",
               "",
               "Sa’aatii Bonaa Amazoon",
               "",
               "Sa’aatii Amazoon",
               "",
            };
        final String[] Azores = new String[] {
               "Sa’aatii Istaandaardii Azeeroos",
               "",
               "Sa’aatii Bonaa Azeeroos",
               "",
               "Sa’aatii Azeeroos",
               "",
            };
        final String[] Bhutan = new String[] {
               "Sa’aatii Bihutaan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Sa’aatii Bruunee Darusalaam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Sa’aatii Istaandaardii Odola Bahaa",
               "",
               "Sa’aatii Bonaa Odola Bahaa",
               "",
               "Sa’aatii Odola Bahaa",
               "",
            };
        final String[] Guyana = new String[] {
               "Sa’aatii Guyaanaa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "Sa’aatii Istaandaardii Haawayi-Alewutiyan",
               "HAS",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "Sa’aatii Istaandaardii Israa’eel",
               "IST",
               "Sa’aatii Guyyaa Israa’eel",
               "IDT",
               "Sa’aatii Israa’eel",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Sa’aatii Koosreyaa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Sa’aatii Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Sa’aatii Istaandaardii Mooskoo",
               "MSK",
               "Sa’aatii Bonaa Mooskoo",
               "MSK",
               "Sa’aatii Mooskoo",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Sa’aatii Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Sa’aatii Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Sa’aatii Istaandaardii Tayipeyi",
               "CST",
               "Sa’aatii Guyyaa Tayipeyi",
               "CDT",
               "Sa’aatii Tayipeyi",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Sa’aatii Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Sa’aatii Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Sa’aatii Wallis fi Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Sa’aatii Istaandaardii Arabaa",
               "",
               "Sa’aatii Guyyaa Arabaa",
               "",
               "Sa’aatii Arabaa",
               "",
            };
        final String[] Armenia = new String[] {
               "Sa’aatii Istaandaardii Armaaniyaa",
               "",
               "Sa’aatii Bonaa Armaaniyaa",
               "",
               "Sa’aatii Armaaniyaa",
               "",
            };
        final String[] Bolivia = new String[] {
               "Sa’aatii Boliiviyaa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Sa’aatii Istaandaardii Chatham",
               "",
               "Sa’aatii Guyyaa Chatham",
               "",
               "Sa’aatii Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Sa’aatii Idil-Addunyaa Qindaa’e",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Sa’aatii Ikkuwaadoor",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Sa’aatii Gaambiyeer",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Sa’aatii Istaandaardii Joorjiyaa",
               "",
               "Sa’aatii Bonaa Joorjiyaa",
               "",
               "Sa’aatii Joorjiyaa",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Sa’aatii Istaandaardii Irkutsk",
               "",
               "Sa’aatii Bonaa Irkutsk",
               "",
               "Sa’aatii Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Sa’aatii Istaandaardii Magadan",
               "",
               "Sa’aatii Bonaa Magadan",
               "",
               "Sa’aatii Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Sa’aatii Maayinaamaar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Sa’aatii Istaandaardii Norfolk Island",
               "",
               "Sa’aatii Guyyaa Norfolk Island",
               "",
               "Sa’aatii Norfolk Island",
               "",
            };
        final String[] Noronha = new String[] {
               "Sa’aatii Istaandaardii Fernando de Noronha",
               "",
               "Sa’aatii Bonaa Fernando de Noronha",
               "",
               "Sa’aatii Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Sa’aatii Riiyuuniyeen",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Sa’aatii Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Sa’aatii Odoloota Solomoon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Sa’aatii Takelawu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Sa’aatii Istaandaardii Yuraagaayi",
               "",
               "Sa’aatii Bonaa Yuraagaayi",
               "",
               "Sa’aatii Yuraagaayi",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Sa’aatii Istaandaardii Vanuwatu",
               "",
               "Sa’aatii Bonaa Vanuwatu",
               "",
               "Sa’aatii Vanuwatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Sa’aatii Istaandardii Yakutsk",
               "",
               "Sa’aatii Bonaa Yakutsk",
               "",
               "Sa’aatii Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Sa’aatii Istaandaardii Atilaantiik",
               "AST",
               "Sa’aatii Guyyaa Atilaantiik",
               "ADT",
               "Sa’aatii Atilaantiik",
               "AT",
            };
        final String[] Brasilia = new String[] {
               "Sa’aatii Istaandaardii Biraaziliyaa",
               "",
               "Sa’aatii Bonaa Biraaziliyaa",
               "",
               "Sa’aatii Biraaziliyaa",
               "",
            };
        final String[] Chamorro = new String[] {
               "Sa’aatii Istaandaardii Kamoroo",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Sa’aatii Istaandaardii Kolombiyaa",
               "",
               "Sa’aatii Bonaa Kolombiyaa",
               "",
               "Sa’aatii Kolombiyaa",
               "",
            };
        final String[] Falkland = new String[] {
               "Sa’aatii Istaandaardii Odoloota Faalklaand",
               "",
               "Sa’aatii Bonaa Odoloota Faalklaand",
               "",
               "Sa’aatii Odoloota Faalklaand",
               "",
            };
        final String[] Malaysia = new String[] {
               "Sa’aatii Maaleeshiyaa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Sa’aatii Maaldiivs",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Sa’aatii Istaandaardii Ulaanbaatar",
               "",
               "Sa’aatii Bonaa Ulaanbaatar",
               "",
               "Sa’aatii Ulaanbaatar",
               "",
            };
        final String[] Pakistan = new String[] {
               "Sa’aatii Istaandaardii Paakistaan",
               "PKT",
               "Sa’aatii Bonaa Paakistaan",
               "PKST",
               "Sa’aatii Paakistaan",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Sa’aatii Istaandaardii Paaraaguwaayi",
               "",
               "Sa’aatii Bonaa Paaraaguwaayi",
               "",
               "Sa’aatii Paaraaguwaayi",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Sa’aatii Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Sa’aatii Surinaame",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Sa’aatii Istaandaardii Arjentiinaa",
               "",
               "Sa’aatii Bonaa Arjentiinaa",
               "",
               "Sa’aatii Arjentiinaa",
               "",
            };
        final String[] Christmas = new String[] {
               "Sa’aatii Odola Kirismaas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Sa’aatii Galaapagoos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Sa’aatii Istaandaardii Hoong Koong",
               "HKT",
               "Sa’aatii Bonaa Hoong Koong",
               "HKST",
               "Sa’aatii Hoong Koong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Sa’aatii IndooChaayinaa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Sa’aatii Kiyirigiyistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Sa’aatii Istaandaardii Lord Howe",
               "",
               "Sa’aatii Guyyaa Lord Howe",
               "",
               "Sa’aatii Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Sa’aatii Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Sa’aatii Istaandaardii Moorishiyees",
               "",
               "Sa’aatii Bonaa Moorishiyees",
               "",
               "Sa’aatii Mooriishiyees",
               "",
            };
        final String[] Singapore = new String[] {
               "Sa’aatii Istaandaardii Singaapoor",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Sa’aatii Veenzuweelaa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Sa’aatii Istaandaardii Azerbaajiyaan",
               "",
               "Sa’aatii Bonaa Azerbaajiyaan",
               "",
               "Sa’aatii Azerbaajiyaan",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Sa’aatii Istaandaardii Baangilaadish",
               "",
               "Sa’aatii Bonaa Baangilaadish",
               "",
               "Sa’aatii Baangilaadish",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Sa’aatii Istaandaardii Keep Veerdee",
               "",
               "Sa’aatii Bonaa Keep Veerdee",
               "",
               "Sa’aatii Keep Veerdee",
               "",
            };
        final String[] East_Timor = new String[] {
               "Sa’aatii Tiimoor Bahaa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Sa’aatii Kaazaakistaan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Sa’aatii Siisheels",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Sa’aatii Tajikistaan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Sa’aatii Istaandaardii Uzbeekistaan",
               "",
               "Sa’aatii Bonaa Uzbeekistaan",
               "",
               "Sa’aatii Uzbeekistaan",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Sa’aatii Afgaanistaan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Sa’aatii Istaandaardii Krasnoyarsk",
               "",
               "Sa’aatii Bonaa Krasnoyarsk",
               "",
               "Sa’aatii Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Sa’aatii Istaandaardii New Zealand",
               "NZST",
               "Sa’aatii Guyyaa New Zealand",
               "NZDT",
               "Sa’aatii New Zealand",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "Sa’aatii Istaandaardii Filippiins",
               "PST",
               "Sa’aatii Bonaa Filippiins",
               "PDT",
               "Sa’aatii Filippiins",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Sa’aatii Istaandaardii Vladivostok",
               "",
               "Sa’aatii Bonaa Vladivostok",
               "",
               "Sa’aatii Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Sa’aatii Galaana Hindii",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Sa’aatii Odoloota Line",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Sa’aatii Istaandaardii Newufaawondlaand",
               "NST",
               "Sa’aatii Guyyaa Newufaawondlaand",
               "NDT",
               "Sa’aatii Newufaawondlaand",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Sa’aatii Istaandaardii Turkemenistaan",
               "",
               "Sa’aatii Bonaa Turkemenistaan",
               "",
               "Sa’aatii Turkemenistaan",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Sa’aatii Fireench Guyinaa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Sa’aatii Istaandaardii Kaaledooniyaa Haaraa",
               "",
               "Sa’aatii Bonaa Kaaledooniyaa Haaraa",
               "",
               "Sa’aatii Kaaledooniyaa Haaraa",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Sa’aatii Joorjiyaa Kibbaa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Sa’aatii Istaandaardii Yekaterinburg",
               "",
               "Sa’aatii Bonaa Yekaterinburg",
               "",
               "Sa’aatii Yekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Sa’aatii Afrikaa Gidduugaleessaa",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Sa’aatii Baha Afrikaa",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Sa’aatii Afrikaa Dhihaa",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Sa’aatii Dumont-d’Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Sa’aatii Istaandaardii Awurooppaa Gidduugaleessaa",
               "CET",
               "Sa’aatii Bonaa Awurooppaa Gidduugaleessaa",
               "CEST",
               "Sa’aatii Awurooppaa Gidduugaleessaa",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Sa’aatii Istaandaardii Awurooppaa Bahaa",
               "EET",
               "Sa’aatii Bonaa Awurooppaa Bahaa",
               "EEST",
               "Saaatii Awurooppaa Bahaa",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Sa’aatii Istaandaardii Awurooppaa Dhihaa",
               "WET",
               "Sa’aatii Bonaa Awurooppaa Dhihaa",
               "WEST",
               "Sa’aatii Awurooppaa Dhihaa",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Sa’aatii Istaandaardii Paasfiik Meksiikaan",
               "MST",
               "Sa’aatii Guyyaa Paasfiik Meksiikaan",
               "MDT",
               "Sa’aatii Paasfiik Meksiikaan",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Sa’aatii Istaandaardii Afrikaa Kibbaa",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Sa’aatii Istaandaardii Gidduugaleessaa",
               "CST",
               "Sa’aatii Guyyaa Gidduugaleessaa",
               "CDT",
               "Sa’aatii Gidduugaleessaa",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Sa’aatii Istaandaardii Bahaa",
               "EST",
               "Sa’aatii Guyyaa Bahaa",
               "EDT",
               "Sa’aatii Bahaa",
               "ET",
            };
        final String[] America_Pacific = new String[] {
               "Sa’aatii Istaandaardii Paasfiik",
               "PST",
               "Sa’aatii Guyyaa Paasfiik",
               "PDT",
               "Sa’aatii Paasfiik",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Sa’aatii Firaans Kibbaa fi Antaarktikaa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Sa’aatii Odoloota Giilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Sa’aatii Istaandaardii Haawayi-Alewutiyan",
               "HAS",
               "Sa’aatii Guyyaa Haawayi-Alewutiyan",
               "HADT",
               "Sa’aatii Haawayi-Alewutiyan",
               "HAT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Sa’aatii Odoloota Fooneeks",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Sa’aatii Istaandaardii Ql. Piyeeree fi Mikuyelo",
               "",
               "Sa’aatii Guyyaa Ql. Piyeeree fi Mikuyelo",
               "",
               "Sa’aatii Ql. Piyeeree fi Mikuyelo",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Sa’aatii Istaandaardii Maawonteen",
               "MST",
               "Sa’aatii Guyyaa Maawonteen",
               "MDT",
               "Sa’aatii Maawonteen",
               "MT",
            };
        final String[] Marshall_Islands = new String[] {
               "Sa’aatii Odoloota Maarshaal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Sa’aatii Paapuwaa Giinii Haaraa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Sa’aatii Istaandaardii Awustiraaliyaa Gidduugaleessaa",
               "ACST",
               "Sa’aatii Guyyaa Awustiraaliyaa Gidduugaleessaa",
               "ACDT",
               "Sa’aatii Awustiraaliyaa Gidduugaleessaa",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Sa’aatii Istaandaardii Awustiraaliyaa Bahaa",
               "AEST",
               "Sa’aatii Guyyaa Awustiraaliyaa Bahaa",
               "AEDT",
               "Sa’aatii Awustiraaliyaa Bahaa",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Sa’aatii Sa’aatii Istaandaardii Awustiraaliyaa DhihaaDhiha Awustiraaliyaa",
               "AWST",
               "Sa’aatii Guuyyaa Awustiraaliyaa Dhihaa",
               "AWDT",
               "Sa’aatii Awustiraaliyaa Dhihaa",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Sa’aatii Indooneeshiyaa Gidduugaleessaa",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Sa’aatii Indooneshiyaa Bahaa",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Sa’aatii Indooneeshiyaa Dhihaa",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Sa’aatii Istaandaardii Dhiha Awustiraaliyaa Gidduugaleessaa",
               "",
               "Sa’aatii Guyyaa Dhiha Awustiraaliyaa Gidduugaleessaa",
               "",
               "Sa’aatii Dhiha Awustiraaliyaa Gidduugaleessaa",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Sa’aatii Giriinwiich Gidduugaleessaa",
                    "GMT",
                    "Sa’aatii Bonaa Biritish",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Sa’aatii Idil-Addunyaa Qindaa’e",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Sa’aatii Giriinwiich Gidduugaleessaa",
                    "GMT",
                    "Sa’aatii Istaandaardii Aayiriish",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Sa’aatii Idil-Addunyaa Qindaa’e",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Sa’aatii Idil-Addunyaa Qindaa’e",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Sa’aatii Giriinwiich Gidduugaleessaa",
                    "GMT",
                    "Sa’aatii Bonaa Biritish",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Sa’aatii Idil-Addunyaa Qindaa’e",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "Sa’aatii Idil-Addunyaa Qindaa’e",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Sa’aatii Idil-Addunyaa Qindaa’e",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Sa’aatii Giriinwiich Gidduugaleessaa",
                    "GMT",
                    "Sa’aatii Istaandaardii Aayiriish",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Sa’aatii Giriinwiich Gidduugaleessaa",
                    "GMT",
                    "Sa’aatii Bonaa Biritish",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Sa’aatii Giriinwiich Gidduugaleessaa",
                    "GMT",
                    "Sa’aatii Bonaa Biritish",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Sa’aatii Giriinwiich Gidduugaleessaa",
                    "GMT",
                    "Sa’aatii Bonaa Biritish",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Sa’aatii Giriinwiich Gidduugaleessaa",
                    "GMT",
                    "Sa’aatii Bonaa Biritish",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Sa’aatii Giriinwiich Gidduugaleessaa",
                    "GMT",
                    "Sa’aatii Bonaa Biritish",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
        };
        return data;
    }
}
