/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.text.resources.cldr.ext;

import java.util.ListResourceBundle;

public class FormatData_shn extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] metaValue_generic_QuarterNames = new String[] {
            "သၢမ်လိူၼ်ႁွပ်ႈ 1",
            "သၢမ်လိူၼ်ႁွပ်ႈ 2",
            "သၢမ်လိူၼ်ႁွပ်ႈ 3",
            "သၢမ်လိူၼ်ႁွပ်ႈ 4",
        };
        final String metaValue_generic_DateFormatItem_yyyyMMMEd = "G y MMM d - E";
        final String[] metaValue_MonthNames = new String[] {
            "ၸၼ်ႇဝႃႇရီႇ",
            "ၾႅပ်ႇဝႃႇရီႇ",
            "မၢတ်ႉၶ်ျ",
            "ဢေႇပရႄႇ",
            "မေႇ",
            "ၸုၼ်ႇ",
            "ၸူႇလၢႆႇ",
            "ဢေႃးၵၢတ်ႉ",
            "သႅပ်ႇထႅမ်ႇပႃႇ",
            "ဢွၵ်ႇထူဝ်ႇပႃႇ",
            "ၼူဝ်ႇဝႅမ်ႇပႃႇ",
            "တီႇသႅမ်ႇပႃႇ",
            "",
        };
        final String[] metaValue_MonthAbbreviations = new String[] {
            "ၸၼ်ႇ",
            "ၾႅပ်ႇ",
            "မၢတ်ႉၶ်ျ",
            "ဢေႇ",
            "မေႇ",
            "ၸုၼ်ႇ",
            "ၸူႇ",
            "ဢေႃး",
            "သႅပ်ႇ",
            "ဢွၵ်ႇ",
            "ၼူဝ်ႇ",
            "တီႇ",
            "",
        };
        final String[] metaValue_MonthNarrows = new String[] {
            "ၸ.",
            "ၾ.",
            "မ.",
            "ဢ.",
            "မ.",
            "ၸ.",
            "ၸ.",
            "ဢ.",
            "သ.",
            "ဢ.",
            "ၼ.",
            "တ.",
            "",
        };
        final String[] metaValue_generic_DayNames = new String[] {
            "ဝၼ်းဢႃးတိတ်ႉ",
            "ဝၼ်းၸၼ်",
            "ဝၼ်းဢင်းၵၢၼ်း",
            "ဝၼ်းပုတ်ႉ",
            "ဝၼ်းၽတ်း",
            "ဝၼ်းသုၵ်း",
            "ဝၼ်းသဝ်",
        };
        final String[] metaValue_generic_DayAbbreviations = new String[] {
            "တိတ်ႉ",
            "ၸၼ်",
            "ၵၢၼ်း",
            "ပုတ်ႉ",
            "ၽတ်း",
            "သုၵ်း",
            "သဝ်",
        };
        final String[] metaValue_generic_DayNarrows = new String[] {
            "တိ.",
            "ၸ.",
            "ၵ.",
            "ပု.",
            "ၽ.",
            "သု.",
            "သ.",
        };
        final String[] metaValue_generic_AmPmMarkers = new String[] {
            "တွၼ်ႈၸဝ်ႉ",
            "တွၼ်ႈလႃႈ",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
        };
        final String[] metaValue_generic_narrow_AmPmMarkers = new String[] {
            "ၸ.",
            "လ.",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
        };
        final String[] metaValue_generic_abbreviated_AmPmMarkers = new String[] {
            "တၸ.",
            "တလ.",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
        };
        final String[] metaValue_java_time_long_Eras = new String[] {
            "ဢွၼ်ၼႃႈၸဝ်ႈၶရိတ်ႉ",
            "ပီၶရိတ်ႉ",
        };
        final String[] metaValue_java_time_Eras = new String[] {
            "ပီႇၸီႇ",
            "ဢေႇတီႇ",
        };
        final String[] metaValue_generic_TimePatterns = new String[] {
            "HH:mm:ss zzzz",
            "HH:mm:ss z",
            "HH:mm:ss",
            "HH:mm",
        };
        final String[] metaValue_generic_DateTimePatterns = new String[] {
            "{1} {0}",
            "{1} {0}",
            "{1} {0}",
            "{1} {0}",
        };
        final String metaValue_generic_DateFormatItem_yw = "ဝူင်ႈထူၼ်ႈ w ၶွင်ပီ Y";
        final String metaValue_generic_DateFormatItem_MMMEd = "MMM d - E";
        final String metaValue_generic_DateFormatItem_GyMEd = "G y-MM-dd - E";
        final String metaValue_generic_DateFormatItem_MMMMW = "ဝူင်ႈထူၼ်ႈ W ၶွင်လိူၼ် MMMM";
        final String metaValue_generic_DateFormatItem_yMMMEd = "y MMM d - E";
        final String metaValue_generic_DateFormatItem_yMEd = "y-MM-dd - E";
        final String metaValue_generic_DateFormatItem_Ed = "d - E";
        final String metaValue_generic_DateFormatItem_MEd = "MM-dd - E";
        final String[] metaValue_java_time_buddhist_long_Eras = new String[] {
            "BC",
            "ပီသႃႇသၼႃႇ",
        };
        final String[] metaValue_java_time_buddhist_Eras = new String[] {
            "BC",
            "ပ.သ.",
        };
        final String metaValue_generic_DateFormatItem_yyyyMEd = "GGGGG y-MM-dd - E";
        final String metaValue_buddhist_DateFormatItem_GyMd = "GGGGG y-MM-dd";
        final String[] metaValue_java_time_japanese_long_Eras = new String[] {
            "ပီၶရိတ်ႉ",
            "မေးၸီႇ",
            "တႆးသျူဝ်ႇ",
            "သျူဝ်းဝႃႇ",
            "ႁေးသႄႇ",
            "ရေးဝႃႇ",
        };
        final String[] metaValue_java_time_japanese_Eras = new String[] {
            "ဢေႇတီႇ",
            "မေးၸီႇ",
            "တႆးသျူဝ်ႇ",
            "သျူဝ်းဝႃႇ",
            "ႁေးသီႇ",
            "ရေးဝႃႇ",
        };
        final String[] metaValue_java_time_generic_DatePatterns = new String[] {
            "G y MMMM d - EEEE",
            "G y MMMM d",
            "G y MMM d",
            "G y-MM-dd",
        };
        final String[] metaValue_java_time_roc_long_Eras = new String[] {
            "ပီဢွၼ်တၢင်းထၢႆႇဝၢၼ်း",
            "ထၢႆႇဝၢၼ်း",
        };
        final String[] metaValue_java_time_roc_Eras = new String[] {
            "ပဢတ. ထၢႆႇဝၢၼ်း",
            "ထၢႆႇဝၢၼ်း",
        };
        final String[] metaValue_generic_DatePatterns = new String[] {
            "GGGG y MMMM d - EEEE",
            "GGGG y MMMM d",
            "GGGG y MMM d",
            "GGGG y-MM-dd",
        };
        final String[] metaValue_java_time_islamic_long_Eras = new String[] {
            "",
            "ပီႁေးၵျိရႃႇ",
        };
        final String[] metaValue_java_time_islamic_Eras = new String[] {
            "",
            "ပ.ႁ.",
        };
        final String metaValue_calendarname_gregorian = "ပၵ်းယဵမ်ႈဝၼ်း ၵရႅၵ်ႉၵူဝ်ႇရီႇယၼ်ႇ";
        final String[] metaValue_ListPatterns_standard = new String[] {
            "{0}၊ {1}",
            "{0}၊ {1}",
            "{0} လႄႈ {1}",
            "{0} လႄႈ {1}",
            "",
        };
        final String[] metaValue_ListPatterns_or = new String[] {
            "{0}၊ {1}",
            "{0}၊ {1}",
            "{0}၊ ႁိုဝ် {1}",
            "{0} ႁိုဝ် {1}",
            "",
        };
        final Object[][] data = new Object[][] {
            { "generic.DayNames", metaValue_generic_DayNames },
            { "generic.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "generic.DayNarrows", metaValue_generic_DayNarrows },
            { "generic.QuarterNames", metaValue_generic_QuarterNames },
            { "generic.QuarterAbbreviations", metaValue_generic_QuarterNames },
            { "generic.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "generic.narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "generic.abbreviated.AmPmMarkers", metaValue_generic_abbreviated_AmPmMarkers },
            { "generic.TimePatterns", metaValue_generic_TimePatterns },
            { "java.time.generic.DatePatterns", metaValue_java_time_generic_DatePatterns },
            { "generic.DatePatterns", metaValue_generic_DatePatterns },
            { "generic.DateTimePatterns", metaValue_generic_DateTimePatterns },
            { "generic.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "generic.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "generic.DateFormatItem.GyMEd", metaValue_generic_DateFormatItem_GyMEd },
            { "generic.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "generic.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "generic.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "generic.DateFormatItem.yyyyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "generic.DateFormatItem.yyyyMEd", metaValue_generic_DateFormatItem_yyyyMEd },
            { "generic.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "generic.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "generic.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "MonthNames", metaValue_MonthNames },
            { "standalone.MonthNames", metaValue_MonthNames },
            { "MonthAbbreviations", metaValue_MonthAbbreviations },
            { "standalone.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "MonthNarrows", metaValue_MonthNarrows },
            { "standalone.MonthNarrows", metaValue_MonthNarrows },
            { "DayNames", metaValue_generic_DayNames },
            { "standalone.DayNames", metaValue_generic_DayAbbreviations },
            { "DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "standalone.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "DayNarrows", metaValue_generic_DayNarrows },
            { "standalone.DayNarrows", metaValue_generic_DayNarrows },
            { "QuarterNames", metaValue_generic_QuarterNames },
            { "standalone.QuarterNames", metaValue_generic_QuarterNames },
            { "QuarterAbbreviations", metaValue_generic_QuarterNames },
            { "standalone.QuarterAbbreviations",
                new String[] {
                    "ႁွပ်ႈ1",
                    "ႁွပ်ႈ2",
                    "ႁွပ်ႈ3",
                    "ႁွပ်ႈ4",
                }
            },
            { "AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "abbreviated.AmPmMarkers", metaValue_generic_abbreviated_AmPmMarkers },
            { "java.time.long.Eras", metaValue_java_time_long_Eras },
            { "long.Eras", metaValue_java_time_long_Eras },
            { "java.time.Eras", metaValue_java_time_Eras },
            { "Eras", metaValue_java_time_Eras },
            { "java.time.narrow.Eras", metaValue_java_time_Eras },
            { "narrow.Eras", metaValue_java_time_Eras },
            { "field.era", "ပၢၼ်" },
            { "field.year", "ပီ" },
            { "field.month", "လိူၼ်" },
            { "field.week", "ဝူင်ႈ" },
            { "field.weekday", "ဝၼ်းၶွင်ဝူင်ႈ" },
            { "field.dayperiod", "ၶၢဝ်းယၢမ်းဝၼ်း" },
            { "field.hour", "မူင်း" },
            { "timezone.regionFormat", "ၶၢဝ်းယၢမ်း {0}" },
            { "timezone.regionFormat.daylight", "ၶၢဝ်းယၢမ်း ၵၢင်ဝၼ်း {0}" },
            { "timezone.regionFormat.standard", "လၵ်းၸဵင် ၶၢဝ်းယၢမ်း {0}" },
            { "field.minute", "မိၼိတ်ႉ" },
            { "field.second", "သႅၵ်ႉၵၢၼ်ႉ" },
            { "field.zone", "ၸူၼ်ႇၶၢဝ်းယၢမ်း" },
            { "TimePatterns", metaValue_generic_TimePatterns },
            { "DatePatterns",
                new String[] {
                    "y MMMM d - EEEE",
                    "y MMMM d",
                    "y MMM d",
                    "y-MM-dd",
                }
            },
            { "DateTimePatterns", metaValue_generic_DateTimePatterns },
            { "DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "DateFormatItem.GyMEd", metaValue_generic_DateFormatItem_GyMEd },
            { "DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "buddhist.MonthNames", metaValue_MonthNames },
            { "buddhist.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "buddhist.MonthNarrows", metaValue_MonthNarrows },
            { "buddhist.DayNames", metaValue_generic_DayNames },
            { "buddhist.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "buddhist.DayNarrows", metaValue_generic_DayNarrows },
            { "buddhist.QuarterNames", metaValue_generic_QuarterNames },
            { "buddhist.QuarterAbbreviations", metaValue_generic_QuarterNames },
            { "buddhist.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "buddhist.narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "buddhist.abbreviated.AmPmMarkers", metaValue_generic_abbreviated_AmPmMarkers },
            { "java.time.buddhist.long.Eras", metaValue_java_time_buddhist_long_Eras },
            { "buddhist.long.Eras", metaValue_java_time_buddhist_long_Eras },
            { "java.time.buddhist.Eras", metaValue_java_time_buddhist_Eras },
            { "buddhist.Eras", metaValue_java_time_buddhist_Eras },
            { "java.time.buddhist.narrow.Eras", metaValue_java_time_buddhist_Eras },
            { "buddhist.narrow.Eras", metaValue_java_time_buddhist_Eras },
            { "buddhist.TimePatterns", metaValue_generic_TimePatterns },
            { "java.time.buddhist.DatePatterns",
                new String[] {
                    "G y MMMM d - EEEE",
                    "G y MMMM d",
                    "G y MMM d",
                    "GGGGG y-MM-dd",
                }
            },
            { "buddhist.DatePatterns",
                new String[] {
                    "GGGG y MMMM d - EEEE",
                    "GGGG y MMMM d",
                    "GGGG y MMM d",
                    "G y-MM-dd",
                }
            },
            { "buddhist.DateTimePatterns", metaValue_generic_DateTimePatterns },
            { "buddhist.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "buddhist.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "buddhist.DateFormatItem.GyMEd", metaValue_generic_DateFormatItem_GyMEd },
            { "buddhist.DateFormatItem.GyMd", metaValue_buddhist_DateFormatItem_GyMd },
            { "buddhist.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "buddhist.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "buddhist.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "buddhist.DateFormatItem.yyyyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "buddhist.DateFormatItem.yyyyMEd", metaValue_generic_DateFormatItem_yyyyMEd },
            { "buddhist.DateFormatItem.yyyyMd", metaValue_buddhist_DateFormatItem_GyMd },
            { "buddhist.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "buddhist.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "buddhist.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "buddhist.DateFormatItem.yyyyM", "GGGGG y-MM" },
            { "japanese.MonthNames", metaValue_MonthNames },
            { "japanese.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "japanese.MonthNarrows", metaValue_MonthNarrows },
            { "japanese.DayNames", metaValue_generic_DayNames },
            { "japanese.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "japanese.DayNarrows", metaValue_generic_DayNarrows },
            { "japanese.QuarterNames", metaValue_generic_QuarterNames },
            { "japanese.QuarterAbbreviations", metaValue_generic_QuarterNames },
            { "japanese.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "japanese.narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "japanese.abbreviated.AmPmMarkers", metaValue_generic_abbreviated_AmPmMarkers },
            { "java.time.japanese.long.Eras", metaValue_java_time_japanese_long_Eras },
            { "japanese.long.Eras", metaValue_java_time_japanese_long_Eras },
            { "java.time.japanese.Eras", metaValue_java_time_japanese_Eras },
            { "japanese.Eras", metaValue_java_time_japanese_Eras },
            { "japanese.TimePatterns", metaValue_generic_TimePatterns },
            { "java.time.japanese.DatePatterns", metaValue_java_time_generic_DatePatterns },
            { "japanese.DatePatterns",
                new String[] {
                    "GGGG yyyy MMMM d - EEEE",
                    "GGGG yyyy MMMM d",
                    "GGGG y MMM d",
                    "GGGG y-MM-dd",
                }
            },
            { "japanese.DateTimePatterns", metaValue_generic_DateTimePatterns },
            { "japanese.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "japanese.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "japanese.DateFormatItem.GyMEd", metaValue_generic_DateFormatItem_GyMEd },
            { "japanese.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "japanese.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "japanese.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "japanese.DateFormatItem.yyyyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "japanese.DateFormatItem.yyyyMEd", metaValue_generic_DateFormatItem_yyyyMEd },
            { "japanese.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "japanese.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "japanese.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "roc.MonthNames", metaValue_MonthNames },
            { "roc.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "roc.MonthNarrows", metaValue_MonthNarrows },
            { "roc.DayNames", metaValue_generic_DayNames },
            { "roc.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "roc.DayNarrows", metaValue_generic_DayNarrows },
            { "roc.QuarterNames", metaValue_generic_QuarterNames },
            { "roc.QuarterAbbreviations", metaValue_generic_QuarterNames },
            { "roc.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "roc.narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "roc.abbreviated.AmPmMarkers", metaValue_generic_abbreviated_AmPmMarkers },
            { "java.time.roc.long.Eras", metaValue_java_time_roc_long_Eras },
            { "roc.long.Eras", metaValue_java_time_roc_long_Eras },
            { "java.time.roc.Eras", metaValue_java_time_roc_Eras },
            { "roc.Eras", metaValue_java_time_roc_Eras },
            { "java.time.roc.narrow.Eras", metaValue_java_time_roc_Eras },
            { "roc.narrow.Eras", metaValue_java_time_roc_Eras },
            { "roc.TimePatterns", metaValue_generic_TimePatterns },
            { "java.time.roc.DatePatterns", metaValue_java_time_generic_DatePatterns },
            { "roc.DatePatterns", metaValue_generic_DatePatterns },
            { "roc.DateTimePatterns", metaValue_generic_DateTimePatterns },
            { "roc.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "roc.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "roc.DateFormatItem.GyMEd", metaValue_generic_DateFormatItem_GyMEd },
            { "roc.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "roc.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "roc.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "roc.DateFormatItem.yyyyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "roc.DateFormatItem.yyyyMEd", metaValue_generic_DateFormatItem_yyyyMEd },
            { "roc.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "roc.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "roc.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "islamic.MonthNames",
                new String[] {
                    "မူႇႁႃႇရမ်ႇ",
                    "သႃႇၾႃႇ",
                    "ရႃႇပီႇ I",
                    "ရႃႇပီႇ II",
                    "ၵျူႇမႃႇတႃႇ I",
                    "ၵျူႇမႃႇတႃႇ II",
                    "ရႃႇၸၢပ်ႉ",
                    "သျႃးပၢၼ်ႇ",
                    "ရႃႇမႃႇတၢၼ်ႇ",
                    "သျေႃးဝႃႇလ်",
                    "ၻူဝ်ႇလ်-ၵိတ",
                    "ၻူဝ်ႇလ်ႁိတ်ႉၸႃႇ",
                    "",
                }
            },
            { "islamic.MonthAbbreviations",
                new String[] {
                    "မူႇ.",
                    "သႃႇ.",
                    "ရႃႇ. I",
                    "ရႃႇ. II",
                    "ၵျူႇ. I",
                    "ၵျူႇ. II",
                    "ရႃႇၸ်.",
                    "သျႃး.",
                    "ရႃ.",
                    "သျေႃး.",
                    "ၻူဝ်ႇလ်.ၵ.",
                    "ၻူဝ်ႇလ်.ႁ.",
                    "",
                }
            },
            { "islamic.DayNames", metaValue_generic_DayNames },
            { "islamic.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "islamic.DayNarrows", metaValue_generic_DayNarrows },
            { "islamic.QuarterNames", metaValue_generic_QuarterNames },
            { "islamic.QuarterAbbreviations", metaValue_generic_QuarterNames },
            { "islamic.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "islamic.narrow.AmPmMarkers", metaValue_generic_narrow_AmPmMarkers },
            { "islamic.abbreviated.AmPmMarkers", metaValue_generic_abbreviated_AmPmMarkers },
            { "java.time.islamic.long.Eras", metaValue_java_time_islamic_long_Eras },
            { "islamic.long.Eras", metaValue_java_time_islamic_long_Eras },
            { "java.time.islamic.Eras", metaValue_java_time_islamic_Eras },
            { "islamic.Eras", metaValue_java_time_islamic_Eras },
            { "java.time.islamic.narrow.Eras", metaValue_java_time_islamic_Eras },
            { "islamic.narrow.Eras", metaValue_java_time_islamic_Eras },
            { "islamic.TimePatterns", metaValue_generic_TimePatterns },
            { "java.time.islamic.DatePatterns", metaValue_java_time_generic_DatePatterns },
            { "islamic.DatePatterns", metaValue_generic_DatePatterns },
            { "islamic.DateTimePatterns", metaValue_generic_DateTimePatterns },
            { "islamic.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "islamic.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "islamic.DateFormatItem.GyMEd", metaValue_generic_DateFormatItem_GyMEd },
            { "islamic.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "islamic.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "islamic.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "islamic.DateFormatItem.yyyyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "islamic.DateFormatItem.yyyyMEd", metaValue_generic_DateFormatItem_yyyyMEd },
            { "islamic.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "islamic.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "islamic.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "islamic-civil.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "islamic-civil.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "islamic-civil.DateFormatItem.GyMEd", metaValue_generic_DateFormatItem_GyMEd },
            { "islamic-civil.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "islamic-civil.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "islamic-civil.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "islamic-civil.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "islamic-civil.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "islamic-civil.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "islamic-umalqura.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "islamic-umalqura.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "islamic-umalqura.DateFormatItem.GyMEd", metaValue_generic_DateFormatItem_GyMEd },
            { "islamic-umalqura.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "islamic-umalqura.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "islamic-umalqura.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "islamic-umalqura.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "islamic-umalqura.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "islamic-umalqura.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "calendarname.islamic-civil", "ပပ်ႉယဵမ်ႈဝၼ်းႁိၸရိ (လွၵ်းသဵၼ်ႈ၊ ပၢၼ်ၵူၼ်းမိူင်း)" },
            { "calendarname.islamic", "ပၵ်းယဵမ်ႈဝၼ်းႁိၸရိ" },
            { "calendarname.buddhist", "ပၵ်းယဵမ်ႈဝၼ်း ၸၢဝ်းပုတ်ႉထ" },
            { "calendarname.japanese", "ပၵ်းယဵမ်ႈဝၼ်းၵျႃႇပၢၼ်ႇ" },
            { "calendarname.roc", "ပၵ်းယဵမ်ႈဝၼ်းမိင်းၵူႈ" },
            { "calendarname.islamic-umalqura", "ပၵ်းယဵမ်ႈဝၼ်းႁိၸရိ (ဢုမ်ဢႄလ်ၵူးရႃႇ)" },
            { "calendarname.gregorian", metaValue_calendarname_gregorian },
            { "calendarname.gregory", metaValue_calendarname_gregorian },
            { "latn.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "0",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "NaN",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "latn.NumberPatterns",
                new String[] {
                    "#,##0.###",
                    "¤ #,##0.00",
                    "#,##0%",
                    "",
                }
            },
            { "long.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{other:0' 'ႁဵင်}",
                    "{other:0' 'မိုၼ်ႇ}",
                    "{other:0' 'သႅၼ်}",
                    "{other:0' 'လၢၼ်ႉ}",
                    "{other:00' 'လၢၼ်ႉ}",
                    "{other:000' 'လၢၼ်ႉ}",
                    "{other:0' 'ႁဵင်လၢၼ်ႉ}",
                    "{other:0' 'မိုၼ်ႇလၢၼ်ႉ}",
                    "{other:0' 'သႅၼ်လၢၼ်ႉ}",
                    "{other:0' 'လၢၼ်ႉလၢၼ်ႉ}",
                    "{other:00' 'လၢၼ်ႉလၢၼ်ႉ}",
                    "{other:000' 'လၢၼ်ႉလၢၼ်ႉ}",
                }
            },
            { "ListPatterns_standard", metaValue_ListPatterns_standard },
            { "ListPatterns_standard-short", metaValue_ListPatterns_standard },
            { "ListPatterns_standard-narrow", metaValue_ListPatterns_standard },
            { "ListPatterns_or", metaValue_ListPatterns_or },
            { "ListPatterns_or-short", metaValue_ListPatterns_or },
            { "ListPatterns_or-narrow", metaValue_ListPatterns_or },
            { "ListPatterns_unit", metaValue_ListPatterns_standard },
            { "ListPatterns_unit-short", metaValue_ListPatterns_standard },
            { "ListPatterns_unit-narrow", metaValue_ListPatterns_standard },
        };
        return data;
    }
}
