.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XSetFontPath __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XSetFontPath, XGetFontPath, XFreeFontPath \- set, get, or free the font search path
.SH SYNTAX
int XSetFontPath\^(\^Display *\fIdisplay\fP\^, char **\fIdirectories\fP\^, int
\fIndirs\fP\^);
.HP
char **XGetFontPath\^(\^Display *\fIdisplay\fP\^, int *\fInpaths_return\fP\^);
.HP
int XFreeFontPath\^(\^char **\fIlist\fP\^);
.SH ARGUMENTS
.IP \fIdirectories\fP 1i
Specifies the directory path used to look for a font.
Setting the path to the empty list restores the default path defined
for the X server.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIlist\fP 1i
Specifies the array of strings you want to free.
.IP \fIndirs\fP 1i
Specifies the number of directories in the path.
.IP \fInpaths_return\fP 1i
Returns the number of strings in the font path array.
.SH DESCRIPTION
The
.B XSetFontPath
function defines the directory search path for font lookup.
There is only one search path per X server, not one per client.
The encoding and interpretation of the strings are implementation-dependent,
but typically they specify directories or font servers to be searched
in the order listed.
An X server is permitted to cache font information internally;
for example, it might cache an entire font from a file and not
check on subsequent opens of that font to see if the underlying
font file has changed.
However,
when the font path is changed,
the X server is guaranteed to flush all cached information about fonts
for which there currently are no explicit resource IDs allocated.
The meaning of an error from this request is implementation-dependent.
.LP
.B XSetFontPath
can generate a
.B BadValue
error.
.LP
The
.B XGetFontPath
function allocates and returns an array of strings containing the search path.
The contents of these strings are implementation-dependent
and are not intended to be interpreted by client applications.
When it is no longer needed,
the data in the font path should be freed by using
.BR XFreeFontPath .
.LP
The
.B XFreeFontPath
function
frees the data allocated by
.BR XGetFontPath .
.SH DIAGNOSTICS
.TP 1i
.B BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.
Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
.BR XListFont (__libmansuffix__),
.BR XLoadFonts (__libmansuffix__)
.br
\fI\*(xL\fP
