.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XcmsCreateCCC __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XcmsCreateCCC, XcmsFreeCCC \- creating and destroying CCCs
.SH SYNTAX
.HP
XcmsCCC XcmsCreateCCC\^(\^Display *\fIdisplay\fP\^, int \fIscreen_number\fP\^,
Visual *\fIvisual\fP\^, XcmsColor *\fIclient_white_point\fP\^,
XcmsCompressionProc \fIcompression_proc\fP\^, XPointer
\fIcompression_client_data\fP\^, XcmsWhiteAdjustProc
\fIwhite_adjust_proc\fP\^, XPointer \fIwhite_adjust_client_data\fP\^);
.LP
void XcmsFreeCCC\^(\^XcmsCCC \fIccc\fP\^);
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIccc\fP 1i
Specifies the CCC.
.IP \fIclient_white_point\fP 1i
Specifies the Client White Point.
If NULL is specified,
the Client White Point is to be assumed to be the same as the
Screen White Point.
Note that the pixel member is ignored.
.IP \fIcompression_client_data\fP 1i
Specifies client data for use by the gamut compression procedure or NULL.
.IP \fIcompression_proc\fP 1i
Specifies the gamut compression procedure that is to be applied
when a color lies outside the screen's color gamut.
If NULL is specified and a function using this CCC must convert
a color specification to a device-dependent format and encounters a color
that lies outside the screen's color gamut,
that function will return
.BR XcmsFailure .
.IP \fIscreen_number\fP 1i
Specifies the appropriate screen number on the host server.
.IP \fIvisual\fP 1i
Specifies the visual type.
.IP \fIwhite_adjust_client_data\fP 1i
Specifies client data for use with the white point adjustment procedure or NULL.
.IP \fIwhite_adjust_proc\fP 1i
Specifies the white adjustment procedure that is to be applied
when the Client White Point differs from the Screen White Point.
NULL indicates that no white point adjustment is desired.
.SH DESCRIPTION
The
.B XcmsCreateCCC
function creates a CCC for the specified display, screen, and visual.
.LP
The
.B XcmsFreeCCC
function frees the memory used for the specified CCC.
Note that default CCCs and those currently associated with colormaps
are ignored.
.SH "SEE ALSO"
.BR DisplayOfCCC (__libmansuffix__),
.BR XcmsCCCOfColormap (__libmansuffix__),
.BR XcmsConvertColors (__libmansuffix__),
.BR XcmsDefaultCCC (__libmansuffix__),
.BR XcmsSetWhitePoint (__libmansuffix__)
.br
\fI\*(xL\fP
