/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntriesMutator;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassesDexSanitizer
extends ModuleEntriesMutator {
    private static final Pattern CLASSES_DEX_REGEX_PATTERN = Pattern.compile("dex/classes(\\d*)\\.dex");

    @Override
    public Predicate<ModuleEntry> getFilter() {
        return entry -> entry.getPath().toString().matches(CLASSES_DEX_REGEX_PATTERN.pattern());
    }

    @Override
    public Function<ImmutableList<ModuleEntry>, ImmutableList<ModuleEntry>> getMutator() {
        return dexEntries -> dexEntries.stream().map(ClassesDexSanitizer::sanitizeDexEntryName).collect(ImmutableList.toImmutableList());
    }

    @Override
    public boolean shouldApplyMutation(BundleModule module) {
        return module.getEntry(ZipPath.create("dex/classes1.dex")).isPresent();
    }

    private static ModuleEntry sanitizeDexEntryName(ModuleEntry dexEntry) {
        ZipPath sanitizedEntryPath = ClassesDexSanitizer.incrementClassesDexNumber(dexEntry.getPath());
        return dexEntry.toBuilder().setPath(sanitizedEntryPath).build();
    }

    private static ZipPath incrementClassesDexNumber(ZipPath entryPath) {
        int num = ClassesDexSanitizer.getClassesIndexForDexPath(entryPath);
        if (num == 0) {
            return entryPath;
        }
        return ZipPath.create("dex/classes" + (num + 1) + ".dex");
    }

    private static int getClassesIndexForDexPath(ZipPath entryPath) {
        String fileName = entryPath.toString();
        Matcher matcher = CLASSES_DEX_REGEX_PATTERN.matcher(fileName);
        Preconditions.checkState(matcher.matches());
        String num = matcher.group(1);
        if (num.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(num);
    }
}

