/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.sshj.transport.cipher;

import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.transport.cipher.BaseCipher;
import net.schmizz.sshj.transport.cipher.Cipher;

public class GcmCipher
extends BaseCipher {
    protected int authSize;
    protected Cipher.Mode mode;
    protected boolean initialized;
    protected CounterGCMParameterSpec parameters;
    protected SecretKey secretKey;

    public GcmCipher(int ivsize, int authSize, int bsize, String algorithm, String transformation) {
        super(ivsize, bsize, algorithm, transformation);
        this.authSize = authSize;
    }

    @Override
    public int getAuthenticationTagSize() {
        return this.authSize;
    }

    protected Cipher getInitializedCipherInstance() throws GeneralSecurityException {
        if (!this.initialized) {
            this.cipher.init(this.mode == Cipher.Mode.Encrypt ? 1 : 2, (Key)this.secretKey, this.parameters);
            this.initialized = true;
        }
        return this.cipher;
    }

    @Override
    protected void initCipher(Cipher cipher, Cipher.Mode mode, byte[] key, byte[] iv) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.mode = mode;
        this.secretKey = this.getKeySpec(key);
        this.parameters = new CounterGCMParameterSpec(this.getAuthenticationTagSize() * 8, iv);
        cipher.init(this.getMode(mode), (Key)this.secretKey, this.parameters);
        this.initialized = true;
    }

    @Override
    public void updateAAD(byte[] data, int offset, int length) {
        try {
            Cipher cipher = this.getInitializedCipherInstance();
            cipher.updateAAD(data, offset, length);
        }
        catch (GeneralSecurityException e) {
            throw new SSHRuntimeException("Error updating data through cipher", e);
        }
    }

    @Override
    public void update(byte[] input, int inputOffset, int inputLen) {
        if (this.mode == Cipher.Mode.Decrypt) {
            inputLen += this.getAuthenticationTagSize();
        }
        try {
            Cipher cipher = this.getInitializedCipherInstance();
            cipher.doFinal(input, inputOffset, inputLen, input, inputOffset);
        }
        catch (GeneralSecurityException e) {
            throw new SSHRuntimeException("Error updating data through cipher", e);
        }
        this.parameters.incrementCounter();
        this.initialized = false;
    }

    protected static class CounterGCMParameterSpec
    extends GCMParameterSpec {
        protected final byte[] iv;

        protected CounterGCMParameterSpec(int tLen, byte[] src) {
            super(tLen, src);
            if (src.length != 12) {
                throw new IllegalArgumentException("GCM nonce must be 12 bytes, but given len=" + src.length);
            }
            this.iv = (byte[])src.clone();
        }

        protected void incrementCounter() {
            int off = this.iv.length - 8;
            long counter = CounterGCMParameterSpec.getLong(this.iv, off, 8);
            CounterGCMParameterSpec.putLong(CounterGCMParameterSpec.addExact(counter, 1L), this.iv, off, 8);
        }

        @Override
        public byte[] getIV() {
            return (byte[])this.iv.clone();
        }

        static long addExact(long var0, long var2) {
            long var4 = var0 + var2;
            if (((var0 ^ var4) & (var2 ^ var4)) < 0L) {
                throw new ArithmeticException("long overflow");
            }
            return var4;
        }

        static long getLong(byte[] buf, int off, int len) {
            if (len < 8) {
                throw new IllegalArgumentException("Not enough data for a long: required=8, available=" + len);
            }
            long l = (long)buf[off] << 56;
            l |= ((long)buf[off + 1] & 0xFFL) << 48;
            l |= ((long)buf[off + 2] & 0xFFL) << 40;
            l |= ((long)buf[off + 3] & 0xFFL) << 32;
            l |= ((long)buf[off + 4] & 0xFFL) << 24;
            l |= ((long)buf[off + 5] & 0xFFL) << 16;
            l |= ((long)buf[off + 6] & 0xFFL) << 8;
            return l |= (long)buf[off + 7] & 0xFFL;
        }

        static int putLong(long value, byte[] buf, int off, int len) {
            if (len < 8) {
                throw new IllegalArgumentException("Not enough data for a long: required=8, available=" + len);
            }
            buf[off] = (byte)(value >> 56);
            buf[off + 1] = (byte)(value >> 48);
            buf[off + 2] = (byte)(value >> 40);
            buf[off + 3] = (byte)(value >> 32);
            buf[off + 4] = (byte)(value >> 24);
            buf[off + 5] = (byte)(value >> 16);
            buf[off + 6] = (byte)(value >> 8);
            buf[off + 7] = (byte)value;
            return 8;
        }
    }
}

