// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::delete_bucket_metadata_table_configuration::_delete_bucket_metadata_table_configuration_output::DeleteBucketMetadataTableConfigurationOutputBuilder;

pub use crate::operation::delete_bucket_metadata_table_configuration::_delete_bucket_metadata_table_configuration_input::DeleteBucketMetadataTableConfigurationInputBuilder;

impl crate::operation::delete_bucket_metadata_table_configuration::builders::DeleteBucketMetadataTableConfigurationInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::delete_bucket_metadata_table_configuration::DeleteBucketMetadataTableConfigurationOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_bucket_metadata_table_configuration::DeleteBucketMetadataTableConfigurationError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.delete_bucket_metadata_table_configuration();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `DeleteBucketMetadataTableConfiguration`.
///
/// <important>
/// <p>We recommend that you delete your S3 Metadata configurations by using the V2 <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketMetadataTableConfiguration.html">DeleteBucketMetadataTableConfiguration</a> API operation. We no longer recommend using the V1 <code>DeleteBucketMetadataTableConfiguration</code> API operation.</p>
/// <p>If you created your S3 Metadata configuration before July 15, 2025, we recommend that you delete and re-create your configuration by using <a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucketMetadataConfiguration.html">CreateBucketMetadataConfiguration</a> so that you can expire journal table records and create a live inventory table.</p>
/// </important>
/// <p>Deletes a V1 S3 Metadata configuration from a general purpose bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/metadata-tables-overview.html">Accelerating data discovery with S3 Metadata</a> in the <i>Amazon S3 User Guide</i>.</p><note>
/// <p>You can use the V2 <code>DeleteBucketMetadataConfiguration</code> API operation with V1 or V2 metadata table configurations. However, if you try to use the V1 <code>DeleteBucketMetadataTableConfiguration</code> API operation with V2 configurations, you will receive an HTTP <code>405 Method Not Allowed</code> error.</p>
/// <p>Make sure that you update your processes to use the new V2 API operations (<code>CreateBucketMetadataConfiguration</code>, <code>GetBucketMetadataConfiguration</code>, and <code>DeleteBucketMetadataConfiguration</code>) instead of the V1 API operations.</p>
/// </note>
/// <dl>
/// <dt>
/// Permissions
/// </dt>
/// <dd>
/// <p>To use this operation, you must have the <code>s3:DeleteBucketMetadataTableConfiguration</code> permission. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/metadata-tables-permissions.html">Setting up permissions for configuring metadata tables</a> in the <i>Amazon S3 User Guide</i>.</p>
/// </dd>
/// </dl>
/// <p>The following operations are related to <code>DeleteBucketMetadataTableConfiguration</code>:</p>
/// <ul>
/// <li>
/// <p><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucketMetadataTableConfiguration.html">CreateBucketMetadataTableConfiguration</a></p></li>
/// <li>
/// <p><a href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetBucketMetadataTableConfiguration.html">GetBucketMetadataTableConfiguration</a></p></li>
/// </ul><important>
/// <p>You must URL encode any signed header values that contain spaces. For example, if your header value is <code>my file.txt</code>, containing two spaces after <code>my</code>, you must URL encode this value to <code>my%20%20file.txt</code>.</p>
/// </important>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct DeleteBucketMetadataTableConfigurationFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::delete_bucket_metadata_table_configuration::builders::DeleteBucketMetadataTableConfigurationInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::delete_bucket_metadata_table_configuration::DeleteBucketMetadataTableConfigurationOutput,
        crate::operation::delete_bucket_metadata_table_configuration::DeleteBucketMetadataTableConfigurationError,
    > for DeleteBucketMetadataTableConfigurationFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::delete_bucket_metadata_table_configuration::DeleteBucketMetadataTableConfigurationOutput,
            crate::operation::delete_bucket_metadata_table_configuration::DeleteBucketMetadataTableConfigurationError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl DeleteBucketMetadataTableConfigurationFluentBuilder {
    /// Creates a new `DeleteBucketMetadataTableConfigurationFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the DeleteBucketMetadataTableConfiguration as a reference.
    pub fn as_input(
        &self,
    ) -> &crate::operation::delete_bucket_metadata_table_configuration::builders::DeleteBucketMetadataTableConfigurationInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::delete_bucket_metadata_table_configuration::DeleteBucketMetadataTableConfigurationOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::delete_bucket_metadata_table_configuration::DeleteBucketMetadataTableConfigurationError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins =
            crate::operation::delete_bucket_metadata_table_configuration::DeleteBucketMetadataTableConfiguration::operation_runtime_plugins(
                self.handle.runtime_plugins.clone(),
                &self.handle.conf,
                self.config_override,
            );
        crate::operation::delete_bucket_metadata_table_configuration::DeleteBucketMetadataTableConfiguration::orchestrate(&runtime_plugins, input)
            .await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::delete_bucket_metadata_table_configuration::DeleteBucketMetadataTableConfigurationOutput,
        crate::operation::delete_bucket_metadata_table_configuration::DeleteBucketMetadataTableConfigurationError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The general purpose bucket that you want to remove the metadata table configuration from.</p>
    pub fn bucket(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.bucket(input.into());
        self
    }
    /// <p>The general purpose bucket that you want to remove the metadata table configuration from.</p>
    pub fn set_bucket(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_bucket(input);
        self
    }
    /// <p>The general purpose bucket that you want to remove the metadata table configuration from.</p>
    pub fn get_bucket(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_bucket()
    }
    /// <p>The expected bucket owner of the general purpose bucket that you want to remove the metadata table configuration from.</p>
    pub fn expected_bucket_owner(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.expected_bucket_owner(input.into());
        self
    }
    /// <p>The expected bucket owner of the general purpose bucket that you want to remove the metadata table configuration from.</p>
    pub fn set_expected_bucket_owner(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_expected_bucket_owner(input);
        self
    }
    /// <p>The expected bucket owner of the general purpose bucket that you want to remove the metadata table configuration from.</p>
    pub fn get_expected_bucket_owner(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_expected_bucket_owner()
    }
}
