/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import sun.awt.AWTAutoShutdown;
import sun.awt.EventQueueItem;
import sun.awt.SunToolkit;

class PostEventQueue {
    private EventQueueItem queueHead = null;
    private EventQueueItem queueTail = null;
    private final EventQueue eventQueue;
    private Thread flushThread = null;

    PostEventQueue(EventQueue eventQueue) {
        this.eventQueue = eventQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Thread thread = Thread.currentThread();
        try {
            EventQueueItem eventQueueItem;
            PostEventQueue postEventQueue = this;
            synchronized (postEventQueue) {
                if (thread == this.flushThread) {
                    return;
                }
                while (this.flushThread != null) {
                    this.wait();
                }
                if (this.queueHead == null) {
                    return;
                }
                this.flushThread = thread;
                eventQueueItem = this.queueHead;
                this.queueTail = null;
                this.queueHead = null;
            }
            try {
                while (eventQueueItem != null) {
                    this.eventQueue.postEvent(eventQueueItem.event);
                    eventQueueItem = eventQueueItem.next;
                }
            }
            finally {
                postEventQueue = this;
                synchronized (postEventQueue) {
                    this.flushThread = null;
                    this.notifyAll();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            thread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postEvent(AWTEvent aWTEvent) {
        EventQueueItem eventQueueItem = new EventQueueItem(aWTEvent);
        PostEventQueue postEventQueue = this;
        synchronized (postEventQueue) {
            if (this.queueHead == null) {
                this.queueHead = this.queueTail = eventQueueItem;
            } else {
                this.queueTail.next = eventQueueItem;
                this.queueTail = eventQueueItem;
            }
        }
        SunToolkit.wakeupEventQueue(this.eventQueue, aWTEvent.getSource() == AWTAutoShutdown.getInstance());
    }
}

