/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.model;

import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.model.JBBPAbstractArrayField;
import com.igormaznitsa.jbbp.model.JBBPFieldBoolean;
import com.igormaznitsa.jbbp.model.JBBPNumericArray;
import com.igormaznitsa.jbbp.utils.JBBPUtils;

public final class JBBPFieldArrayBoolean
extends JBBPAbstractArrayField<JBBPFieldBoolean>
implements JBBPNumericArray {
    private static final long serialVersionUID = -7896549257985728694L;
    private final boolean[] array;

    public JBBPFieldArrayBoolean(JBBPNamedFieldInfo name, boolean[] array) {
        super(name);
        JBBPUtils.assertNotNull(array, "Array must not be null");
        this.array = array;
    }

    public boolean[] getArray() {
        return (boolean[])this.array.clone();
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public JBBPFieldBoolean getElementAt(int index) {
        JBBPFieldBoolean result = new JBBPFieldBoolean(this.fieldNameInfo, this.getAsBool(index));
        result.payload = this.payload;
        return result;
    }

    @Override
    public int getAsInt(int index) {
        return this.array[index] ? 1 : 0;
    }

    @Override
    public long getAsLong(int index) {
        return this.getAsInt(index);
    }

    @Override
    public boolean getAsBool(int index) {
        return this.array[index];
    }

    @Override
    public Object getValueArrayAsObject(boolean reverseBits) {
        return this.array.clone();
    }

    @Override
    public String getTypeAsString() {
        return "bool [" + this.array.length + "]";
    }
}

