/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_be extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ccp = "чакма";
        final String metaValue_chr = "чэрокі";
        final String metaValue_gu = "гуджараці";
        final String metaValue_kn = "канада";
        final String metaValue_ml = "малаялам";
        final String metaValue_nqo = "нко";
        final String metaValue_or = "орыя";
        final String metaValue_te = "тэлугу";
        final Object[][] data = new Object[][] {
            { "001", "Свет" },
            { "002", "Афрыка" },
            { "003", "Паўночная Амерыка" },
            { "005", "Паўднёвая Амерыка" },
            { "009", "Акіянія" },
            { "011", "Заходняя Афрыка" },
            { "013", "Цэнтральная Амерыка" },
            { "014", "Усходняя Афрыка" },
            { "015", "Паўночная Афрыка" },
            { "017", "Сярэдняя Афрыка" },
            { "018", "Паўднёвая Афрыка" },
            { "019", "Паўночная і Паўднёвая Амерыкі" },
            { "021", "Паўночнаамерыканскі рэгіён" },
            { "029", "Карыбскі рэгіён" },
            { "030", "Усходняя Азія" },
            { "034", "Паўднёвая Азія" },
            { "035", "Паўднёва-Усходняя Азія" },
            { "039", "Паўднёвая Еўропа" },
            { "053", "Аўстралазія" },
            { "054", "Меланезія" },
            { "057", "Мікранезійскі рэгіён" },
            { "061", "Палінезія" },
            { "142", "Азія" },
            { "143", "Цэнтральная Азія" },
            { "145", "Заходняя Азія" },
            { "150", "Еўропа" },
            { "151", "Усходняя Еўропа" },
            { "154", "Паўночная Еўропа" },
            { "155", "Заходняя Еўропа" },
            { "202", "Трапічная Афрыка" },
            { "419", "Лацінская Амерыка" },
            { "AC", "Востраў Узнясення" },
            { "AD", "Андора" },
            { "AE", "Аб’яднаныя Арабскія Эміраты" },
            { "AF", "Афганістан" },
            { "AG", "Антыгуа і Барбуда" },
            { "AI", "Ангілья" },
            { "AL", "Албанія" },
            { "AM", "Арменія" },
            { "AO", "Ангола" },
            { "AQ", "Антарктыка" },
            { "AR", "Аргенціна" },
            { "AS", "Амерыканскае Самоа" },
            { "AT", "Аўстрыя" },
            { "AU", "Аўстралія" },
            { "AW", "Аруба" },
            { "AX", "Аландскія астравы" },
            { "AZ", "Азербайджан" },
            { "BA", "Боснія і Герцагавіна" },
            { "BB", "Барбадас" },
            { "BD", "Бангладэш" },
            { "BE", "Бельгія" },
            { "BF", "Буркіна-Фасо" },
            { "BG", "Балгарыя" },
            { "BH", "Бахрэйн" },
            { "BI", "Бурундзі" },
            { "BJ", "Бенін" },
            { "BL", "Сен-Бартэльмі" },
            { "BM", "Бермудскія астравы" },
            { "BN", "Бруней" },
            { "BO", "Балівія" },
            { "BQ", "Карыбскія Нідэрланды" },
            { "BR", "Бразілія" },
            { "BS", "Багамскія астравы" },
            { "BT", "Бутан" },
            { "BV", "Востраў Бувэ" },
            { "BW", "Батсвана" },
            { "BY", "Беларусь" },
            { "BZ", "Беліз" },
            { "CA", "Канада" },
            { "CC", "Какосавыя (Кілінг) астравы" },
            { "CD", "Конга (Кіншаса)" },
            { "CF", "Цэнтральна-Афрыканская Рэспубліка" },
            { "CG", "Конга - Бразавіль" },
            { "CH", "Швейцарыя" },
            { "CI", "Кот-д’Івуар" },
            { "CK", "Астравы Кука" },
            { "CL", "Чылі" },
            { "CM", "Камерун" },
            { "CN", "Кітай" },
            { "CO", "Калумбія" },
            { "CP", "Востраў Кліпертан" },
            { "CQ", "Сарк" },
            { "CR", "Коста-Рыка" },
            { "CU", "Куба" },
            { "CV", "Каба-Вердэ" },
            { "CW", "Кюрасаа" },
            { "CX", "Востраў Каляд" },
            { "CY", "Кіпр" },
            { "CZ", "Чэхія" },
            { "DE", "Германія" },
            { "DG", "Востраў Дыега-Гарсія" },
            { "DJ", "Джыбуці" },
            { "DK", "Данія" },
            { "DM", "Дамініка" },
            { "DO", "Дамініканская Рэспубліка" },
            { "DZ", "Алжыр" },
            { "EA", "Сеута і Мелілья" },
            { "EC", "Эквадор" },
            { "EE", "Эстонія" },
            { "EG", "Егіпет" },
            { "EH", "Заходняя Сахара" },
            { "ER", "Эрытрэя" },
            { "ES", "Іспанія" },
            { "ET", "Эфіопія" },
            { "EU", "Еўрапейскі саюз" },
            { "EZ", "Еўразона" },
            { "FI", "Фінляндыя" },
            { "FJ", "Фіджы" },
            { "FK", "Фалклендскія астравы" },
            { "FM", "Мікранезія" },
            { "FO", "Фарэрскія астравы" },
            { "FR", "Францыя" },
            { "GA", "Габон" },
            { "GB", "Вялікабрытанія" },
            { "GD", "Грэнада" },
            { "GE", "Грузія" },
            { "GF", "Французская Гвіяна" },
            { "GG", "Гернсі" },
            { "GH", "Гана" },
            { "GI", "Гібралтар" },
            { "GL", "Грэнландыя" },
            { "GM", "Гамбія" },
            { "GN", "Гвінея" },
            { "GP", "Гвадэлупа" },
            { "GQ", "Экватарыяльная Гвінея" },
            { "GR", "Грэцыя" },
            { "GS", "Паўднёвая Георгія і Паўднёвыя Сандвічавы астравы" },
            { "GT", "Гватэмала" },
            { "GU", "Гуам" },
            { "GW", "Гвінея-Бісау" },
            { "GY", "Гаяна" },
            { "HK", "Ганконг, САР (Кітай)" },
            { "HM", "Астравы Херд і Макдональд" },
            { "HN", "Гандурас" },
            { "HR", "Харватыя" },
            { "HT", "Гаіці" },
            { "HU", "Венгрыя" },
            { "IC", "Канарскія астравы" },
            { "ID", "Інданезія" },
            { "IE", "Ірландыя" },
            { "IL", "Ізраіль" },
            { "IM", "Востраў Мэн" },
            { "IN", "Індыя" },
            { "IO", "Брытанская тэрыторыя ў Індыйскім акіяне" },
            { "IQ", "Ірак" },
            { "IR", "Іран" },
            { "IS", "Ісландыя" },
            { "IT", "Італія" },
            { "JE", "Джэрсі" },
            { "JM", "Ямайка" },
            { "JO", "Іарданія" },
            { "JP", "Японія" },
            { "KE", "Кенія" },
            { "KG", "Кыргызстан" },
            { "KH", "Камбоджа" },
            { "KI", "Кірыбаці" },
            { "KM", "Каморскія астравы" },
            { "KN", "Сент-Кітс і Невіс" },
            { "KP", "Паўночная Карэя" },
            { "KR", "Паўднёвая Карэя" },
            { "KW", "Кувейт" },
            { "KY", "Кайманавы астравы" },
            { "KZ", "Казахстан" },
            { "LA", "Лаос" },
            { "LB", "Ліван" },
            { "LC", "Сент-Люсія" },
            { "LI", "Ліхтэнштэйн" },
            { "LK", "Шры-Ланка" },
            { "LR", "Ліберыя" },
            { "LS", "Лесота" },
            { "LT", "Літва" },
            { "LU", "Люксембург" },
            { "LV", "Латвія" },
            { "LY", "Лівія" },
            { "MA", "Марока" },
            { "MC", "Манака" },
            { "MD", "Малдова" },
            { "ME", "Чарнагорыя" },
            { "MF", "Сен-Мартэн" },
            { "MG", "Мадагаскар" },
            { "MH", "Маршалавы астравы" },
            { "MK", "Паўночная Македонія" },
            { "ML", "Малі" },
            { "MM", "М’янма (Бірма)" },
            { "MN", "Манголія" },
            { "MO", "Макаа, САР (Кітай)" },
            { "MP", "Паўночныя Марыянскія астравы" },
            { "MQ", "Марцініка" },
            { "MR", "Маўрытанія" },
            { "MS", "Мантсерат" },
            { "MT", "Мальта" },
            { "MU", "Маўрыкій" },
            { "MV", "Мальдывы" },
            { "MW", "Малаві" },
            { "MX", "Мексіка" },
            { "MY", "Малайзія" },
            { "MZ", "Мазамбік" },
            { "NA", "Намібія" },
            { "NC", "Новая Каледонія" },
            { "NE", "Нігер" },
            { "NF", "Востраў Норфалк" },
            { "NG", "Нігерыя" },
            { "NI", "Нікарагуа" },
            { "NL", "Нідэрланды" },
            { "NO", "Нарвегія" },
            { "NP", "Непал" },
            { "NR", "Науру" },
            { "NU", "Ніуэ" },
            { "NZ", "Новая Зеландыя" },
            { "OM", "Аман" },
            { "PA", "Панама" },
            { "PE", "Перу" },
            { "PF", "Французская Палінезія" },
            { "PG", "Папуа-Новая Гвінея" },
            { "PH", "Філіпіны" },
            { "PK", "Пакістан" },
            { "PL", "Польшча" },
            { "PM", "Сен-П’ер і Мікелон" },
            { "PN", "Астравы Піткэрн" },
            { "PR", "Пуэрта-Рыка" },
            { "PS", "Палесцінскія Тэрыторыі" },
            { "PT", "Партугалія" },
            { "PW", "Палау" },
            { "PY", "Парагвай" },
            { "QA", "Катар" },
            { "QO", "Аддаленыя тэрыторыі Акіяніі" },
            { "RE", "Рэюньён" },
            { "RO", "Румынія" },
            { "RS", "Сербія" },
            { "RU", "Расія" },
            { "RW", "Руанда" },
            { "SA", "Саудаўская Аравія" },
            { "SB", "Саламонавы астравы" },
            { "SC", "Сейшэльскія астравы" },
            { "SD", "Судан" },
            { "SE", "Швецыя" },
            { "SG", "Сінгапур" },
            { "SH", "Востраў Святой Алены" },
            { "SI", "Славенія" },
            { "SJ", "Шпіцберген і Ян-Маен" },
            { "SK", "Славакія" },
            { "SL", "Сьера-Леонэ" },
            { "SM", "Сан-Марына" },
            { "SN", "Сенегал" },
            { "SO", "Самалі" },
            { "SR", "Сурынам" },
            { "SS", "Паўднёвы Судан" },
            { "ST", "Сан-Тамэ і Прынсіпі" },
            { "SV", "Сальвадор" },
            { "SX", "Сінт-Мартэн" },
            { "SY", "Сірыя" },
            { "SZ", "Эсватыні" },
            { "TA", "Трыстан-да-Кунья" },
            { "TC", "Астравы Цёркс і Кайкас" },
            { "TD", "Чад" },
            { "TF", "Французскія паўднёвыя тэрыторыі" },
            { "TG", "Тога" },
            { "TH", "Тайланд" },
            { "TJ", "Таджыкістан" },
            { "TK", "Такелау" },
            { "TL", "Тымор-Лешці" },
            { "TM", "Туркменістан" },
            { "TN", "Туніс" },
            { "TO", "Тонга" },
            { "TR", "Турцыя" },
            { "TT", "Трынідад і Табага" },
            { "TV", "Тувалу" },
            { "TW", "Тайвань" },
            { "TZ", "Танзанія" },
            { "UA", "Украіна" },
            { "UG", "Уганда" },
            { "UM", "Малыя Аддаленыя астравы ЗША" },
            { "UN", "Арганізацыя Аб’яднаных Нацый" },
            { "US", "Злучаныя Штаты Амерыкі" },
            { "UY", "Уругвай" },
            { "UZ", "Узбекістан" },
            { "VA", "Ватыкан" },
            { "VC", "Сент-Вінсент і Грэнадзіны" },
            { "VE", "Венесуэла" },
            { "VG", "Брытанскія Віргінскія астравы" },
            { "VI", "Амерыканскія Віргінскія астравы" },
            { "VN", "В’етнам" },
            { "VU", "Вануату" },
            { "WF", "Уоліс і Футуна" },
            { "WS", "Самоа" },
            { "XA", "Псеўдаакцэнты" },
            { "XB", "Псеўдадвухнапрамкавы" },
            { "XK", "Косава" },
            { "YE", "Емен" },
            { "YT", "Маёта" },
            { "ZA", "Паўднёва-Афрыканская Рэспубліка" },
            { "ZM", "Замбія" },
            { "ZW", "Зімбабвэ" },
            { "ZZ", "Невядомы рэгіён" },
            { "aa", "афарская" },
            { "ab", "абхазская" },
            { "af", "афрыкаанс" },
            { "ak", "акан" },
            { "am", "амхарская" },
            { "an", "арагонская" },
            { "ar", "арабская" },
            { "as", "асамская" },
            { "av", "аварская" },
            { "ay", "аймара" },
            { "az", "азербайджанская" },
            { "ba", "башкірская" },
            { "be", "беларуская" },
            { "bg", "балгарская" },
            { "bi", "біслама" },
            { "bm", "бамбара" },
            { "bn", "бенгальская" },
            { "bo", "тыбецкая" },
            { "br", "брэтонская" },
            { "bs", "баснійская" },
            { "ca", "каталанская" },
            { "ce", "чачэнская" },
            { "ch", "чамора" },
            { "co", "карсіканская" },
            { "cs", "чэшская" },
            { "cu", "царкоўнаславянская" },
            { "cv", "чувашская" },
            { "cy", "валійская" },
            { "da", "дацкая" },
            { "de", "нямецкая" },
            { "dv", "мальдыўская" },
            { "dz", "дзонг-кэ" },
            { "ee", "эве" },
            { "el", "грэчаская" },
            { "en", "англійская" },
            { "eo", "эсперанта" },
            { "es", "іспанская" },
            { "et", "эстонская" },
            { "eu", "баскская" },
            { "fa", "фарсі" },
            { "ff", "фула" },
            { "fi", "фінская" },
            { "fj", "фіджыйская" },
            { "fo", "фарэрская" },
            { "fr", "французская" },
            { "fy", "заходняя фрызская" },
            { "ga", "ірландская" },
            { "gd", "шатландская гэльская" },
            { "gl", "галісійская" },
            { "gn", "гуарані" },
            { "gu", metaValue_gu },
            { "gv", "мэнская" },
            { "ha", "хауса" },
            { "he", "іўрыт" },
            { "hi", "хіндзі" },
            { "hr", "харвацкая" },
            { "ht", "гаіцянская крэольская" },
            { "hu", "венгерская" },
            { "hy", "армянская" },
            { "hz", "герэра" },
            { "ia", "інтэрлінгва" },
            { "id", "інданезійская" },
            { "ie", "інтэрлінгвэ" },
            { "ig", "ігба" },
            { "ii", "сычуаньская йі" },
            { "io", "іда" },
            { "is", "ісландская" },
            { "it", "італьянская" },
            { "iu", "інуктытут" },
            { "ja", "японская" },
            { "jv", "яванская" },
            { "ka", "грузінская" },
            { "ki", "кікуйю" },
            { "kj", "куаньяма" },
            { "kk", "казахская" },
            { "kl", "грэнландская" },
            { "km", "кхмерская" },
            { "kn", metaValue_kn },
            { "ko", "карэйская" },
            { "kr", "кануры" },
            { "ks", "кашмірская" },
            { "ku", "курманджы" },
            { "kv", "комі" },
            { "kw", "корнская" },
            { "ky", "кіргізская" },
            { "la", "лацінская" },
            { "lb", "люксембургская" },
            { "lg", "ганда" },
            { "li", "лімбургская" },
            { "ln", "лінгала" },
            { "lo", "лаоская" },
            { "lt", "літоўская" },
            { "lu", "луба-катанга" },
            { "lv", "латышская" },
            { "mg", "малагасійская" },
            { "mh", "маршальская" },
            { "mi", "маары" },
            { "mk", "македонская" },
            { "ml", metaValue_ml },
            { "mn", "мангольская" },
            { "mr", "маратхі" },
            { "ms", "малайская" },
            { "mt", "мальтыйская" },
            { "my", "бірманская" },
            { "na", "науру" },
            { "nb", "нарвежская (букмол)" },
            { "nd", "паўночная ндэбеле" },
            { "ne", "непальская" },
            { "ng", "ндонга" },
            { "nl", "нідэрландская" },
            { "nn", "нарвежская (нюношк)" },
            { "no", "нарвежская" },
            { "nr", "паўднёвая ндэбеле" },
            { "nv", "наваха" },
            { "ny", "ньянджа" },
            { "oc", "аксітанская" },
            { "oj", "аджыбвэ" },
            { "om", "арома" },
            { "or", metaValue_or },
            { "os", "асецінская" },
            { "pa", "панджабі" },
            { "pl", "польская" },
            { "ps", "пушту" },
            { "pt", "партугальская" },
            { "qu", "кечуа" },
            { "rm", "рэтараманская" },
            { "rn", "рундзі" },
            { "ro", "румынская" },
            { "ru", "руская" },
            { "rw", "руанда" },
            { "sa", "санскрыт" },
            { "sc", "сардзінская" },
            { "sd", "сіндхі" },
            { "se", "паўночнасаамская" },
            { "sg", "санга" },
            { "sh", "сербскахарвацкая" },
            { "si", "сінгальская" },
            { "sk", "славацкая" },
            { "sl", "славенская" },
            { "sm", "самоа" },
            { "sn", "шона" },
            { "so", "самалі" },
            { "sq", "албанская" },
            { "sr", "сербская" },
            { "ss", "суаці" },
            { "st", "сесута" },
            { "su", "сунда" },
            { "sv", "шведская" },
            { "sw", "суахілі" },
            { "ta", "тамільская" },
            { "te", metaValue_te },
            { "tg", "таджыкская" },
            { "th", "тайская" },
            { "ti", "тыгрынья" },
            { "tk", "туркменская" },
            { "tn", "тсвана" },
            { "to", "танганская" },
            { "tr", "турэцкая" },
            { "ts", "тсонга" },
            { "tt", "татарская" },
            { "ty", "таіці" },
            { "ug", "уйгурская" },
            { "uk", "украінская" },
            { "ur", "урду" },
            { "uz", "узбекская" },
            { "ve", "венда" },
            { "vi", "в’етнамская" },
            { "vo", "валапюк" },
            { "wa", "валонская" },
            { "wo", "валоф" },
            { "xh", "коса" },
            { "yi", "ідыш" },
            { "yo", "ёруба" },
            { "za", "чжуанская" },
            { "zh", "кітайская" },
            { "zu", "зулу" },
            { "ace", "ачэх" },
            { "ada", "адангмэ" },
            { "ady", "адыгейская" },
            { "agq", "агем" },
            { "ain", "айнская" },
            { "akk", "акадская" },
            { "ale", "алеуцкая" },
            { "alt", "паўднёваалтайская" },
            { "ang", "стараанглійская" },
            { "ann", "абола" },
            { "anp", "ангіка" },
            { "arc", "арамейская" },
            { "arn", "мапудунгун" },
            { "arp", "арапаха" },
            { "ars", "недждыйская арабская" },
            { "asa", "асу" },
            { "ast", "астурыйская" },
            { "atj", "атыкамек" },
            { "awa", "авадхі" },
            { "bal", "белуджская" },
            { "ban", "балійская" },
            { "bas", "басаа" },
            { "bem", "бемба" },
            { "bez", "бена" },
            { "bgc", "харыанві" },
            { "bgn", "заходняя белуджская" },
            { "bho", "бхаджпуры" },
            { "bin", "эда" },
            { "bla", "блэкфут" },
            { "blo", "аніі" },
            { "brx", "бода" },
            { "bua", "бурацкая" },
            { "bug", "бугіс" },
            { "byn", "білен" },
            { "cay", "каюга" },
            { "ccp", metaValue_ccp },
            { "ceb", "себуана" },
            { "cgg", "чыга" },
            { "chb", "чыбча" },
            { "chk", "чуук" },
            { "chm", "мары" },
            { "cho", "чокта" },
            { "chp", "чыпеваян" },
            { "chr", metaValue_chr },
            { "chy", "шэйен" },
            { "ckb", "цэнтральнакурдская" },
            { "clc", "чылькатын" },
            { "cop", "копцкая" },
            { "crg", "мічыф" },
            { "crj", "паўднёва-ўсходняя кры" },
            { "crk", "раўнінны кры" },
            { "crl", "паўночна-ўсходняя кры" },
            { "crm", "муская кры" },
            { "crr", "каралінская алганкійская" },
            { "crs", "сэсэльва" },
            { "csw", "балотная кры" },
            { "dak", "дакота" },
            { "dar", "даргінская" },
            { "dav", "таіта" },
            { "dgr", "догрыб" },
            { "dje", "зарма" },
            { "doi", "догры" },
            { "dsb", "ніжнялужыцкая" },
            { "dua", "дуала" },
            { "dyo", "джола-фоньі" },
            { "dzg", "дазага" },
            { "ebu", "эмбу" },
            { "efi", "эфік" },
            { "egy", "старажытнаегіпецкая" },
            { "eka", "экаджук" },
            { "ewo", "эвонда" },
            { "fil", "філіпінская" },
            { "fon", "фон" },
            { "frc", "каджунская французская" },
            { "fro", "старафранцузская" },
            { "frr", "паўночнафрызская" },
            { "fur", "фрыульская" },
            { "gaa", "га" },
            { "gag", "гагаузская" },
            { "gez", "геэз" },
            { "gil", "кірыбаці" },
            { "gor", "гарантала" },
            { "grc", "старажытнагрэчаская" },
            { "gsw", "швейцарская нямецкая" },
            { "guz", "гусіі" },
            { "gwi", "гуіч’ін" },
            { "hai", "хайда" },
            { "haw", "гавайская" },
            { "hax", "паўднёвая хайда" },
            { "hil", "хілігайнон" },
            { "hmn", "хмонг" },
            { "hsb", "верхнялужыцкая" },
            { "hup", "хупа" },
            { "hur", "халкамелем" },
            { "iba", "ібан" },
            { "ibb", "ібібія" },
            { "ikt", "заходнеканадская інуктытут" },
            { "ilo", "ілакана" },
            { "inh", "інгушская" },
            { "jbo", "ложбан" },
            { "jgo", "нгомба" },
            { "jmc", "мачамбэ" },
            { "kab", "кабільская" },
            { "kac", "качынская" },
            { "kaj", "дджу" },
            { "kam", "камба" },
            { "kbd", "кабардзінская" },
            { "kcg", "т’яп" },
            { "kde", "макондэ" },
            { "kea", "кабувердыяну" },
            { "kfo", "кора" },
            { "kgp", "каінганг" },
            { "kha", "кхасі" },
            { "khq", "койра чыіні" },
            { "kkj", "како" },
            { "kln", "календжын" },
            { "kmb", "кімбунду" },
            { "koi", "комі-пярмяцкая" },
            { "kok", "канкані" },
            { "kpe", "кпеле" },
            { "krc", "карачай-балкарская" },
            { "krl", "карэльская" },
            { "kru", "курух" },
            { "ksb", "шамбала" },
            { "ksf", "бафія" },
            { "ksh", "кёльнская" },
            { "kum", "кумыцкая" },
            { "kwk", "квакіутль" },
            { "kxv", "куві" },
            { "lad", "ладына" },
            { "lag", "лангі" },
            { "lez", "лезгінская" },
            { "lij", "лігурская" },
            { "lil", "лілуэт" },
            { "lkt", "лакота" },
            { "lmo", "ламбардская" },
            { "lol", "монга" },
            { "lou", "луізіянская крэольская" },
            { "loz", "лозі" },
            { "lrc", "паўночная луры" },
            { "lsm", "саамія" },
            { "lua", "луба-касаі" },
            { "lun", "лунда" },
            { "luo", "луо" },
            { "lus", "мізо" },
            { "luy", "луйя" },
            { "mad", "мадурская" },
            { "mag", "магахі" },
            { "mai", "майтхілі" },
            { "mak", "макасар" },
            { "man", "мандынг" },
            { "mas", "маасай" },
            { "mdf", "макшанская" },
            { "men", "мендэ" },
            { "mer", "меру" },
            { "mfe", "марысьен" },
            { "mgh", "макуўа-меета" },
            { "mgo", "мета" },
            { "mic", "мікмак" },
            { "min", "мінангкабау" },
            { "mni", "мейтэй" },
            { "moe", "іну-аймун" },
            { "moh", "мохак" },
            { "mos", "мосі" },
            { "mua", "мунданг" },
            { "mul", "некалькі моў" },
            { "mus", "мускогі" },
            { "mwl", "мірандыйская" },
            { "myv", "эрзянская" },
            { "mzn", "мазандэранская" },
            { "nap", "неапалітанская" },
            { "naq", "нама" },
            { "nds", "ніжненямецкая" },
            { "new", "неўары" },
            { "nia", "ніас" },
            { "niu", "ніўэ" },
            { "nmg", "нгумба" },
            { "nnh", "нг’ембон" },
            { "nog", "нагайская" },
            { "non", "старанарвежская" },
            { "nqo", metaValue_nqo },
            { "nso", "паўночная сота" },
            { "nus", "нуэр" },
            { "nyn", "ньянколе" },
            { "ojb", "паўночна-заходняя аджыбвэ" },
            { "ojc", "цэнтральная аджыбвэ" },
            { "ojs", "оджы-кры" },
            { "ojw", "заходняя аджыбвэ" },
            { "oka", "аканаган" },
            { "pag", "пангасінан" },
            { "pam", "пампанга" },
            { "pap", "пап’яменту" },
            { "pau", "палау" },
            { "pcm", "нігерыйскі піджын" },
            { "peo", "стараперсідская" },
            { "phn", "фінікійская" },
            { "pis", "саламонскі піджын" },
            { "pqm", "малесіт-пасамакуоды" },
            { "prg", "пруская" },
            { "pro", "стараправансальская" },
            { "quc", "кічэ" },
            { "raj", "раджастханская" },
            { "rap", "рапануі" },
            { "rar", "раратонг" },
            { "rhg", "рахінджа" },
            { "rof", "ромба" },
            { "rup", "арумунская" },
            { "rwk", "руа" },
            { "sad", "сандаўэ" },
            { "sah", "якуцкая" },
            { "saq", "самбуру" },
            { "sat", "санталі" },
            { "sba", "нгамбай" },
            { "sbp", "сангу" },
            { "scn", "сіцылійская" },
            { "sco", "шатландская" },
            { "sdh", "паўднёвакурдская" },
            { "seh", "сена" },
            { "ses", "кайрабора сэні" },
            { "sga", "стараірландская" },
            { "shi", "ташэльхіт" },
            { "shn", "шан" },
            { "slh", "паўднёвая лушуцыд" },
            { "sma", "паўднёвасаамская" },
            { "smj", "луле-саамская" },
            { "smn", "інары-саамская" },
            { "sms", "колта-саамская" },
            { "snk", "санінке" },
            { "srn", "сранан-тонга" },
            { "ssy", "саха" },
            { "str", "стрэйтс саліш" },
            { "suk", "сукума" },
            { "sux", "шумерская" },
            { "swb", "каморская" },
            { "syr", "сірыйская" },
            { "szl", "сілезская" },
            { "tce", "паўднёвая тутчонэ" },
            { "tem", "тэмнэ" },
            { "teo", "тэсо" },
            { "tet", "тэтум" },
            { "tgx", "тагіш" },
            { "tht", "тальтан" },
            { "tig", "тыгрэ" },
            { "tlh", "клінган" },
            { "tli", "тлінгіт" },
            { "tok", "такіпона" },
            { "tpi", "ток-пісін" },
            { "trv", "тарока" },
            { "ttm", "паўночная тутчонэ" },
            { "tum", "тумбука" },
            { "tvl", "тувалу" },
            { "twq", "тасаўак" },
            { "tyv", "тувінская" },
            { "tzm", "сярэднеатлаская тамазігхт" },
            { "udm", "удмурцкая" },
            { "umb", "умбунду" },
            { "und", "невядомая мова" },
            { "vai", "ваі" },
            { "vec", "венецыянская" },
            { "vmw", "макуа" },
            { "vun", "вунджо" },
            { "wae", "вальшская" },
            { "wal", "волайта" },
            { "war", "варай" },
            { "wbp", "варлпіры" },
            { "wuu", "ву" },
            { "xal", "калмыцкая" },
            { "xnr", "кангры" },
            { "xog", "сога" },
            { "yav", "янгбэн" },
            { "ybb", "йемба" },
            { "yrl", "ньенгату" },
            { "yue", "кантонскі дыялект кітайскай" },
            { "zap", "сапатэк" },
            { "zgh", "стандартная мараканская тамазіхт" },
            { "zun", "зуні" },
            { "zxx", "няма моўнага матэрыялу" },
            { "zza", "зазакі" },
            { "Adlm", "адлам" },
            { "Arab", "арабскае" },
            { "Aran", "насталік" },
            { "Armn", "армянскае" },
            { "Beng", "бенгальскае" },
            { "Bopo", "бапамофа" },
            { "Brai", "шрыфт Брайля" },
            { "Cakm", metaValue_ccp },
            { "Cans", "складавае пісьмо канадскіх абарыгенаў" },
            { "Cher", metaValue_chr },
            { "Cyrl", "кірыліца" },
            { "Deva", "дэванагары" },
            { "Ethi", "эфіопскае" },
            { "Geor", "грузінскае" },
            { "Grek", "грэчаскае" },
            { "Gujr", metaValue_gu },
            { "Guru", "гурмукхі" },
            { "Hanb", "хан з бапамофа" },
            { "Hang", "хангыль" },
            { "Hani", "хан" },
            { "Hans", "спрошчанае кітайскае" },
            { "Hant", "традыцыйнае кітайскае" },
            { "Hebr", "яўрэйскае" },
            { "Hira", "хірагана" },
            { "Hrkt", "японскія складовыя пісьмы" },
            { "Jamo", "чамо" },
            { "Jpan", "японскае" },
            { "Kana", "катакана" },
            { "Khmr", "кхмерскае" },
            { "Knda", metaValue_kn },
            { "Kore", "карэйскае" },
            { "Laoo", "лаоскае" },
            { "Latn", "лацініца" },
            { "Mlym", metaValue_ml },
            { "Mong", "старамангольскае" },
            { "Mtei", "маніпуры" },
            { "Mymr", "бірманскае" },
            { "Nkoo", metaValue_nqo },
            { "Olck", "ол-чыкі" },
            { "Orya", metaValue_or },
            { "Rohg", "ханіфі" },
            { "Sinh", "сінгальскае" },
            { "Sund", "сунданскае" },
            { "Syrc", "сірыйскае" },
            { "Taml", "тамільскае" },
            { "Telu", metaValue_te },
            { "Tfng", "тыфінаг" },
            { "Thaa", "тана" },
            { "Thai", "тайскае" },
            { "Tibt", "тыбецкае" },
            { "Vaii", "вайскае" },
            { "Yiii", "йі" },
            { "Zmth", "матэматычныя знакі" },
            { "Zsye", "эмодзі" },
            { "Zsym", "сімвалы" },
            { "Zxxx", "беспісьменная" },
            { "Zyyy", "агульнае" },
            { "Zzzz", "невядомае пісьмо" },
            { "de_AT", "аўстрыйская нямецкая" },
            { "de_CH", "швейцарская літаратурная нямецкая" },
            { "en_AU", "аўстралійская англійская" },
            { "en_CA", "канадская англійская" },
            { "en_GB", "брытанская англійская" },
            { "en_US", "амерыканская англійская" },
            { "es_ES", "еўрапейская іспанская" },
            { "es_MX", "мексіканская іспанская" },
            { "fa_AF", "дары" },
            { "fr_CA", "канадская французская" },
            { "fr_CH", "швейцарская французская" },
            { "nl_BE", "фламандская" },
            { "pt_BR", "бразільская партугальская" },
            { "pt_PT", "еўрапейская партугальская" },
            { "ro_MD", "малдаўская" },
            { "sw_CD", "кангалезская суахілі" },
            { "ar_001", "сучасная стандартная арабская" },
            { "es_419", "лацінаамерыканская іспанская" },
            { "key.ca", "каляндар" },
            { "key.cf", "фармат валюты" },
            { "key.co", "парадак сартавання" },
            { "key.cu", "валюта" },
            { "key.em", "прэзентацыя эмодзі" },
            { "key.hc", "гадзінны цыкл (12 або 24)" },
            { "key.lb", "правілы разрыву радка" },
            { "key.lw", "стыль пераносу слоў" },
            { "key.ms", "сістэма мер" },
            { "key.nu", "лічбы" },
            { "key.ss", "разрыў сказа пасля скарачэння" },
            { "nds_NL", "ніжнесаксонская" },
            { "zh_Hans", "кітайская (спрошчаныя іерогліфы)" },
            { "zh_Hant", "кітайская (традыцыйныя іерогліфы)" },
            { "type.ca.roc", "каляндар Міньго" },
            { "type.hc.h11", "12-гадзінны фармат часу (0-11)" },
            { "type.hc.h12", "12-гадзінны фармат часу (1-12)" },
            { "type.hc.h23", "24-гадзінны фармат часу (0-23)" },
            { "type.hc.h24", "24-гадзінны фармат часу (1-24)" },
            { "type.nu.arab", "арабска-індыйскія лічбы" },
            { "type.nu.armn", "армянскія лічбы" },
            { "type.nu.beng", "бенгальскія лічбы" },
            { "type.nu.cakm", "лічбы чакма" },
            { "type.nu.deva", "лічбы дэванагары" },
            { "type.nu.ethi", "эфіопскія лічбы" },
            { "type.nu.geor", "грузінскія лічбы" },
            { "type.nu.grek", "грэчаскія лічбы" },
            { "type.nu.gujr", "лічбы гуджараці" },
            { "type.nu.guru", "лічбы гурмукхі" },
            { "type.nu.hans", "кітайскія спрошчаныя лічбы" },
            { "type.nu.hant", "кітайскія традыцыйныя лічбы" },
            { "type.nu.hebr", "яўрэйскія лічбы" },
            { "type.nu.java", "яванскія лічбы" },
            { "type.nu.jpan", "японскія лічбы" },
            { "type.nu.khmr", "кхмерскія лічбы" },
            { "type.nu.knda", "лічбы канада" },
            { "type.nu.laoo", "лаоскія лічбы" },
            { "type.nu.latn", "сучасныя арабскія лічбы" },
            { "type.nu.mlym", "лічбы малаялам" },
            { "type.nu.mtei", "лічбы маніпуры" },
            { "type.nu.mymr", "бірманскія лічбы" },
            { "type.nu.olck", "лічбы ол-чыкі" },
            { "type.nu.orya", "лічбы орыя" },
            { "type.nu.taml", "тамільскія традыцыйныя лічбы" },
            { "type.nu.telu", "лічбы тэлугу" },
            { "type.nu.thai", "тайскія лічбы" },
            { "type.nu.tibt", "тыбецкія лічбы" },
            { "type.nu.vaii", "лічбы ваі" },
            { "type.ca.dangi", "каляндар дангі" },
            { "type.co.ducet", "стандартны парадак сартавання Унікод" },
            { "type.lb.loose", "нястрогія правілы разрыву радка" },
            { "type.nu.roman", "рымскія лічбы" },
            { "type.ca.coptic", "копцкі каляндар" },
            { "type.ca.hebrew", "яўрэйскі каляндар" },
            { "type.co.search", "універсальны пошук" },
            { "type.lb.normal", "звычайныя правілы разрыву радка" },
            { "type.lb.strict", "строгія правілы разрыву радка" },
            { "type.ms.metric", "метрычная сістэма мер" },
            { "type.ca.chinese", "кітайскі каляндар" },
            { "type.ca.islamic", "каляндар хіджры" },
            { "type.ca.iso8601", "каляндар ISO-8601" },
            { "type.ca.persian", "персідскі каляндар" },
            { "type.cf.account", "бухгалтарскі фармат валюты" },
            { "type.nu.arabext", "пашыраная сістэма арабска-індыйскіх лічбаў" },
            { "type.nu.armnlow", "армянскія лічбы ў ніжнім рэгістры" },
            { "type.nu.greklow", "грэчаскія лічбы ў ніжнім рэгістры" },
            { "type.nu.hanidec", "кітайскія дзесятковыя лічбы" },
            { "type.nu.hansfin", "кітайскія спрошчаныя лічбы (фінансы)" },
            { "type.nu.hantfin", "кітайскія традыцыйныя лічбы (фінансы)" },
            { "type.nu.jpanfin", "японскія лічбы (фінансы)" },
            { "type.nu.tamldec", "тамільскія лічбы" },
            { "type.ca.buddhist", "будыйскі каляндар" },
            { "type.ca.ethiopic", "эфіопскі каляндар" },
            { "type.ca.japanese", "японскі каляндар" },
            { "type.cf.standard", "стандартны фармат валюты" },
            { "type.co.standard", "стандартны парадак сартавання" },
            { "type.ms.uksystem", "брытанская сістэма мер" },
            { "type.ms.ussystem", "амерыканская сістэма мер" },
            { "type.nu.fullwide", "поўнашырынныя лічбы" },
            { "type.nu.romanlow", "рымскія лічбы ў ніжнім рэгістры" },
            { "type.ca.gregorian", "грыгарыянскі каляндар" },
            { "type.ca.islamic-civil", "свецкі каляндар хіджры (таблічны)" },
            { "type.ca.islamic-umalqura", "каляндар хіджры (Ум аль-Кура)" },
            { "type.ca.ethiopic-amete-alem", "эфіопскі каляндар Аметэ Алем" },
        };
        return data;
    }
}
