// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

type UDPAddr struct {
	Zone string
	IP   []byte
	Port int64
}

var (
	protoPoolUDPAddr = sync.Pool{
		New: func() any {
			return &UDPAddr{}
		},
	}
)

func NewUDPAddr() *UDPAddr {
	if !UseProtoPooling.IsEnabled() {
		return &UDPAddr{}
	}
	return protoPoolUDPAddr.Get().(*UDPAddr)
}

func DeleteUDPAddr(orig *UDPAddr, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	orig.Reset()
	if nullable {
		protoPoolUDPAddr.Put(orig)
	}
}

func CopyUDPAddr(dest, src *UDPAddr) *UDPAddr {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewUDPAddr()
	}
	dest.IP = src.IP
	dest.Port = src.Port
	dest.Zone = src.Zone

	return dest
}

func CopyUDPAddrSlice(dest, src []UDPAddr) []UDPAddr {
	var newDest []UDPAddr
	if cap(dest) < len(src) {
		newDest = make([]UDPAddr, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteUDPAddr(&dest[i], false)
		}
	}
	for i := range src {
		CopyUDPAddr(&newDest[i], &src[i])
	}
	return newDest
}

func CopyUDPAddrPtrSlice(dest, src []*UDPAddr) []*UDPAddr {
	var newDest []*UDPAddr
	if cap(dest) < len(src) {
		newDest = make([]*UDPAddr, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewUDPAddr()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteUDPAddr(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewUDPAddr()
		}
	}
	for i := range src {
		CopyUDPAddr(newDest[i], src[i])
	}
	return newDest
}

func (orig *UDPAddr) Reset() {
	*orig = UDPAddr{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *UDPAddr) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()

	if len(orig.IP) > 0 {
		dest.WriteObjectField("iP")
		dest.WriteBytes(orig.IP)
	}
	if orig.Port != int64(0) {
		dest.WriteObjectField("port")
		dest.WriteInt64(orig.Port)
	}
	if orig.Zone != "" {
		dest.WriteObjectField("zone")
		dest.WriteString(orig.Zone)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *UDPAddr) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "iP":
			orig.IP = iter.ReadBytes()
		case "port":
			orig.Port = iter.ReadInt64()
		case "zone":
			orig.Zone = iter.ReadString()
		default:
			iter.Skip()
		}
	}
}

func (orig *UDPAddr) SizeProto() int {
	var n int
	var l int
	_ = l

	l = len(orig.IP)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.Port != int64(0) {
		n += 1 + proto.Sov(uint64(orig.Port))
	}

	l = len(orig.Zone)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *UDPAddr) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = len(orig.IP)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.IP)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	if orig.Port != int64(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.Port))
		pos--
		buf[pos] = 0x10
	}
	l = len(orig.Zone)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.Zone)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	return len(buf) - pos
}

func (orig *UDPAddr) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field IP", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			if length != 0 {
				orig.IP = make([]byte, length)
				copy(orig.IP, buf[startPos:pos])
			}

		case 2:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.Port = int64(num)

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Zone", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Zone = string(buf[startPos:pos])
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestUDPAddr() *UDPAddr {
	orig := NewUDPAddr()
	orig.IP = []byte{1, 2, 3}
	orig.Port = int64(13)
	orig.Zone = "test_zone"
	return orig
}

func GenTestUDPAddrPtrSlice() []*UDPAddr {
	orig := make([]*UDPAddr, 5)
	orig[0] = NewUDPAddr()
	orig[1] = GenTestUDPAddr()
	orig[2] = NewUDPAddr()
	orig[3] = GenTestUDPAddr()
	orig[4] = NewUDPAddr()
	return orig
}

func GenTestUDPAddrSlice() []UDPAddr {
	orig := make([]UDPAddr, 5)
	orig[1] = *GenTestUDPAddr()
	orig[3] = *GenTestUDPAddr()
	return orig
}
