/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.Security;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;

public class DirectKeySignature {
    public static void main(String[] stringArray) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        if (stringArray.length == 1) {
            PGPPublicKeyRing pGPPublicKeyRing = new PGPPublicKeyRing(PGPUtil.getDecoderStream(new FileInputStream(stringArray[0])), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            PGPPublicKey pGPPublicKey = pGPPublicKeyRing.getPublicKey();
            Iterator<PGPSignature> iterator = pGPPublicKey.getSignaturesOfType(31);
            while (iterator.hasNext()) {
                PGPSignature pGPSignature = iterator.next();
                System.out.println("Signature date is: " + pGPSignature.getHashedSubPackets().getSignatureCreationTime());
                NotationData[] notationDataArray = pGPSignature.getHashedSubPackets().getNotationDataOccurrences();
                for (int i = 0; i < notationDataArray.length; ++i) {
                    System.out.println("Found Notation named '" + notationDataArray[i].getNotationName() + "' with content '" + notationDataArray[i].getNotationValue() + "'.");
                }
            }
        } else if (stringArray.length == 5) {
            PGPPublicKeyRing pGPPublicKeyRing;
            PGPSecretKeyRing pGPSecretKeyRing = new PGPSecretKeyRing(PGPUtil.getDecoderStream(new FileInputStream(stringArray[0])), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            String string2 = stringArray[1];
            PGPPublicKeyRing pGPPublicKeyRing2 = new PGPPublicKeyRing(PGPUtil.getDecoderStream(new FileInputStream(stringArray[2])), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            String string3 = stringArray[3];
            String string4 = stringArray[4];
            pGPPublicKeyRing2 = pGPPublicKeyRing = new PGPPublicKeyRing(new ByteArrayInputStream(DirectKeySignature.signPublicKey(pGPSecretKeyRing.getSecretKey(), string2, pGPPublicKeyRing2.getPublicKey(), string3, string4)), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            ArmoredOutputStream armoredOutputStream = new ArmoredOutputStream(new FileOutputStream("SignedKey.asc"));
            pGPPublicKeyRing.encode(armoredOutputStream);
            armoredOutputStream.flush();
            armoredOutputStream.close();
        } else {
            System.err.println("usage: DirectKeySignature secretKeyFile secretKeyPass publicKeyFile(key to be signed) NotationName NotationValue");
            System.err.println("or: DirectKeySignature signedPublicKeyFile");
        }
    }

    private static byte[] signPublicKey(PGPSecretKey pGPSecretKey, String string2, PGPPublicKey pGPPublicKey, String string3, String string4) throws Exception {
        PGPPrivateKey pGPPrivateKey = pGPSecretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build(string2.toCharArray()));
        PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(pGPSecretKey.getPublicKey().getAlgorithm(), 2).setProvider("BC"));
        pGPSignatureGenerator.init(31, pGPPrivateKey);
        PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
        boolean bl = true;
        pGPSignatureSubpacketGenerator.addNotationData(true, bl, string3, string4);
        PGPSignatureSubpacketVector pGPSignatureSubpacketVector = pGPSignatureSubpacketGenerator.generate();
        pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketVector);
        return PGPPublicKey.addCertification(pGPPublicKey, pGPSignatureGenerator.generate()).getEncoded();
    }
}

