/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;
import org.pgpainless.key.generation.type.rsa.RsaLength;
import org.pgpainless.key.generation.type.xdh.XDHSpec;
import org.pgpainless.util.Passphrase;

public final class KeyRingTemplates {
    public PGPSecretKeyRing rsaKeyRing(@Nullable CharSequence userId, @Nonnull RsaLength length) throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        return this.rsaKeyRing(userId, length, Passphrase.emptyPassphrase());
    }

    public PGPSecretKeyRing rsaKeyRing(@Nullable CharSequence userId, @Nonnull RsaLength length, @Nonnull String password) throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        Passphrase passphrase = Passphrase.emptyPassphrase();
        if (!KeyRingTemplates.isNullOrEmpty(password)) {
            passphrase = Passphrase.fromPassword(password);
        }
        return this.rsaKeyRing(userId, length, passphrase);
    }

    public PGPSecretKeyRing rsaKeyRing(@Nullable CharSequence userId, @Nonnull RsaLength length, @Nonnull Passphrase passphrase) throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        KeyRingBuilder builder = (KeyRingBuilder)((KeyRingBuilder)((KeyRingBuilder)PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder(KeyType.RSA(length), KeyFlag.CERTIFY_OTHER, new KeyFlag[0]))).addSubkey(KeySpec.getBuilder(KeyType.RSA(length), KeyFlag.SIGN_DATA, new KeyFlag[0]))).addSubkey(KeySpec.getBuilder(KeyType.RSA(length), KeyFlag.ENCRYPT_COMMS, KeyFlag.ENCRYPT_STORAGE));
        if (userId != null) {
            builder.addUserId(userId.toString());
        }
        if (!passphrase.isEmpty()) {
            builder.setPassphrase(passphrase);
        }
        return builder.build();
    }

    public PGPSecretKeyRing simpleRsaKeyRing(@Nullable CharSequence userId, @Nonnull RsaLength length) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        return this.simpleRsaKeyRing(userId, length, Passphrase.emptyPassphrase());
    }

    public PGPSecretKeyRing simpleRsaKeyRing(@Nullable CharSequence userId, @Nonnull RsaLength length, @Nonnull Passphrase passphrase) throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        KeyRingBuilder builder = ((KeyRingBuilder)PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder(KeyType.RSA(length), KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA, KeyFlag.ENCRYPT_COMMS))).setPassphrase(passphrase);
        if (userId != null) {
            builder.addUserId(userId.toString());
        }
        return builder.build();
    }

    public PGPSecretKeyRing simpleRsaKeyRing(@Nullable CharSequence userId, @Nonnull RsaLength length, @Nullable String password) throws PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        Passphrase passphrase = Passphrase.emptyPassphrase();
        if (!KeyRingTemplates.isNullOrEmpty(password)) {
            passphrase = Passphrase.fromPassword(password);
        }
        return this.simpleRsaKeyRing(userId, length, passphrase);
    }

    public PGPSecretKeyRing simpleEcKeyRing(@Nullable CharSequence userId) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        return this.simpleEcKeyRing(userId, Passphrase.emptyPassphrase());
    }

    public PGPSecretKeyRing simpleEcKeyRing(@Nullable CharSequence userId, String password) throws PGPException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        Passphrase passphrase = Passphrase.emptyPassphrase();
        if (!KeyRingTemplates.isNullOrEmpty(password)) {
            passphrase = Passphrase.fromPassword(password);
        }
        return this.simpleEcKeyRing(userId, passphrase);
    }

    public PGPSecretKeyRing simpleEcKeyRing(@Nullable CharSequence userId, @Nonnull Passphrase passphrase) throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        KeyRingBuilder builder = ((KeyRingBuilder)((KeyRingBuilder)PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder(KeyType.EDDSA(EdDSACurve._Ed25519), KeyFlag.CERTIFY_OTHER, KeyFlag.SIGN_DATA))).addSubkey(KeySpec.getBuilder(KeyType.XDH(XDHSpec._X25519), KeyFlag.ENCRYPT_STORAGE, KeyFlag.ENCRYPT_COMMS))).setPassphrase(passphrase);
        if (userId != null) {
            builder.addUserId(userId.toString());
        }
        return builder.build();
    }

    public PGPSecretKeyRing modernKeyRing(@Nullable CharSequence userId) throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        return this.modernKeyRing(userId, Passphrase.emptyPassphrase());
    }

    public PGPSecretKeyRing modernKeyRing(@Nullable CharSequence userId, @Nullable String password) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, PGPException {
        Passphrase passphrase = password != null ? Passphrase.fromPassword(password) : Passphrase.emptyPassphrase();
        return this.modernKeyRing(userId, passphrase);
    }

    public PGPSecretKeyRing modernKeyRing(@Nullable CharSequence userId, @Nonnull Passphrase passphrase) throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        KeyRingBuilder builder = ((KeyRingBuilder)((KeyRingBuilder)((KeyRingBuilder)PGPainless.buildKeyRing().setPrimaryKey(KeySpec.getBuilder(KeyType.EDDSA(EdDSACurve._Ed25519), KeyFlag.CERTIFY_OTHER, new KeyFlag[0]))).addSubkey(KeySpec.getBuilder(KeyType.XDH(XDHSpec._X25519), KeyFlag.ENCRYPT_STORAGE, KeyFlag.ENCRYPT_COMMS))).addSubkey(KeySpec.getBuilder(KeyType.EDDSA(EdDSACurve._Ed25519), KeyFlag.SIGN_DATA, new KeyFlag[0]))).setPassphrase(passphrase);
        if (userId != null) {
            builder.addUserId(userId.toString());
        }
        return builder.build();
    }

    private static boolean isNullOrEmpty(String password) {
        return password == null || password.trim().isEmpty();
    }
}

