export const functionArgNames: Record<string, string[]> = {
  // abs: ['value'],
  // absent: [],
  // absent_over_time: [],
  // avg_over_time: [],
  // ceil: [],
  // changes: [],
  clamp: ['input series', 'min', 'max'],
  // clamp_max: [],
  // clamp_min: [],
  // count_over_time: [],
  day_of_month: ['timestamp (default = vector(time()))'],
  day_of_week: ['timestamp (default = vector(time()))'],
  days_in_month: ['timestamp (default = vector(time()))'],
  // delta: [],
  // deriv: [],
  // exp: [],
  // floor: [],
  histogram_quantile: ['target quantile', 'histogram'],
  double_exponential_smoothing: ['input series', 'smoothing factor', 'trend factor'],
  hour: ['timestamp (default = vector(time()))'],
  // idelta: [],
  // increase: [],
  // irate: [],
  label_join: ['series', 'destination label', 'separator', 'source label'],
  label_replace: ['input series', 'destination label', 'replacement', 'source label', 'regex'],
  // ln: [],
  // log10: [],
  // log2: [],
  // max_over_time: [],
  // min_over_time: [],
  minute: ['timestamp (default = vector(time()))'],
  month: ['timestamp (default = vector(time()))'],
  predict_linear: ['input series', 'duration from now [s]'],
  quantile_over_time: ['target quantile', 'input series'],
  // rate: [],
  // resets: [],
  round: ['input series', 'to nearest (default = 1)'],
  // scalar: [],
  // sort: [],
  // sort_desc: [],
  // sqrt: [],
  // stddev_over_time: [],
  // stdvar_over_time: [],
  // sum_over_time: [],
  // time: [],
  // timestamp: [],
  // vector: [],
  year: ['timestamp (default = vector(time()))'],
};

export const functionDescriptions: Record<string, string> = {
  abs: 'return absolute values of input series',
  absent: 'determine whether input vector is empty',
  absent_over_time: 'determine whether input range vector is empty',
  avg_over_time: 'average series values over time',
  ceil: 'round up values of input series to nearest integer',
  changes: 'return number of value changes in input series over time',
  clamp: 'limit the value of input series to a certain range',
  clamp_max: 'limit the value of input series to a maximum',
  clamp_min: 'limit the value of input series to a minimum',
  count_over_time: 'count the number of values for each input series',
  day_of_month: 'return the day of the month for provided timestamps',
  day_of_week: 'return the day of the week for provided timestamps',
  days_in_month: 'return the number of days in current month for provided timestamps',
  delta: 'calculate the difference between beginning and end of a range vector (for gauges)',
  deriv: 'calculate the per-second derivative over series in a range vector (for gauges)',
  exp: 'calculate exponential function for input vector values',
  floor: 'round down values of input series to nearest integer',
  histogram_quantile: 'calculate quantiles from histogram buckets',
  double_exponential_smoothing: 'calculate smoothed value of input series',
  hour: 'return the hour of the day for provided timestamps',
  idelta: 'calculate the difference between the last two samples of a range vector (for counters)',
  increase: 'calculate the increase in value over a range of time (for counters)',
  irate: 'calculate the per-second increase over the last two samples of a range vector (for counters)',
  label_join: 'join together label values into new label',
  label_replace: 'set or replace label values',
  last_over_time: 'get the last sample value from a time range',
  ln: 'calculate natural logarithm of input series',
  log10: 'calulcate base-10 logarithm of input series',
  log2: 'calculate base-2 logarithm of input series',
  max_over_time: 'return the maximum value over time for input series',
  min_over_time: 'return the minimum value over time for input series',
  minute: 'return the minute of the hour for provided timestamps',
  month: 'return the month for provided timestamps',
  predict_linear: 'predict the value of a gauge into the future',
  quantile_over_time: 'calculate value quantiles over time for input series',
  rate: 'calculate per-second increase over a range vector (for counters)',
  resets: 'return number of value decreases (resets) in input series of time',
  round: 'round values of input series to nearest integer',
  scalar: 'convert single-element series vector into scalar value',
  sgn: 'return the sign of the input value (-1, 0, or 1)',
  sort: 'sort input series ascendingly by value',
  sort_desc: 'sort input series descendingly by value',
  sqrt: 'return the square root for input series',
  stddev_over_time: 'calculate the standard deviation within input series over time',
  stdvar_over_time: 'calculate the standard variation within input series over time',
  sum_over_time: 'calculate the sum over the values of input series over time',
  time: 'return the Unix timestamp at the current evaluation time',
  timestamp: 'return the Unix timestamp for the samples in the input vector',
  vector: 'convert a scalar value into a single-element series vector',
  year: 'return the year for provided timestamps',
};
