'use client';
import { useState } from 'react';
import { useId, useWindowEvent, useFocusReturn } from '@mantine/hooks';
import { useLockScroll } from './use-lock-scroll.mjs';

function useModal({
  id,
  transitionProps,
  opened,
  trapFocus,
  closeOnEscape,
  onClose,
  returnFocus
}) {
  const _id = useId(id);
  const [titleMounted, setTitleMounted] = useState(false);
  const [bodyMounted, setBodyMounted] = useState(false);
  const transitionDuration = typeof transitionProps?.duration === "number" ? transitionProps?.duration : 200;
  const shouldLockScroll = useLockScroll({ opened, transitionDuration });
  useWindowEvent(
    "keydown",
    (event) => {
      if (event.key === "Escape" && closeOnEscape && opened) {
        const shouldTrigger = event.target?.getAttribute("data-mantine-stop-propagation") !== "true";
        shouldTrigger && onClose();
      }
    },
    { capture: true }
  );
  useFocusReturn({ opened, shouldReturnFocus: trapFocus && returnFocus });
  return {
    _id,
    titleMounted,
    bodyMounted,
    shouldLockScroll,
    setTitleMounted,
    setBodyMounted
  };
}

export { useModal };
//# sourceMappingURL=use-modal.mjs.map
