'use client';
'use strict';

var getEndOfWeek = require('../get-end-of-week/get-end-of-week.cjs');
var getStartOfWeek = require('../get-start-of-week/get-start-of-week.cjs');

function getMonthDays({
  month,
  firstDayOfWeek = 1,
  consistentWeeks
}) {
  const currentMonth = month.getMonth();
  const startOfMonth = new Date(month.getFullYear(), currentMonth, 1);
  const endOfMonth = new Date(month.getFullYear(), month.getMonth() + 1, 0);
  const endDate = getEndOfWeek.getEndOfWeek(endOfMonth, firstDayOfWeek);
  const date = getStartOfWeek.getStartOfWeek(startOfMonth, firstDayOfWeek);
  const weeks = [];
  while (date <= endDate) {
    const days = [];
    for (let i = 0; i < 7; i += 1) {
      days.push(new Date(date));
      date.setDate(date.getDate() + 1);
    }
    weeks.push(days);
  }
  if (consistentWeeks && weeks.length < 6) {
    const lastWeek = weeks[weeks.length - 1];
    const lastDay = lastWeek[lastWeek.length - 1];
    const nextDay = new Date(lastDay);
    nextDay.setDate(nextDay.getDate() + 1);
    while (weeks.length < 6) {
      const days = [];
      for (let i = 0; i < 7; i += 1) {
        days.push(new Date(nextDay));
        nextDay.setDate(nextDay.getDate() + 1);
      }
      weeks.push(days);
    }
  }
  return weeks;
}

exports.getMonthDays = getMonthDays;
//# sourceMappingURL=get-month-days.cjs.map
