"use strict";

// Extracted from https://github.com/facebook/react/blob/a724a3b578dce77d427bef313102a4d0e978d9b4/packages/react-reconciler/src/ReactFiberTreeReflection.js

var HostRoot = 3;
var Placement = 2;
var Hydrating = 4096;
var NoFlags = 0;
function getNearestMountedFiber(fiber) {
  var node = fiber;
  var nearestMounted = fiber;
  if (!fiber.alternate) {
    // If there is no alternate, this might be a new tree that isn't inserted
    // yet. If it is, then it will have a pending insertion effect on it.
    var nextNode = node;
    do {
      node = nextNode;
      if ((node.flags & (Placement | Hydrating)) !== NoFlags) {
        // This is an insertion or in-progress hydration. The nearest possible
        // mounted fiber is the parent but we need to continue to figure out
        // if that one is still mounted.
        nearestMounted = node["return"];
      }
      nextNode = node["return"];
    } while (nextNode);
  } else {
    while (node["return"]) {
      node = node["return"];
    }
  }
  if (node.tag === HostRoot) {
    // TODO: Check if this was a nested HostRoot when used with
    // renderContainerIntoSubtree.
    return nearestMounted;
  }
  // If we didn't hit the root, that means that we're in an disconnected tree
  // that has been unmounted.
  return null;
}
function findCurrentFiberUsingSlowPath(fiber) {
  var _a$stateNode;
  var alternate = fiber.alternate;
  if (!alternate) {
    // If there is no alternate, then we only need to check if it is mounted.
    var nearestMounted = getNearestMountedFiber(fiber);
    if (nearestMounted === null) {
      throw new Error('Unable to find node on an unmounted component.');
    }
    if (nearestMounted !== fiber) {
      return null;
    }
    return fiber;
  }
  // If we have two possible branches, we'll walk backwards up to the root
  // to see what path the root points to. On the way we may hit one of the
  // special cases and we'll deal with them.
  var a = fiber;
  var b = alternate;
  // eslint-disable-next-line no-constant-condition
  while (true) {
    var parentA = a["return"];
    if (parentA === null) {
      // We're at the root.
      break;
    }
    var parentB = parentA.alternate;
    if (parentB === null) {
      // There is no alternate. This is an unusual case. Currently, it only
      // happens when a Suspense component is hidden. An extra fragment fiber
      // is inserted in between the Suspense fiber and its children. Skip
      // over this extra fragment fiber and proceed to the next parent.
      var nextParent = parentA["return"];
      if (nextParent !== null) {
        a = b = nextParent;
        continue;
      }
      // If there's no parent, we're at the root.
      break;
    }

    // If both copies of the parent fiber point to the same child, we can
    // assume that the child is current. This happens when we bailout on low
    // priority: the bailed out fiber's child reuses the current child.
    if (parentA.child === parentB.child) {
      var child = parentA.child;
      while (child) {
        if (child === a) {
          // We've determined that A is the current branch.
          return fiber;
        }
        if (child === b) {
          // We've determined that B is the current branch.
          return alternate;
        }
        child = child.sibling;
      }

      // We should never have an alternate for any mounting node. So the only
      // way this could possibly happen is if this was unmounted, if at all.
      throw new Error('Unable to find node on an unmounted component.');
    }
    if (a["return"] !== b["return"]) {
      // The return pointer of A and the return pointer of B point to different
      // fibers. We assume that return pointers never criss-cross, so A must
      // belong to the child set of A.return, and B must belong to the child
      // set of B.return.
      a = parentA;
      b = parentB;
    } else {
      // The return pointers point to the same fiber. We'll have to use the
      // default, slow path: scan the child sets of each parent alternate to see
      // which child belongs to which set.
      //
      // Search parent A's child set
      var didFindChild = false;
      var _child = parentA.child;
      while (_child) {
        if (_child === a) {
          didFindChild = true;
          a = parentA;
          b = parentB;
          break;
        }
        if (_child === b) {
          didFindChild = true;
          b = parentA;
          a = parentB;
          break;
        }
        _child = _child.sibling;
      }
      if (!didFindChild) {
        // Search parent B's child set
        _child = parentB.child;
        while (_child) {
          if (_child === a) {
            didFindChild = true;
            a = parentB;
            b = parentA;
            break;
          }
          if (_child === b) {
            didFindChild = true;
            b = parentB;
            a = parentA;
            break;
          }
          _child = _child.sibling;
        }
        if (!didFindChild) {
          throw new Error('Child was not found in either parent set. This indicates a bug ' + 'in React related to the return pointer. Please file an issue.');
        }
      }
    }
    if (a.alternate !== b) {
      throw new Error("Return fibers should always be each others' alternates. " + 'This error is likely caused by a bug in React. Please file an issue.');
    }
  }

  // If the root is not a host container, we're in a disconnected tree. I.e.
  // unmounted.
  if (a.tag !== HostRoot) {
    throw new Error('Unable to find node on an unmounted component.');
  }
  if (((_a$stateNode = a.stateNode) === null || _a$stateNode === void 0 ? void 0 : _a$stateNode.current) === a) {
    // We've determined that A is the current branch.
    return fiber;
  }
  // Otherwise B has to be current branch.
  return alternate;
}
module.exports = findCurrentFiberUsingSlowPath;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//# sourceMappingURL=findCurrentFiberUsingSlowPath.js.map