/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.reader.dtd;

import com.sun.msv.datatype.xsd.DatatypeFactory;
import com.sun.msv.datatype.xsd.EntityType;
import com.sun.msv.datatype.xsd.IDREFType;
import com.sun.msv.datatype.xsd.IDType;
import com.sun.msv.datatype.xsd.NmtokenType;
import com.sun.msv.datatype.xsd.NormalizedStringType;
import com.sun.msv.datatype.xsd.StringType;
import com.sun.msv.datatype.xsd.TypeIncubator;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.grammar.ChoiceNameClass;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.NameClass;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.SimpleNameClass;
import com.sun.msv.grammar.dtd.LocalNameClass;
import com.sun.msv.grammar.trex.ElementPattern;
import com.sun.msv.grammar.trex.TREXGrammar;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.msv.reader.dtd.Localizer;
import com.sun.msv.scanner.dtd.DTDEventListener;
import com.sun.msv.scanner.dtd.DTDParser;
import com.sun.msv.scanner.dtd.InputEntity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.relaxng.datatype.DatatypeException;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class DTDReader
implements DTDEventListener {
    protected final GrammarReaderController controller;
    protected static final Map dtdTypes = DTDReader.createDTDTypes();
    protected boolean hadError = false;
    protected final Map namespaces = DTDReader.createInitialNamespaceMap();
    protected static final String ABANDON_URI_SNIFFING = "*";
    protected final TREXGrammar grammar;
    protected Locator locator;
    protected final Map elementDecls = new HashMap();
    protected final Map attributeDecls = new HashMap();
    protected Context contextStack;
    protected Expression contentModel;
    protected short connectorType;
    protected final short CONNECTOR_UNKNOWN = (short)-999;
    private boolean reportedXmlnsWarning = false;
    private final Map declaredLocations = new HashMap();
    public static final String ERR_UNDEFINED_ELEMENT = "DTDReader.UndefinedElement";
    public static final String WRN_ATTEMPT_TO_USE_NAMESPACE = "DTDReader.Warning.AttemptToUseNamespace";
    public static final String ERR_UNDECLARED_PREFIX = "DTDReader.UndeclaredPrefix";

    public DTDReader(GrammarReaderController grammarReaderController, ExpressionPool expressionPool) {
        this.controller = grammarReaderController;
        this.grammar = new TREXGrammar(expressionPool);
    }

    public static TREXGrammar parse(InputSource inputSource, GrammarReaderController grammarReaderController) {
        return DTDReader.parse(inputSource, grammarReaderController, new ExpressionPool());
    }

    public static TREXGrammar parse(InputSource inputSource, GrammarReaderController grammarReaderController, ExpressionPool expressionPool) {
        try {
            DTDReader dTDReader = new DTDReader(grammarReaderController, expressionPool);
            DTDParser dTDParser = new DTDParser();
            dTDParser.setDtdHandler(dTDReader);
            dTDParser.setEntityResolver(grammarReaderController);
            dTDParser.parse(inputSource);
            return dTDReader.getResult();
        }
        catch (SAXParseException sAXParseException) {
            return null;
        }
        catch (Exception exception) {
            grammarReaderController.error(new Locator[0], exception.getMessage(), exception);
            return null;
        }
    }

    protected static Map createDTDTypes() {
        try {
            HashMap<String, XSDatatype> hashMap = new HashMap<String, XSDatatype>();
            hashMap.put("CDATA", NormalizedStringType.theInstance);
            hashMap.put("ID", IDType.theInstance);
            hashMap.put("IDREF", IDREFType.theInstance);
            hashMap.put("IDREFS", DatatypeFactory.getTypeByName("IDREFS"));
            hashMap.put("ENTITY", EntityType.theInstance);
            hashMap.put("ENTITIES", DatatypeFactory.getTypeByName("ENTITIES"));
            hashMap.put("NMTOKEN", NmtokenType.theInstance);
            hashMap.put("NMTOKENS", DatatypeFactory.getTypeByName("NMTOKENS"));
            hashMap.put("ENUMERATION", StringType.theInstance);
            hashMap.put("NOTATION", StringType.theInstance);
            return hashMap;
        }
        catch (DatatypeException datatypeException) {
            throw new Error();
        }
    }

    protected static final Map createInitialNamespaceMap() {
        HashMap hashMap = new HashMap();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("http://www.w3.org/XML/1998/namespace");
        hashMap.put("xml", hashSet);
        return hashMap;
    }

    protected NameClass getNameClass(String string, boolean bl) {
        String[] stringArray = this.splitQName(string);
        if (stringArray[0].length() == 0 && bl) {
            return new SimpleNameClass(stringArray[0], stringArray[1]);
        }
        Set set = (Set)this.namespaces.get(stringArray[0]);
        if (set == null) {
            if (stringArray[0].equals("")) {
                return new SimpleNameClass("", stringArray[1]);
            }
            this.hadError = true;
            this.controller.error(new Locator[]{this.locator}, Localizer.localize(ERR_UNDECLARED_PREFIX, stringArray[0]), null);
            return new LocalNameClass(stringArray[1]);
        }
        if (set.contains(ABANDON_URI_SNIFFING)) {
            return new LocalNameClass(stringArray[1]);
        }
        String[] stringArray2 = set.toArray(new String[set.size()]);
        NameClass nameClass = new SimpleNameClass(stringArray2[0], stringArray[1]);
        int n = 1;
        while (n < set.size()) {
            nameClass = new ChoiceNameClass(nameClass, new SimpleNameClass(stringArray2[n], stringArray[1]));
            ++n;
        }
        return nameClass;
    }

    protected String[] splitQName(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return new String[]{"", string};
        }
        return new String[]{string.substring(0, n), string.substring(n + 1)};
    }

    public TREXGrammar getResult() {
        if (this.hadError) {
            return null;
        }
        return this.grammar;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startContentModel(String string, short s) {
        if (this.contentModel != null) {
            throw new Error();
        }
        if (s == 2) {
            this.contentModel = Expression.nullSet;
        }
        if (s == 1) {
            this.contentModel = this.grammar.pool.createZeroOrMore(this.grammar.namedPatterns.getOrCreate("$  all  $"));
        }
        if (s == 0) {
            this.contentModel = Expression.epsilon;
        }
    }

    public void endContentModel(String string, short s) {
        if (this.contentModel == null) {
            throw new Error();
        }
        switch (s) {
            case 1: 
            case 3: {
                break;
            }
            case 0: {
                this.contentModel = Expression.epsilon;
                break;
            }
            case 2: {
                this.contentModel = this.contentModel != Expression.nullSet ? this.grammar.pool.createMixed(this.grammar.pool.createZeroOrMore(this.contentModel)) : Expression.anyString;
            }
        }
        this.setDeclaredLocationOf(this.grammar.namedPatterns.getOrCreate(string));
        this.elementDecls.put(string, this.contentModel);
        this.contentModel = null;
    }

    protected Expression processOccurs(Expression expression, short s) {
        switch (s) {
            case 3: {
                return expression;
            }
            case 1: {
                return this.grammar.pool.createOneOrMore(expression);
            }
            case 0: {
                return this.grammar.pool.createZeroOrMore(expression);
            }
            case 2: {
                return this.grammar.pool.createOptional(expression);
            }
        }
        throw new Error();
    }

    public void childElement(String string, short s) {
        Expression expression = this.processOccurs(this.grammar.namedPatterns.getOrCreate(string), s);
        if (this.connectorType == -999) {
            if (this.contentModel != null) {
                throw new Error();
            }
            this.contentModel = expression;
        } else {
            this.combineToContentModel(expression);
        }
    }

    protected void combineToContentModel(Expression expression) {
        switch (this.connectorType) {
            case 0: {
                this.contentModel = this.grammar.pool.createChoice(this.contentModel, expression);
                break;
            }
            case 1: {
                this.contentModel = this.grammar.pool.createSequence(this.contentModel, expression);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    public void mixedElement(String string) {
        if (this.contentModel == null) {
            throw new Error();
        }
        this.contentModel = this.grammar.pool.createChoice(this.contentModel, this.grammar.namedPatterns.getOrCreate(string));
    }

    public void startModelGroup() {
        this.contextStack = new Context(this.contextStack, this.contentModel, this.connectorType);
        this.contentModel = null;
        this.connectorType = (short)-999;
    }

    public void endModelGroup(short s) {
        Expression expression = this.processOccurs(this.contentModel, s);
        this.contentModel = this.contextStack.exp;
        this.connectorType = this.contextStack.connectorType;
        this.contextStack = this.contextStack.previous;
        if (this.contentModel == null) {
            this.contentModel = expression;
        } else {
            this.combineToContentModel(expression);
        }
    }

    public void connector(short s) throws SAXException {
        if (this.connectorType == -999) {
            this.connectorType = s;
        } else if (this.connectorType != s) {
            throw new Error();
        }
    }

    private Set getPossibleNamespaces(String string) {
        HashSet hashSet = (HashSet)this.namespaces.get(string);
        if (hashSet != null) {
            return hashSet;
        }
        hashSet = new HashSet();
        this.namespaces.put(string, hashSet);
        return hashSet;
    }

    public void attributeDecl(String string, String string2, String string3, String[] stringArray, short s, String string4) throws SAXException {
        if (string2.startsWith("xmlns")) {
            if (!this.reportedXmlnsWarning) {
                this.controller.warning(new Locator[]{this.locator}, Localizer.localize(WRN_ATTEMPT_TO_USE_NAMESPACE));
            }
            this.reportedXmlnsWarning = true;
            if (string4 == null) {
                string4 = ABANDON_URI_SNIFFING;
            }
            Set set = string2.equals("xmlns") ? this.getPossibleNamespaces("") : this.getPossibleNamespaces(string2.substring(6));
            set.add(string4);
            return;
        }
        HashMap<String, AttModel> hashMap = (HashMap<String, AttModel>)this.attributeDecls.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, AttModel>();
            this.attributeDecls.put(string, hashMap);
        }
        Expression expression = this.createAttributeBody(string, string2, string3, stringArray, s, string4);
        AttModel attModel = new AttModel(expression, s == 3);
        this.setDeclaredLocationOf(attModel);
        hashMap.put(string2, attModel);
    }

    protected Expression createAttributeBody(String string, String string2, String string3, String[] stringArray, short s, String string4) throws SAXException {
        XSDatatype xSDatatype = (XSDatatype)dtdTypes.get(string3);
        if (xSDatatype == null) {
            throw new InternalError(string3);
        }
        try {
            TypeIncubator typeIncubator;
            if (stringArray != null) {
                typeIncubator = new TypeIncubator(xSDatatype);
                int n = 0;
                while (n < stringArray.length) {
                    typeIncubator.addFacet("enumeration", stringArray[n], false, null);
                    ++n;
                }
                xSDatatype = typeIncubator.derive(null);
            }
            if (s == 2) {
                typeIncubator = new TypeIncubator(xSDatatype);
                typeIncubator.addFacet("enumeration", string4, false, null);
                xSDatatype = typeIncubator.derive(null);
            }
        }
        catch (DatatypeException datatypeException) {
            throw new SAXParseException(datatypeException.getMessage(), this.locator, datatypeException);
        }
        return this.grammar.pool.createData(xSDatatype);
    }

    protected ReferenceExp createElementDeclaration(String string) {
        Object object;
        Map map = (Map)this.attributeDecls.get(string);
        Expression expression = Expression.epsilon;
        if (map != null) {
            object = map.keySet().iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                AttModel attModel = (AttModel)map.get(string2);
                Expression expression2 = this.grammar.pool.createAttribute(this.getNameClass(string2, true), attModel.value);
                if (!attModel.required) {
                    expression2 = this.grammar.pool.createOptional(expression2);
                }
                expression = this.grammar.pool.createSequence(expression, expression2);
            }
        }
        object = this.grammar.namedPatterns.getOrCreate(string);
        ((ReferenceExp)object).exp = new ElementPattern(this.getNameClass(string, false), this.grammar.pool.createSequence(expression, (Expression)this.elementDecls.get(string)));
        this.declaredLocations.put(((ReferenceExp)object).exp, this.getDeclaredLocationOf(object));
        return object;
    }

    protected Expression createElementDeclarations() {
        Expression expression = Expression.nullSet;
        Iterator iterator = this.elementDecls.keySet().iterator();
        while (iterator.hasNext()) {
            ReferenceExp referenceExp = this.createElementDeclaration((String)iterator.next());
            expression = this.grammar.pool.createChoice(expression, referenceExp);
        }
        return expression;
    }

    public void endDTD() throws SAXException {
        Expression expression;
        this.grammar.namedPatterns.getOrCreate((String)"$  all  $").exp = expression = this.createElementDeclarations();
        this.grammar.exp = expression;
        ReferenceExp[] referenceExpArray = this.grammar.namedPatterns.getAll();
        int n = 0;
        while (n < referenceExpArray.length) {
            if (referenceExpArray[n].exp == null) {
                this.hadError = true;
                this.controller.error(new Locator[]{this.locator}, Localizer.localize(ERR_UNDEFINED_ELEMENT, new Object[]{referenceExpArray[n].name}), null);
            }
            ++n;
        }
    }

    protected Locator[] getLocation(SAXParseException sAXParseException) {
        LocatorImpl locatorImpl = new LocatorImpl();
        locatorImpl.setColumnNumber(sAXParseException.getColumnNumber());
        locatorImpl.setLineNumber(sAXParseException.getLineNumber());
        locatorImpl.setSystemId(sAXParseException.getSystemId());
        locatorImpl.setPublicId(sAXParseException.getPublicId());
        return new Locator[]{locatorImpl};
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.hadError = true;
        this.controller.error(this.getLocation(sAXParseException), sAXParseException.getMessage(), null);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.hadError = true;
        this.controller.error(this.getLocation(sAXParseException), sAXParseException.getMessage(), null);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.controller.warning(this.getLocation(sAXParseException), sAXParseException.getMessage());
    }

    public void setDeclaredLocationOf(Object object) {
        this.declaredLocations.put(object, new LocatorImpl(this.locator));
    }

    public Locator getDeclaredLocationOf(Object object) {
        return (Locator)this.declaredLocations.get(object);
    }

    public boolean isUnparsedEntity(String string) {
        return true;
    }

    public String resolveNamespacePrefix(String string) {
        throw new Error();
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
    }

    public void externalGeneralEntityDecl(String string, String string2, String string3) throws SAXException {
    }

    public void internalGeneralEntityDecl(String string, String string2) throws SAXException {
    }

    public void externalParameterEntityDecl(String string, String string2, String string3) throws SAXException {
    }

    public void internalParameterEntityDecl(String string, String string2) throws SAXException {
    }

    public void startDTD(InputEntity inputEntity) throws SAXException {
    }

    public void comment(String string) throws SAXException {
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    protected class Context {
        final Expression exp;
        final short connectorType;
        final Context previous;

        Context(Context context, Expression expression, short s) {
            this.exp = expression;
            this.connectorType = s;
            this.previous = context;
        }
    }

    private static class AttModel {
        Expression value;
        boolean required;

        AttModel(Expression expression, boolean bl) {
            this.value = expression;
            this.required = bl;
        }
    }
}

