/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.dbeaver.ui.dialogs.BaseWizard;
import org.jkiss.dbeaver.ui.dialogs.IActiveWizard;
import org.jkiss.dbeaver.ui.preferences.WizardPrefPage;

public abstract class ActiveWizard
extends BaseWizard
implements IActiveWizard {
    private final List<WizardPrefPage> prefPages = new ArrayList<WizardPrefPage>();

    protected List<WizardPrefPage> getPrefPages() {
        return this.prefPages;
    }

    @Override
    public WizardPrefPage addPreferencePage(IPreferencePage prefPage, String title, String description) {
        WizardPrefPage wizardPage = this.createPreferencePage(prefPage, title, description);
        this.addPage((IWizardPage)wizardPage);
        return wizardPage;
    }

    protected WizardPrefPage createPreferencePage(IPreferencePage prefPage, String title, String description) {
        WizardPrefPage wizardPage = new WizardPrefPage(prefPage, title, description);
        this.prefPages.add(wizardPage);
        if (prefPage instanceof IWorkbenchPropertyPage) {
            IWorkbenchPropertyPage wpp = (IWorkbenchPropertyPage)prefPage;
            wpp.setElement(this.getActiveElement());
        }
        return wizardPage;
    }

    protected IAdaptable getActiveElement() {
        return null;
    }

    public boolean performCancel() {
        for (WizardPrefPage prefPage : this.prefPages) {
            prefPage.performCancel();
        }
        return true;
    }

    protected void savePrefPageSettings() {
        this.savePrefPageSettings(this.prefPages.toArray(new WizardPrefPage[0]));
    }

    private void savePrefPageSettings(WizardPrefPage[] pages) {
        for (WizardPrefPage prefPage : pages) {
            this.savePageSettings(prefPage);
            WizardPrefPage[] subPages = prefPage.getDialogPages(false, true);
            if (subPages == null) continue;
            this.savePrefPageSettings(subPages);
        }
    }

    private void savePageSettings(WizardPrefPage prefPage) {
        if (ActiveWizard.isPageActive((IDialogPage)prefPage)) {
            prefPage.performFinish();
        }
    }

    protected void createPreferencePages(IPreferenceNode[] preferenceNodes) {
        this.createPreferencePages(null, preferenceNodes);
    }

    private void createPreferencePages(WizardPrefPage parent, IPreferenceNode[] preferenceNodes) {
        Arrays.sort(preferenceNodes, Comparator.comparing(IPreferenceNode::getLabelText));
        for (IPreferenceNode node : preferenceNodes) {
            if (this.isNodeHasParent(node, preferenceNodes)) continue;
            node.createPage();
            IPreferencePage preferencePage = node.getPage();
            if (preferencePage == null) continue;
            preferencePage.setContainer((IPreferencePageContainer)this.getContainer());
            WizardPrefPage wizardPrefPage = parent == null ? this.addPreferencePage(preferencePage, preferencePage.getTitle(), preferencePage.getDescription()) : parent.addSubPage(preferencePage, preferencePage.getTitle(), preferencePage.getDescription());
            IPreferenceNode[] subNodes = node.getSubNodes();
            if (subNodes == null) continue;
            this.createPreferencePages(wizardPrefPage, subNodes);
        }
    }

    private boolean isNodeHasParent(IPreferenceNode node, IPreferenceNode[] allNodes) {
        for (IPreferenceNode n : allNodes) {
            for (IPreferenceNode subNode : n.getSubNodes()) {
                if (!node.getId().equals(subNode.getId())) continue;
                return true;
            }
        }
        return false;
    }
}

