// Package visualstudio implements the Azure ARM Visualstudio service API version 2014-04-01-preview.
//
// Use these APIs to manage Visual Studio Team Services resources through the Azure Resource Manager. All task
// operations conform to the HTTP/1.1 protocol specification and each operation returns an x-ms-request-id header that
// can be used to obtain information about the request. You must make sure that requests made to these resources are
// secure. For more information, see https://docs.microsoft.com/en-us/rest/api/index.
package visualstudio

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
)

const (
	// DefaultBaseURI is the default URI used for the service Visualstudio
	DefaultBaseURI = "https://management.azure.com"
)

// BaseClient is the base client for Visualstudio.
type BaseClient struct {
	autorest.Client
	BaseURI        string
	SubscriptionID string
}

// New creates an instance of the BaseClient client.
func New(subscriptionID string) BaseClient {
	return NewWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewWithBaseURI creates an instance of the BaseClient client using a custom endpoint.  Use this when interacting with
// an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return BaseClient{
		Client:         autorest.NewClientWithUserAgent(UserAgent()),
		BaseURI:        baseURI,
		SubscriptionID: subscriptionID,
	}
}
