package domain_intl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTaskInfoHistory invokes the domain_intl.QueryTaskInfoHistory API synchronously
// api document: https://help.aliyun.com/api/domain-intl/querytaskinfohistory.html
func (client *Client) QueryTaskInfoHistory(request *QueryTaskInfoHistoryRequest) (response *QueryTaskInfoHistoryResponse, err error) {
	response = CreateQueryTaskInfoHistoryResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTaskInfoHistoryWithChan invokes the domain_intl.QueryTaskInfoHistory API asynchronously
// api document: https://help.aliyun.com/api/domain-intl/querytaskinfohistory.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryTaskInfoHistoryWithChan(request *QueryTaskInfoHistoryRequest) (<-chan *QueryTaskInfoHistoryResponse, <-chan error) {
	responseChan := make(chan *QueryTaskInfoHistoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTaskInfoHistory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTaskInfoHistoryWithCallback invokes the domain_intl.QueryTaskInfoHistory API asynchronously
// api document: https://help.aliyun.com/api/domain-intl/querytaskinfohistory.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryTaskInfoHistoryWithCallback(request *QueryTaskInfoHistoryRequest, callback func(response *QueryTaskInfoHistoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTaskInfoHistoryResponse
		var err error
		defer close(result)
		response, err = client.QueryTaskInfoHistory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTaskInfoHistoryRequest is the request struct for api QueryTaskInfoHistory
type QueryTaskInfoHistoryRequest struct {
	*requests.RpcRequest
	BeginCreateTime  requests.Integer `position:"Query" name:"BeginCreateTime"`
	EndCreateTime    requests.Integer `position:"Query" name:"EndCreateTime"`
	TaskNoCursor     string           `position:"Query" name:"TaskNoCursor"`
	UserClientIp     string           `position:"Query" name:"UserClientIp"`
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
	Lang             string           `position:"Query" name:"Lang"`
	CreateTimeCursor requests.Integer `position:"Query" name:"CreateTimeCursor"`
}

// QueryTaskInfoHistoryResponse is the response struct for api QueryTaskInfoHistory
type QueryTaskInfoHistoryResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	PageSize          int               `json:"PageSize" xml:"PageSize"`
	CurrentPageCursor CurrentPageCursor `json:"CurrentPageCursor" xml:"CurrentPageCursor"`
	NextPageCursor    NextPageCursor    `json:"NextPageCursor" xml:"NextPageCursor"`
	PrePageCursor     PrePageCursor     `json:"PrePageCursor" xml:"PrePageCursor"`
	Objects           []TaskInfoHistory `json:"Objects" xml:"Objects"`
}

// CreateQueryTaskInfoHistoryRequest creates a request to invoke QueryTaskInfoHistory API
func CreateQueryTaskInfoHistoryRequest() (request *QueryTaskInfoHistoryRequest) {
	request = &QueryTaskInfoHistoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain-intl", "2017-12-18", "QueryTaskInfoHistory", "domain", "openAPI")
	return
}

// CreateQueryTaskInfoHistoryResponse creates a response to parse from QueryTaskInfoHistory response
func CreateQueryTaskInfoHistoryResponse() (response *QueryTaskInfoHistoryResponse) {
	response = &QueryTaskInfoHistoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
