package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryEdgeInstanceGateway invokes the iot.QueryEdgeInstanceGateway API synchronously
func (client *Client) QueryEdgeInstanceGateway(request *QueryEdgeInstanceGatewayRequest) (response *QueryEdgeInstanceGatewayResponse, err error) {
	response = CreateQueryEdgeInstanceGatewayResponse()
	err = client.DoAction(request, response)
	return
}

// QueryEdgeInstanceGatewayWithChan invokes the iot.QueryEdgeInstanceGateway API asynchronously
func (client *Client) QueryEdgeInstanceGatewayWithChan(request *QueryEdgeInstanceGatewayRequest) (<-chan *QueryEdgeInstanceGatewayResponse, <-chan error) {
	responseChan := make(chan *QueryEdgeInstanceGatewayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryEdgeInstanceGateway(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryEdgeInstanceGatewayWithCallback invokes the iot.QueryEdgeInstanceGateway API asynchronously
func (client *Client) QueryEdgeInstanceGatewayWithCallback(request *QueryEdgeInstanceGatewayRequest, callback func(response *QueryEdgeInstanceGatewayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryEdgeInstanceGatewayResponse
		var err error
		defer close(result)
		response, err = client.QueryEdgeInstanceGateway(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryEdgeInstanceGatewayRequest is the request struct for api QueryEdgeInstanceGateway
type QueryEdgeInstanceGatewayRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	InstanceId    string `position:"Query" name:"InstanceId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// QueryEdgeInstanceGatewayResponse is the response struct for api QueryEdgeInstanceGateway
type QueryEdgeInstanceGatewayResponse struct {
	*responses.BaseResponse
	RequestId    string    `json:"RequestId" xml:"RequestId"`
	Success      bool      `json:"Success" xml:"Success"`
	Code         string    `json:"Code" xml:"Code"`
	ErrorMessage string    `json:"ErrorMessage" xml:"ErrorMessage"`
	GatewayList  []Gateway `json:"GatewayList" xml:"GatewayList"`
}

// CreateQueryEdgeInstanceGatewayRequest creates a request to invoke QueryEdgeInstanceGateway API
func CreateQueryEdgeInstanceGatewayRequest() (request *QueryEdgeInstanceGatewayRequest) {
	request = &QueryEdgeInstanceGatewayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QueryEdgeInstanceGateway", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryEdgeInstanceGatewayResponse creates a response to parse from QueryEdgeInstanceGateway response
func CreateQueryEdgeInstanceGatewayResponse() (response *QueryEdgeInstanceGatewayResponse) {
	response = &QueryEdgeInstanceGatewayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
