//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_CLANG_TOOLS_EXTRA_CLANG_TIDY_OBJC_FORBIDDENSUBCLASSINGCHECK_H
#define LLVM_CLANG_TOOLS_EXTRA_CLANG_TIDY_OBJC_FORBIDDENSUBCLASSINGCHECK_H

#include "../ClangTidyCheck.h"
#include "llvm/ADT/StringRef.h"
#include <vector>

namespace clang::tidy::objc {

/// Finds Objective-C classes which have a superclass which is
/// documented to not support subclassing.
///
/// For the user-facing documentation see:
/// https://clang.llvm.org/extra/clang-tidy/checks/objc/forbidden-subclassing.html
class ForbiddenSubclassingCheck : public ClangTidyCheck {
public:
  ForbiddenSubclassingCheck(StringRef Name, ClangTidyContext *Context);
  bool isLanguageVersionSupported(const LangOptions &LangOpts) const override {
    return LangOpts.ObjC;
  }
  void registerMatchers(ast_matchers::MatchFinder *Finder) override;
  void check(const ast_matchers::MatchFinder::MatchResult &Result) override;
  void storeOptions(ClangTidyOptions::OptionMap &Opts) override;

private:
  const std::vector<StringRef> ForbiddenSuperClassNames;
};

} // namespace clang::tidy::objc

#endif // LLVM_CLANG_TOOLS_EXTRA_CLANG_TIDY_OBJC_FORBIDDENSUBCLASSINGCHECK_H
