// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 6
// RUN: %clang_cc1 -O2 -triple s390x-linux -emit-llvm -o - %s | FileCheck %s

// CHECK-LABEL: define dso_local signext range(i32 0, 4) i32 @test(
// CHECK-SAME: i32 noundef signext [[X:%.*]]) local_unnamed_addr #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = tail call { i32, i32 } asm "ahi $0,42\0A", "=d,={@cc},0"(i32 [[X]]) #[[ATTR2:[0-9]+]], !srcloc [[META2:![0-9]+]]
// CHECK-NEXT:    [[ASMRESULT1:%.*]] = extractvalue { i32, i32 } [[TMP0]], 1
// CHECK-NEXT:    [[TMP1:%.*]] = icmp ult i32 [[ASMRESULT1]], 4
// CHECK-NEXT:    tail call void @llvm.assume(i1 [[TMP1]])
// CHECK-NEXT:    ret i32 [[ASMRESULT1]]
//
int test(int x) {
  int cc;
  asm ("ahi %[x],42\n" : [x] "+d"(x), "=@cc" (cc));
  return cc;
}

// CHECK-LABEL: define dso_local signext range(i32 0, 2) i32 @test_low_high_transformation(
// CHECK-SAME: i32 noundef signext [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = tail call { i32, i32 } asm "ahi $0,42\0A", "=d,={@cc},0"(i32 [[X]]) #[[ATTR2]], !srcloc [[META3:![0-9]+]]
// CHECK-NEXT:    [[ASMRESULT1:%.*]] = extractvalue { i32, i32 } [[TMP0]], 1
// CHECK-NEXT:    [[TMP1:%.*]] = icmp ult i32 [[ASMRESULT1]], 4
// CHECK-NEXT:    tail call void @llvm.assume(i1 [[TMP1]])
// CHECK-NEXT:    [[TMP2:%.*]] = add nsw i32 [[ASMRESULT1]], -1
// CHECK-NEXT:    [[TMP3:%.*]] = icmp ult i32 [[TMP2]], 2
// CHECK-NEXT:    [[LOR_EXT:%.*]] = zext i1 [[TMP3]] to i32
// CHECK-NEXT:    ret i32 [[LOR_EXT]]
//
int test_low_high_transformation(int x) {
  int cc;
  asm ("ahi %[x],42\n" : [x] "+d"(x), "=@cc" (cc));
  return cc == 1 || cc == 2;
}

// CHECK-LABEL: define dso_local signext range(i32 0, 2) i32 @test_equal_high_transformation(
// CHECK-SAME: i32 noundef signext [[X:%.*]]) local_unnamed_addr #[[ATTR0]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[TMP0:%.*]] = tail call { i32, i32 } asm "ahi $0,42\0A", "=d,={@cc},0"(i32 [[X]]) #[[ATTR2]], !srcloc [[META4:![0-9]+]]
// CHECK-NEXT:    [[ASMRESULT1:%.*]] = extractvalue { i32, i32 } [[TMP0]], 1
// CHECK-NEXT:    [[TMP1:%.*]] = icmp ult i32 [[ASMRESULT1]], 4
// CHECK-NEXT:    tail call void @llvm.assume(i1 [[TMP1]])
// CHECK-NEXT:    [[TMP2:%.*]] = and i32 [[ASMRESULT1]], 1
// CHECK-NEXT:    [[LOR_EXT:%.*]] = xor i32 [[TMP2]], 1
// CHECK-NEXT:    ret i32 [[LOR_EXT]]
//
int test_equal_high_transformation(int x) {
  int cc;
  asm ("ahi %[x],42\n" : [x] "+d"(x), "=@cc" (cc));
  return cc == 0 || cc == 2;
}
//.
// CHECK: [[META2]] = !{i64 788}
// CHECK: [[META3]] = !{i64 1670}
// CHECK: [[META4]] = !{i64 2505}
//.
