//
// ********************************************************************
// * License and Disclaimer                                           *
// *                                                                  *
// * The  Geant4 software  is  copyright of the Copyright Holders  of *
// * the Geant4 Collaboration.  It is provided  under  the terms  and *
// * conditions of the Geant4 Software License,  included in the file *
// * LICENSE and available at  http://cern.ch/geant4/license .  These *
// * include a list of copyright holders.                             *
// *                                                                  *
// * Neither the authors of this software system, nor their employing *
// * institutes,nor the agencies providing financial support for this *
// * work  make  any representation or  warranty, express or implied, *
// * regarding  this  software system or assume any liability for its *
// * use.  Please see the license in the file  LICENSE  and URL above *
// * for the full disclaimer and the limitation of liability.         *
// *                                                                  *
// * This  code  implementation is the result of  the  scientific and *
// * technical work of the GEANT4 collaboration.                      *
// * By using,  copying,  modifying or  distributing the software (or *
// * any work based  on the software)  you  agree  to acknowledge its *
// * use  in  resulting  scientific  publications,  and indicate your *
// * acceptance of all terms of the Geant4 Software license.          *
// ********************************************************************
//
/// \file EventAction.cc
/// \brief Implementation of the EventAction class

#include "EventAction.hh"

#include "HistoManager.hh"
#include "Run.hh"

#include "G4Event.hh"
#include "G4RunManager.hh"
#include "G4VProcess.hh"

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

void EventAction::BeginOfEventAction(const G4Event*)
{
  // initialisation per event
  fEnergyDeposit = fTrakLenCharged = fTrakLenNeutral = 0.;
  fNbStepsCharged = fNbStepsNeutral = fTransmitFlag = fReflectFlag = 0;
  fTypes[0] = fTypes[1] = fTypes[2] = fTypes[3] = 0;
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

void EventAction::EndOfEventAction(const G4Event*)
{
  Run* run = static_cast<Run*>(G4RunManager::GetRunManager()->GetNonConstCurrentRun());

  run->AddEnergy(fEnergyDeposit);
  run->AddTrakLenCharg(fTrakLenCharged);
  run->AddTrakLenNeutr(fTrakLenNeutral);

  run->CountStepsCharg(fNbStepsCharged);
  run->CountStepsNeutr(fNbStepsNeutral);

  run->CountTransmit(fTransmitFlag);
  run->CountReflect(fReflectFlag);
  run->CountGammaProcesses(fTypes);

  if (fEnergyDeposit > 0.) G4AnalysisManager::Instance()->FillH1(1, fEnergyDeposit);
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......

void EventAction::CountStepsNeutr(const G4VProcess* ptr)
{
  ++fNbStepsNeutral;
  if (nullptr != ptr) {
    G4int type = ptr->GetProcessSubType();
    if (type == 11) {
      ++fTypes[3];
    }
    else if (type == 12) {
      ++fTypes[0];
    }
    else if (type == 13) {
      ++fTypes[1];
    }
    else if (type == 14) {
      ++fTypes[2];
    }
  }
}

//....oooOO0OOooo........oooOO0OOooo........oooOO0OOooo........oooOO0OOooo......
