// x11-rs: Rust bindings for X11 libraries
// The X11 libraries are available under the MIT license.
// These bindings are public domain.

x11_link! { Xrandr_2_2_0, xrandr, ["libXrandr.so.2.2.0", "libXrandr.so.2", "libXrandr.so"], 65,
    pub fn XRRAddOutputMode (dpy: *mut Display, output: RROutput, mode: RRMode) -> (),
    pub fn XRRAllocGamma (size: c_int) -> *mut XRRCrtcGamma,
    pub fn XRRAllocModeInfo (name: *const c_char, nameLength: c_int) -> *mut XRRModeInfo,
    pub fn XRRChangeOutputProperty (dpy: *mut Display, output: RROutput, property: Atom, type_: Atom, format: c_int, mode: c_int, data: *const c_uchar, nelements: c_int) -> (),
    pub fn XRRChangeProviderProperty (dpy: *mut Display, provider: RRProvider, property: Atom, type_: Atom, format: c_int, mode: c_int, data: *const c_uchar, nelements: c_int) -> (),
    pub fn XRRConfigCurrentConfiguration (config: *mut XRRScreenConfiguration, rotation: *mut Rotation) -> SizeID,
    pub fn XRRConfigCurrentRate (config: *mut XRRScreenConfiguration) -> c_short,
    pub fn XRRConfigRates (config: *mut XRRScreenConfiguration, sizeID: c_int, nrates: *mut c_int) -> *mut c_short,
    pub fn XRRConfigRotations (config: *mut XRRScreenConfiguration, current_rotation: *mut Rotation) -> Rotation,
    pub fn XRRConfigSizes (config: *mut XRRScreenConfiguration, nsizes: *mut c_int) -> *mut XRRScreenSize,
    pub fn XRRConfigTimes (config: *mut XRRScreenConfiguration, config_timestamp: *mut Time) -> Time,
    pub fn XRRConfigureOutputProperty (dpy: *mut Display, output: RROutput, property: Atom, pending: Bool, range: Bool, num_values: c_int, values: *mut c_long) -> (),
    pub fn XRRConfigureProviderProperty (dpy: *mut Display, provider: RRProvider, property: Atom, pending: Bool, range: Bool, num_values: c_int, values: *mut c_long) -> (),
    pub fn XRRCreateMode (dpy: *mut Display, window: Window, modeInfo: *mut XRRModeInfo) -> RRMode,
    pub fn XRRDeleteOutputMode (dpy: *mut Display, output: RROutput, mode: RRMode) -> (),
    pub fn XRRDeleteOutputProperty (dpy: *mut Display, output: RROutput, property: Atom) -> (),
    pub fn XRRDeleteProviderProperty (dpy: *mut Display, provider: RRProvider, property: Atom) -> (),
    pub fn XRRDestroyMode (dpy: *mut Display, mode: RRMode) -> (),
    pub fn XRRFreeCrtcInfo (crtcInfo: *mut XRRCrtcInfo) -> (),
    pub fn XRRFreeGamma (gamma: *mut XRRCrtcGamma) -> (),
    pub fn XRRFreeModeInfo (modeInfo: *mut XRRModeInfo) -> (),
    pub fn XRRFreeOutputInfo (outputInfo: *mut XRROutputInfo) -> (),
    pub fn XRRFreePanning (panning: *mut XRRPanning) -> (),
    pub fn XRRFreeProviderInfo (provider: *mut XRRProviderInfo) -> (),
    pub fn XRRFreeProviderResources (resources: *mut XRRProviderResources) -> (),
    pub fn XRRFreeScreenConfigInfo (config: *mut XRRScreenConfiguration) -> (),
    pub fn XRRFreeScreenResources (resources: *mut XRRScreenResources) -> (),
    pub fn XRRGetCrtcGamma (dpy: *mut Display, crtc: RRCrtc) -> *mut XRRCrtcGamma,
    pub fn XRRGetCrtcGammaSize (dpy: *mut Display, crtc: RRCrtc) -> c_int,
    pub fn XRRGetCrtcInfo (dpy: *mut Display, resources: *mut XRRScreenResources, crtc: RRCrtc) -> *mut XRRCrtcInfo,
    pub fn XRRGetCrtcTransform (dpy: *mut Display, crtc: RRCrtc, attributes: *mut *mut XRRCrtcTransformAttributes) -> Status,
    pub fn XRRGetOutputInfo (dpy: *mut Display, resources: *mut XRRScreenResources, output: RROutput) -> *mut XRROutputInfo,
    pub fn XRRGetOutputPrimary (dpy: *mut Display, window: Window) -> RROutput,
    pub fn XRRGetOutputProperty (dpy: *mut Display, output: RROutput, property: Atom, offset: c_long, length: c_long, _delete: Bool, pending: Bool, req_type: Atom, actual_type: *mut Atom, actual_format: *mut c_int, nitems: *mut c_ulong, bytes_after: *mut c_ulong, prop: *mut *mut c_uchar) -> c_int,
    pub fn XRRGetPanning (dpy: *mut Display, resources: *mut XRRScreenResources, crtc: RRCrtc) -> *mut XRRPanning,
    pub fn XRRGetProviderInfo (dpy: *mut Display, resources: *mut XRRScreenResources, provider: RRProvider) -> *mut XRRProviderInfo,
    pub fn XRRGetProviderProperty (dpy: *mut Display, provider: RRProvider, property: Atom, offset: c_long, length: c_long, _delete: Bool, pending: Bool, req_type: Atom, actual_type: *mut Atom, actual_format: *mut c_int, nitems: *mut c_ulong, bytes_after: *mut c_ulong, prop: *mut *mut c_uchar) -> c_int,
    pub fn XRRGetProviderResources (dpy: *mut Display, window: Window) -> *mut XRRProviderResources,
    pub fn XRRGetScreenInfo (dpy: *mut Display, window: Window) -> *mut XRRScreenConfiguration,
    pub fn XRRGetScreenResources (dpy: *mut Display, window: Window) -> *mut XRRScreenResources,
    pub fn XRRGetScreenResourcesCurrent (dpy: *mut Display, window: Window) -> *mut XRRScreenResources,
    pub fn XRRGetScreenSizeRange (dpy: *mut Display, window: Window, minWidth: *mut c_int, minHeight: *mut c_int, maxWidth: *mut c_int, maxHeight: *mut c_int) -> Status,
    pub fn XRRListOutputProperties (dpy: *mut Display, output: RROutput, nprop: *mut c_int) -> *mut Atom,
    pub fn XRRListProviderProperties (dpy: *mut Display, provider: RRProvider, nprop: *mut c_int) -> *mut Atom,
    pub fn XRRQueryExtension (dpy: *mut Display, event_base_return: *mut c_int, error_base_return: *mut c_int) -> Bool,
    pub fn XRRQueryOutputProperty (dpy: *mut Display, output: RROutput, property: Atom) -> *mut XRRPropertyInfo,
    pub fn XRRQueryProviderProperty (dpy: *mut Display, provider: RRProvider, property: Atom) -> *mut XRRPropertyInfo,
    pub fn XRRQueryVersion (dpy: *mut Display, major_version_return: *mut c_int, minor_version_return: *mut c_int) -> Status,
    pub fn XRRRates (dpy: *mut Display, screen: c_int, sizeID: c_int, nrates: *mut c_int) -> *mut c_short,
    pub fn XRRRootToScreen (dpy: *mut Display, root: Window) -> c_int,
    pub fn XRRRotations (dpy: *mut Display, screen: c_int, current_rotation: *mut Rotation) -> Rotation,
    pub fn XRRSelectInput (dpy: *mut Display, window: Window, mask: c_int) -> (),
    pub fn XRRSetCrtcConfig (dpy: *mut Display, resources: *mut XRRScreenResources, crtc: RRCrtc, timestamp: Time, x: c_int, y: c_int, mode: RRMode, rotation: Rotation, outputs: *mut RROutput, noutputs: c_int) -> Status,
    pub fn XRRSetCrtcGamma (dpy: *mut Display, crtc: RRCrtc, gamma: *mut XRRCrtcGamma) -> (),
    pub fn XRRSetCrtcTransform (dpy: *mut Display, crtc: RRCrtc, transform: *mut XTransform, filter: *const c_char, params: *mut XFixed, nparams: c_int) -> (),
    pub fn XRRSetOutputPrimary (dpy: *mut Display, window: Window, output: RROutput) -> (),
    pub fn XRRSetPanning (dpy: *mut Display, resources: *mut XRRScreenResources, crtc: RRCrtc, panning: *mut XRRPanning) -> Status,
    pub fn XRRSetProviderOffloadSink (dpy: *mut Display, provider: XID, sink_provider: XID) -> c_int,
    pub fn XRRSetProviderOutputSource (dpy: *mut Display, provider: XID, source_provider: XID) -> c_int,
    pub fn XRRSetScreenConfig (dpy: *mut Display, config: *mut XRRScreenConfiguration, draw: Drawable, size_index: c_int, rotation: Rotation, timestamp: Time) -> Status,
    pub fn XRRSetScreenConfigAndRate (dpy: *mut Display, config: *mut XRRScreenConfiguration, draw: Drawable, size_index: c_int, rotation: Rotation, rate: c_short, timestamp: Time) -> Status,
    pub fn XRRSetScreenSize (dpy: *mut Display, window: Window, width: c_int, height: c_int, mmWidth: c_int, mmHeight: c_int) -> (),
    pub fn XRRSizes (dpy: *mut Display, screen: c_int, nsizes: *mut c_int) -> *mut XRRScreenSize,
    pub fn XRRTimes (dpy: *mut Display, screen: c_int, config_timestamp: *mut Time) -> Time,
    pub fn XRRUpdateConfiguration (event: *mut XEvent) -> c_int,
variadic:
globals:
}
