package cli_helpers

import (
	"os"
	"runtime"

	"github.com/sirupsen/logrus"
	"github.com/urfave/cli"

	"gitlab.com/gitlab-org/gitlab-runner/commands/steps"
	"gitlab.com/gitlab-org/gitlab-runner/common"
)

func LogRuntimePlatform(app *cli.App) {
	appBefore := app.Before
	app.Before = func(c *cli.Context) error {
		if c.Args().First() != steps.SubCommandName {
			fields := logrus.Fields{
				"os":       runtime.GOOS,
				"arch":     runtime.GOARCH,
				"version":  common.AppVersion.Version,
				"revision": common.AppVersion.Revision,
				"pid":      os.Getpid(),
			}
			logrus.WithFields(fields).Info("Runtime platform")
		}

		if appBefore != nil {
			return appBefore(c)
		}
		return nil
	}
}
